/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt101.api.MT101OriginatorData;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import models.Mt101PaymentForm;
import models.OriginatorForm;
import play.data.Form;
import play.i18n.Messages;
import views.Utils;

public final class MT101OriginatorForm
extends OriginatorForm {
    public String name2;
    public String street;
    public String town;
    public String senderBic;
    public String receiverBic;

    public static List<String> getAllBics(User user) {
        HashSet set = new HashSet();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            set.addAll(Account.findBicsForBank((BankSettings)bankUser.getBank()));
        }
        set.remove(null);
        set.remove("");
        ArrayList<String> result = new ArrayList<String>(set);
        Collections.sort(result);
        return result;
    }

    public MT101OriginatorForm() {
    }

    public MT101OriginatorForm(PaymentOriginator paymentOriginator) {
        MT101OriginatorData originator = new MT101OriginatorData();
        try {
            originator.setPaymentOriginator(paymentOriginator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.name = originator.getName();
        this.tenantId = originator.getTenant().getId();
        this.name2 = originator.getName2();
        this.street = originator.getStreet();
        this.town = originator.getTown();
        this.senderBic = originator.getSenderBic();
        this.receiverBic = originator.getReceiverBic();
        if (paymentOriginator.getDefaultAccount() != null) {
            this.defaultAccountId = paymentOriginator.getDefaultAccount().getId();
        }
    }

    @Override
    public Form<? extends OriginatorForm> validate(Form<? extends OriginatorForm> form, User user, Messages messages, PaymentOriginator paymentOriginator) {
        this.name = Mt101PaymentForm.convertToMt101StringFormat(this.name, 35);
        this.name2 = Mt101PaymentForm.convertToMt101StringFormat(this.name2, 35);
        this.street = Mt101PaymentForm.convertToMt101StringFormat(this.street, 35);
        this.town = Mt101PaymentForm.convertToMt101StringFormat(this.town, 35);
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            return form.withError("tenantId", tenantError);
        }
        this.tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        String accountError = this.checkAccountId(user);
        if (accountError != null) {
            return form.withError("defaultAccountId", accountError);
        }
        if (this.name == null || this.name.length() == 0) {
            form = form.withError("name", "error.required");
        } else if (!RegularExpressions.SWIFT.matches(this.name)) {
            form = form.withError("name", "error.invalid");
        } else {
            PaymentOriginator existingOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.MT101, (String)this.name, (Tenant)this.tenant);
            if (!(existingOriginator == null || paymentOriginator != null && paymentOriginator.getId() != null && paymentOriginator.getId().equals(existingOriginator.getId()))) {
                form = form.withError("name", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            }
        }
        if (this.name2 != null && this.name2.length() > 0 && !RegularExpressions.SWIFT.matches(this.name2)) {
            form = form.withError("name2", "error.invalid");
        }
        if (this.street != null && this.street.length() > 0 && !RegularExpressions.SWIFT.matches(this.street)) {
            form = form.withError("street", "error.invalid");
        }
        if (this.town != null && this.town.length() > 0 && !RegularExpressions.SWIFT.matches(this.town)) {
            form = form.withError("town", "error.invalid");
        }
        if (this.senderBic == null || this.senderBic.length() == 0) {
            form = form.withError("senderBic", "error.required");
        } else if (!RegularExpressions.BIC.matches(this.senderBic)) {
            form = form.withError("senderBic", "error.invalid");
        }
        if (this.receiverBic == null || this.receiverBic.length() == 0) {
            form = form.withError("receiverBic", "error.required");
        } else if (!RegularExpressions.BIC.matches(this.receiverBic)) {
            form = form.withError("receiverBic", "error.invalid");
        }
        return form;
    }

    @Override
    public void store(PaymentOriginator paymentOriginator, User user) throws IOException {
        MT101OriginatorData originatorData = new MT101OriginatorData();
        originatorData.setPaymentOriginator(paymentOriginator);
        boolean isNewOriginator = paymentOriginator.getId() == null;
        String oldName = originatorData.getName();
        boolean nameChanged = false;
        if (MT101OriginatorForm.isFieldEnabled("name", user)) {
            nameChanged = !isNewOriginator && Utils.fieldValueChanged(oldName, this.name);
            originatorData.setName(this.name);
        }
        if (MT101OriginatorForm.isFieldEnabled("name2", user)) {
            originatorData.setName2(this.name2);
        }
        if (MT101OriginatorForm.isFieldEnabled("street", user)) {
            originatorData.setStreet(this.street);
        }
        if (MT101OriginatorForm.isFieldEnabled("town", user)) {
            originatorData.setTown(this.town);
        }
        if (MT101OriginatorForm.isFieldEnabled("senderBic", user)) {
            originatorData.setSenderBic(this.senderBic);
        }
        if (MT101OriginatorForm.isFieldEnabled("receiverBic", user)) {
            originatorData.setReceiverBic(this.receiverBic);
        }
        Tenant oldTenant = originatorData.getTenant();
        boolean tenantChanged = false;
        if (MT101OriginatorForm.isFieldEnabled("tenantId", user)) {
            tenantChanged = !isNewOriginator && this.tenant == null && oldTenant != null || this.tenant != null && oldTenant == null || this.tenant != null && !this.tenant.getId().equals(oldTenant.getId());
            originatorData.setTenant(this.tenant);
        }
        Account oldAccount = originatorData.getDefaultAccount();
        boolean accountChanged = false;
        if (MT101OriginatorForm.isFieldEnabled("defaultAccountId", user)) {
            accountChanged = !isNewOriginator && this.defaultAccount == null && oldAccount != null || this.defaultAccount != null && oldAccount == null || this.defaultAccount != null && !this.defaultAccount.getId().equals(oldAccount.getId());
            originatorData.setDefaultAccount(this.defaultAccount);
        }
        originatorData.save();
        if (nameChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.NAME, (String)oldName, (String)this.name);
        }
        if (tenantChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.TENANT_ID, (String)(oldTenant == null ? null : oldTenant.getName() + " (" + oldTenant.getId() + ")"), this.tenant == null ? null : this.tenant.getName() + " (" + this.tenant.getId() + ")");
        }
        if (accountChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.DEFAULT_ACCOUNT, (String)(oldAccount == null ? null : oldAccount.getName() + " (" + oldAccount.getId() + ")"), this.defaultAccount == null ? null : this.defaultAccount.getName() + " (" + this.defaultAccount.getId() + ")");
        }
    }
}

