/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.branding.Branding;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.License;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.zkasecurity.KeyStore;
import io.ebean.Transaction;
import java.sql.Date;
import java.util.Collections;
import java.util.Locale;
import play.data.Form;
import play.data.validation.Constraints;

public class LoginSetup {
    @Constraints.Required
    @Constraints.Pattern(value="[a-zA-Z0-9]{11}", message="login.setup.invalid.license")
    public @Constraints.Required @Constraints.Pattern(value="[a-zA-Z0-9]{11}", message="login.setup.invalid.license") String license;
    @Constraints.Required
    public String username;
    @Constraints.Required
    public String password;
    @Constraints.Required
    public String password2;
    public boolean localUser;
    private String nameWithSuffix;
    private byte[] encryptionKey;

    public Form<LoginSetup> validate(Form<LoginSetup> form, Locale locale) {
        String requirement;
        if (!this.password.equals(this.password2)) {
            form = form.withError("password", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
            form = form.withError("password2", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
        }
        String suffix = Branding.getBranding().getUsernameSuffix().orElse("");
        this.nameWithSuffix = this.username + suffix;
        if (User.getUser((String)this.nameWithSuffix) != null) {
            form = form.withError("username", "login.setup.username.exists");
        }
        if (!form.hasErrors() && (requirement = PasswordRequirement.getRequirement().check(this.password.toCharArray(), null, locale)) != null) {
            form = form.withError("password", requirement);
        }
        try {
            this.encryptionKey = EncryptData.addEncryptionMarker((byte[])KeyStore.encryptData((byte[])EncryptData.createKey().getEncoded(), (char[])this.password.toCharArray()));
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to generate encryption for new user " + this.nameWithSuffix, e);
            form = form.withError("username", e.toString());
        }
        return form;
    }

    public User store() {
        try (Transaction t = DB.beginTransaction();){
            User u = new User();
            u.setAdmin(true);
            u.setName(this.nameWithSuffix);
            u.setEncryptionKey(this.encryptionKey);
            if (this.localUser) {
                u.setSecurityMedium(User.SecurityMedium.DUMMY);
                u.setKeyDirectory(".");
            }
            if (this.license != null) {
                u.setWebLicense(License.findById((String)this.license));
            }
            u.setLastPasswordChange(new Date(System.currentTimeMillis()));
            Tenant.ensureDefaultTenant();
            u.setTenants(Collections.singletonList(Tenant.getATenant()));
            u.setManagedTenants(Collections.singletonList(Tenant.getATenant()));
            u.save();
            t.commit();
            User user = u;
            return user;
        }
    }
}

