/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.Preferences;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class LoadDefaultPreferencesForm {
    public Integer tenantId;
    public Preferences.Type type;
    public Map<String, Boolean> selectedPreferences = new HashMap<String, Boolean>();

    public static String getLocalizedPreferenceValue(PreferenceStatus modifiedPreference, String value, Locale locale) {
        if (modifiedPreference.preferenceConstant.getType() == DatabasePreferenceConstant.DataType.BOOLEAN) {
            if (Boolean.parseBoolean(value)) {
                return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.yes", (Object[])new Object[0]);
            }
            return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.no", (Object[])new Object[0]);
        }
        if (modifiedPreference.preferenceConstant.getType() == DatabasePreferenceConstant.DataType.ENUM_COMBO || modifiedPreference.preferenceConstant.getType() == DatabasePreferenceConstant.DataType.ENUM_RADIO) {
            return Arrays.stream(modifiedPreference.preferenceConstant.getSelectableOptions(locale)).filter(v -> v[1].equals(value)).map(v -> v[0]).findAny().orElse("");
        }
        if (modifiedPreference.preferenceConstant.getType() == DatabasePreferenceConstant.DataType.BOOLEAN_GROUP) {
            if (modifiedPreference.preferenceConstant.getDefaultValue().equals(value)) {
                return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.useAll", (Object[])new Object[0]);
            }
            return BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.useSelection", (Object[])new Object[0]);
        }
        return value;
    }

    public static final class PreferenceStatus {
        public final DatabasePreferenceConstant preferenceConstant;
        public final String currentValue;
        public final String defaultValue;

        public PreferenceStatus(DatabasePreferenceConstant preferenceConstant, String currentValue, String defaultValue) {
            this.preferenceConstant = preferenceConstant;
            this.currentValue = currentValue;
            this.defaultValue = defaultValue;
        }
    }
}

