/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.cm.CmCheckReporter;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.Messages;
import de.businesslogics.banking.mt940.api.CFONB120Processing;
import de.businesslogics.banking.mt940.api.Camt052Processing;
import de.businesslogics.banking.mt940.api.Camt053Processing;
import de.businesslogics.banking.mt940.api.Camt054AdviceProcessing;
import de.businesslogics.banking.mt940.api.Camt054ProcessingApi;
import de.businesslogics.banking.mt940.api.CmReporter;
import de.businesslogics.banking.mt940.api.CmReporterApi;
import de.businesslogics.banking.mt940.api.DTIProcessingApi;
import de.businesslogics.banking.mt940.api.MT940Processing;
import de.businesslogics.banking.mt940.api.MT942Processing;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import models.cm.CmUtils;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class ImportStatementsForm {
    private static final String MT940 = "MT940";
    private static final String MT942 = "MT942";
    private static final String DTI = "DTI";
    private static final String C5N = "C5N";
    private static final String CAMT053 = "CAMT053";
    private static final String CAMT052 = "CAMT052";
    private static final String CAMT054 = "CAMT054";
    private static final String CFONB120 = "CFONB120";
    public int bankId;
    public String format;
    public boolean doAutomaticExports = false;
    public boolean marksAsNew = false;
    private CmCheckReporter reporter;

    public static Seq<Tuple2<String, String>> banksList(User user) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        for (BankSettings bank : BankSettings.findBanksForUser((User)user)) {
            Object bankName = bank.getDisplayName();
            if (user.getTenants().size() > 1) {
                bankName = (String)bankName + " (" + bank.getTenant().getName() + ")";
            }
            toReturn.add(new Tuple2((Object)bank.getBankId().toString(), (Object)Utils.addZWNJ((String)bankName)));
        }
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> formatList(Locale locale) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)MT940, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.MT940", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)CAMT053, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.CAMT053", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)CFONB120, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.CFONB120", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)MT942, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.MT942", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)CAMT052, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.CAMT052", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)C5N, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.CAMT054CreditAdvice", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)DTI, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.DTAUS", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)CAMT054, (Object)Messages.getString((Locale)locale, (String)"StatementImportWizard.CAMT054", (Object[])new Object[0])));
        return Scala.toSeq(toReturn);
    }

    public CmReporterApi getReporter() {
        return this.reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importAll(User user, List<File> files, play.i18n.Messages messages) {
        String error = null;
        this.reporter = null;
        if (files.isEmpty()) {
            return messages.at("cm.import.error.noFile", new Object[0]);
        }
        BankSettings bank = BankSettings.getByIdAndUser((Integer)this.bankId, (User)user);
        if (bank == null) {
            BLLoggerPlay.error("Bank does not exist or user does not have permission: " + this.bankId);
            return messages.at("bank.error.noSuchBank", new Object[0]);
        }
        FileInputStream in = null;
        try {
            try (Transaction t = DB.beginTransaction();){
                BLLogger logger = BLLoggerPlay.getLogger();
                EncryptData encrypt = EncryptData.getInstance();
                DatabasePreferenceStore preferences2 = new DatabasePreferenceStore(Preference.ApplicationId.CM, user, bank.getTenant());
                for (File file2 : files) {
                    MT940Processing processing;
                    in = new FileInputStream(file2);
                    if (MT940.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_STATEMENT, null, logger, encrypt, user);
                        }
                        processing = new MT940Processing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (MT942.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_ADVICE, null, logger, encrypt, user);
                        }
                        processing = new MT942Processing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (CAMT053.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_STATEMENT, null, logger, encrypt, user);
                        }
                        processing = new Camt053Processing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (CAMT052.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_ADVICE, null, logger, encrypt, user);
                        }
                        processing = new Camt052Processing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (CAMT054.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_DTI, "camt.054", logger, encrypt, user);
                        }
                        processing = new Camt054ProcessingApi(bank, (CmReporter)this.reporter, logger, encrypt, preferences2, CmUtils.getReportHandlers());
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (DTI.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_DTI, DTI, logger, encrypt, user);
                        }
                        processing = new DTIProcessingApi(bank, (CmReporter)this.reporter, logger, encrypt, preferences2, CmUtils.getReportHandlers());
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (CFONB120.equals(this.format)) {
                        if (this.reporter == null) {
                            this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_STATEMENT, null, logger, encrypt, user);
                        }
                        processing = new CFONB120Processing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                        processing.process((InputStream)in);
                        continue;
                    }
                    if (!C5N.equals(this.format)) continue;
                    if (this.reporter == null) {
                        this.reporter = this.createCmCheckReporter(CmReporter.Mode.IMPORT_ADVICE, null, logger, encrypt, user);
                    }
                    processing = new Camt054AdviceProcessing(bank, (CmReporter)this.reporter, logger, encrypt, preferences2);
                    processing.process((InputStream)in);
                }
                t.commit();
                if (this.reporter != null) {
                    this.reporter.finishProcessing(preferences2.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DELETE_OLD_ADVICES));
                }
            }
            Util.closeStream((Closeable)in);
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to import statement", e);
            error = messages.at("cm.import.error.exception", new Object[0]) + " " + e.toString();
        }
        finally {
            Util.closeStream(in);
        }
        return error;
    }

    private CmCheckReporter createCmCheckReporter(CmReporter.Mode mode, String format, BLLogger logger, EncryptData encrypt, User user) {
        CmCheckReporter toReturn = new CmCheckReporter(mode, format, logger, encrypt, user, CmUtils.getReportHandlers());
        toReturn.setDoCheckNewStatements(this.marksAsNew);
        toReturn.setDoAutomaticExports(this.doAutomaticExports);
        return toReturn;
    }
}

