/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.DsOrderPaymentInfo;
import de.businesslogics.banking.api.FormSettings;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.ebics.schema.orders.HVTOrderInfo;
import de.businesslogics.ebics.schema.types.AccountHolderRole;
import de.businesslogics.ebics.schema.types.AttributedAccount;
import java.util.Map;
import models.PaymentForm;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;

public final class HvtPaymentForm
extends PaymentForm {
    public String presenterName;
    public String presenterAccount;
    public String presenterBankcode;
    public String otherHolderName;
    public String otherHolderAccount;
    public String otherHolderBankcode;
    public String details;
    public String comment;
    private boolean isCredit;

    public HvtPaymentForm() {
    }

    public HvtPaymentForm(DsOpenOrder dsOpenOrder, HVTOrderInfo hvt) throws PaymentException {
        super(dsOpenOrder, false);
        this.setup(hvt);
    }

    public HvtPaymentForm(DsOrderDetails dsOrderDetails, HVTOrderInfo hvt) throws PaymentException {
        super(dsOrderDetails, false);
        this.setup(hvt);
    }

    @Override
    public PaymentHandler<?> loadPaymentHandler(User user) {
        return null;
    }

    @Override
    public boolean isUrgentPmtType(PaymentTransferType.PmtType pmtType) {
        return SepaApi.isUrgent((PaymentTransferType.PmtType)pmtType);
    }

    @Override
    public boolean isCredit() {
        return this.isCredit;
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        return null;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedOriginator(Form<? extends PaymentForm> form, Tenant tenant) {
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> internalValidate(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, User user, Map<String, String> flashMap) {
        return form;
    }

    @Override
    protected void internalRecipientHandling(User user, PaymentHandler<?> payment, Tenant tenant) {
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        return null;
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(HvtPaymentForm.class).fill((Object)this);
    }

    @Override
    protected FormSettings.Form getFormSettingsType() {
        return null;
    }

    private void setup(HVTOrderInfo hvt) {
        if (hvt.getAmount() != null) {
            this.amount = hvt.getAmount().getValue();
            this.currency = hvt.getAmount().getCurrency() != null ? hvt.getAmount().getCurrency().getCurrencyCode() : null;
            if (hvt.getAmount().getCredit() != null) {
                this.isCredit = hvt.getAmount().getCredit();
            }
        }
        this.executionDate = hvt.getExecutionDate().getDate();
        for (AttributedAccount account : hvt.getAccountInfos()) {
            String accountCurrency;
            String accountNumber2;
            String accountNumber1 = account.getAccountNumber() != null ? account.getAccountNumber().getValue() : null;
            String string = accountNumber2 = account.getAccountNumber2() != null ? account.getAccountNumber2().getValue() : null;
            if (account.getAccountHolder() == null || accountNumber1 == null && accountNumber2 == null) continue;
            String bankCode1 = account.getBankCode() != null ? account.getBankCode().getValue() : null;
            String bankCode2 = account.getBankCode2() != null ? account.getBankCode2().getValue() : null;
            String string2 = accountCurrency = account.getCurrency() != null ? account.getCurrency().getCurrencyCode() : null;
            if (account.getAccountHolder().getRole() == AccountHolderRole.Originator) {
                this.originatorName = account.getAccountHolder().getValue();
                Account accountVO = DsOrderPaymentInfo.findUnknownAccount(this.getBankFromVO(), accountNumber1, bankCode1, accountCurrency);
                if (accountVO == null) {
                    accountVO = DsOrderPaymentInfo.findUnknownAccount(this.getBankFromVO(), accountNumber2, bankCode2, accountCurrency);
                }
                if (accountVO != null) {
                    this.originatorAccountId = accountVO.getId();
                }
                this.originatorAccount = accountNumber1 != null ? accountNumber1 : accountNumber2;
                this.originatorBankCode = bankCode1 != null ? bankCode1 : bankCode2;
                continue;
            }
            if (account.getAccountHolder().getRole() == AccountHolderRole.Recipient) {
                this.recipientName = account.getAccountHolder().getValue();
                this.recipientAccount = account.getAccountNumber() != null ? account.getAccountNumber().getValue() : (account.getAccountNumber2() != null ? account.getAccountNumber2().getValue() : null);
                if (account.getBankCode() != null) {
                    this.recipientBankCode = account.getBankCode().getValue();
                    continue;
                }
                if (account.getAccountNumber2() != null) {
                    this.recipientBankCode = account.getBankCode2().getValue();
                    continue;
                }
                this.recipientBankCode = null;
                continue;
            }
            if (account.getAccountHolder().getRole() == AccountHolderRole.Presenter) {
                this.presenterName = account.getAccountHolder().getValue();
                this.presenterAccount = account.getAccountNumber() != null ? account.getAccountNumber().getValue() : (account.getAccountNumber2() != null ? account.getAccountNumber2().getValue() : null);
                if (account.getBankCode() != null) {
                    this.presenterBankcode = account.getBankCode().getValue();
                    continue;
                }
                if (account.getBankCode2() != null) {
                    this.presenterBankcode = account.getBankCode2().getValue();
                    continue;
                }
                this.presenterBankcode = null;
                continue;
            }
            if (account.getAccountHolder().getRole() != AccountHolderRole.Other) continue;
            this.otherHolderName = account.getAccountHolder().getValue();
            this.otherHolderAccount = account.getAccountNumber() != null ? account.getAccountNumber().getValue() : (account.getAccountNumber2() != null ? account.getAccountNumber2().getValue() : null);
            if (account.getBankCode() != null) {
                this.otherHolderBankcode = account.getBankCode().getValue();
                continue;
            }
            if (account.getBankCode2() != null) {
                this.otherHolderBankcode = account.getBankCode2().getValue();
                continue;
            }
            this.otherHolderBankcode = null;
        }
        for (HVTOrderInfo.MyDescription description : hvt.getDescriptions()) {
            if (description.getType() == HVTOrderInfo.DescriptionType.Purpose) {
                if (this.purpose == null) {
                    this.purpose = description.getValue();
                    continue;
                }
                this.purpose = this.purpose + description.getValue();
                continue;
            }
            if (description.getType() == HVTOrderInfo.DescriptionType.Details) {
                if (this.details == null) {
                    this.details = description.getValue();
                    continue;
                }
                this.details = this.details + description.getValue();
                continue;
            }
            if (description.getType() != HVTOrderInfo.DescriptionType.Comment) continue;
            if (this.comment == null) {
                this.comment = description.getValue();
                continue;
            }
            this.comment = this.comment + description.getValue();
        }
    }
}

