/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.PaymentTemplates;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTemplate;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.GenericPurposeHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.validation.Constraints;
import play.i18n.Messages;
import views.Utils;

public class GenerateOpenPaymentFromTemplateForm {
    public Integer generateFolderId;
    @Constraints.Required
    public Integer generateNumber = 1;
    public String paymentIds;
    private PaymentFolder paymentFolder;
    private List<PaymentTemplate> paymentTemplates;

    public boolean validate(User user, Map<String, String> flashMap, Messages messages) {
        boolean result = true;
        List<Integer> idsList = GeneralUtils.getSelectionIds(this.paymentIds);
        if (!idsList.isEmpty()) {
            this.paymentTemplates = PaymentTemplates.getQueryCheckPermission(user).where().in("id", idsList).findList();
        }
        if (this.paymentTemplates == null || this.paymentTemplates.isEmpty()) {
            flashMap.put("error", messages.at("paymenttemplates.notfound", new Object[0]));
            result = false;
        }
        this.paymentFolder = this.generateFolderId != null ? (this.generateFolderId < 0 ? PaymentFolder.NULL_FOLDER : PaymentFolder.findById((Integer)this.generateFolderId, (User)user)) : null;
        if (this.paymentFolder == null) {
            flashMap.put("error", messages.at("payment.error.unknownfolder", new Object[0]));
            result = false;
        }
        return result;
    }

    public void generate(User user, Map<String, String> flashMap, Messages messages) {
        int count = 0;
        if (this.generateNumber == null) {
            this.generateNumber = 1;
        }
        int numberOfDeactivatedPayments = 0;
        while (this.generateNumber > 0) {
            for (PaymentTemplate paymentTemplate : this.paymentTemplates) {
                try {
                    if (BankUser.findBankUser((BankSettings)paymentTemplate.getBank(), (User)user).isDeactivated()) {
                        ++numberOfDeactivatedPayments;
                        continue;
                    }
                    PaymentHandler<?> paymentHandler = PaymentHandler.getHandler(paymentTemplate.getPmtType(), paymentTemplate.getPaymentData());
                    String purpose = GenericPurposeHandler.getGenericPurposeHandlerForPaymentTemplate((PaymentTemplate)paymentTemplate).evaluatePurposeForDate(new Date());
                    if (purpose != null) {
                        ArrayList<String> purposeLines = new ArrayList<String>();
                        Collections.addAll(purposeLines, purpose.split("\n"));
                        paymentHandler.setPurpose(purposeLines);
                    }
                    paymentHandler.setEarliestExecutionDate(new Date(), paymentTemplate.getBank(), PaymentProperties.findExistingForBank((BankSettings)paymentTemplate.getBank()));
                    OpenPayment openPayment = paymentHandler.createOpenPayment(paymentTemplate.getBank(), paymentTemplate.getPmtType(), this.paymentFolder, false);
                    openPayment.save(user, false);
                    Logger.logOpenPaymentCreated((User)user, (OpenPayment)openPayment);
                    ++count;
                }
                catch (PaymentException e) {
                    BLLoggerPlay.error("Failed to create open payment from payment template!", e);
                    Utils.addToFlash(flashMap, "HTMLerror", messages.at("payment.error.failedtocreate", new Object[]{Utils.getLocalizedMessage(e, messages)}));
                }
            }
            Integer n = this.generateNumber;
            this.generateNumber = this.generateNumber - 1;
        }
        if (numberOfDeactivatedPayments > 0) {
            Utils.addToFlash(flashMap, "warning", messages.at("payment.error.deactivated", new Object[]{numberOfDeactivatedPayments}));
        }
        String flashKey = count == 0 ? "error" : "success";
        Utils.addToFlash(flashMap, flashKey, messages.at("payment.open.created", new Object[]{count}));
    }
}

