/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerAdmin;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.util.BLLogger;
import java.io.File;
import java.util.Objects;
import play.data.Form;

public class FolderForm {
    public Integer bankId;
    public String directory;
    public String regex;
    public String archiveDirectory;
    public String orderOrFileType;
    private BankSettings bankVO;

    public FolderForm() {
    }

    public FolderForm(DirectoryScanner directoryScanner) {
        this.bankId = directoryScanner.getBank().getBankId();
        this.directory = directoryScanner.getDirectory();
        this.regex = directoryScanner.getRegEx();
        this.archiveDirectory = directoryScanner.getArchiveDirectory();
        this.orderOrFileType = directoryScanner.getOrderOrFileType();
    }

    public Form<FolderForm> validate(Form<FolderForm> form, DirectoryScanner directoryScanner) {
        DirectoryScanner existing;
        if (this.bankId == null) {
            form = form.withError("bankId", "error.required");
        } else if (this.getBankVO() == null) {
            form = form.withError("bankId", "error.invalid");
        }
        if (this.directory == null || this.directory.length() == 0) {
            form = form.withError("directory", "error.required");
        }
        if (!(this.orderOrFileType != null && this.orderOrFileType.length() != 0 || this.regex != null && this.regex.contains("$(ORDERTYPE)"))) {
            form = form.withError("orderOrFileType", "folders.noordertype");
        }
        if (!((existing = (DirectoryScanner)DB.find(DirectoryScanner.class).where().eq("bank", (Object)this.getBankVO()).eq("directory", (Object)this.directory).eq("regEx", (Object)this.regex).setMaxRows(1).findOne()) == null || directoryScanner != null && existing.getId().equals(directoryScanner.getId()))) {
            form = form.withError("directory", "folders.exists");
        }
        if (!form.hasErrors()) {
            File dirFile = new File(this.directory);
            if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
                form = form.withError("directory", "error.invalid");
            }
            this.directory = dirFile.getAbsolutePath();
            if (this.archiveDirectory != null && this.archiveDirectory.length() > 0) {
                dirFile = new File(this.archiveDirectory);
                if (!dirFile.isDirectory() && !dirFile.mkdirs()) {
                    form = form.withError("archiveDirectory", "error.invalid");
                }
                this.archiveDirectory = dirFile.getAbsolutePath();
            }
        }
        return form;
    }

    public void save(User operator) {
        this.save(operator, new DirectoryScanner());
    }

    public void save(User operator, DirectoryScanner directoryScanner) {
        boolean newScanner = directoryScanner.getId() == null;
        BankSettings oldBank = directoryScanner.getBank();
        boolean bankChanged = !Objects.equals(this.getBankVO(), oldBank);
        directoryScanner.setBank(this.getBankVO());
        String oldDirectory = directoryScanner.getDirectory();
        boolean directoryChanged = !Objects.equals(this.directory, oldDirectory);
        directoryScanner.setDirectory(this.directory);
        String oldRegex = directoryScanner.getRegEx();
        boolean regexChanged = !Objects.equals(this.regex, oldRegex);
        directoryScanner.setRegEx(this.regex);
        String oldArchiveDir = directoryScanner.getArchiveDirectory();
        boolean archiveDirChanged = !Objects.equals(this.archiveDirectory, oldArchiveDir);
        directoryScanner.setArchiveDirectory(this.archiveDirectory);
        String oldOrderOrFileType = directoryScanner.getOrderOrFileType();
        boolean orderOrFileTypeChanged = !Objects.equals(this.orderOrFileType, oldOrderOrFileType);
        directoryScanner.setOrderOrFileType(this.orderOrFileType);
        DB.save((Object)directoryScanner);
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        if (newScanner) {
            logger.logDirectoryScannerCreated(operator, directoryScanner);
        } else {
            if (bankChanged) {
                logger.logDirectoryScannerChangedBank(operator, directoryScanner, oldBank);
            }
            if (directoryChanged) {
                logger.logDirectoryScannerChangedDirectory(operator, directoryScanner, oldDirectory);
            }
            if (regexChanged) {
                logger.logDirectoryScannerChangedRegex(operator, directoryScanner, oldRegex);
            }
            if (archiveDirChanged) {
                logger.logDirectoryScannerChangedArchiveDir(operator, directoryScanner, oldArchiveDir);
            }
            if (orderOrFileTypeChanged) {
                logger.logDirectoryScannerChangedOrderOrFileType(operator, directoryScanner, oldOrderOrFileType);
            }
        }
    }

    private BankSettings getBankVO() {
        if (this.bankId == null || this.bankId < 0) {
            return null;
        }
        if (this.bankVO != null && this.bankId.equals(this.bankVO.getBankId())) {
            return this.bankVO;
        }
        this.bankVO = BankSettings.getById((Integer)this.bankId);
        return this.bankVO;
    }
}

