/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.FetchFilter;
import de.businesslogics.banking.database.vo.FilterComparator;
import de.businesslogics.banking.database.vo.User;
import java.util.Date;
import play.data.Form;

public final class FetchFilterForm {
    public Integer bank;
    public Integer orderTypeComparator;
    public String orderType;
    public Integer fetcherComparator;
    public String fetcher;
    public Integer dateComparator;
    public Date dateFrom;
    public Date dateTo;

    public FetchFilterForm() {
    }

    public FetchFilterForm(FetchFilter fetchFilter) {
        BankSettings b;
        User user = fetchFilter.getUser();
        if (fetchFilter.getBank() != null && (b = BankSettings.getByIdAndUser((Integer)fetchFilter.getBank().getBankId(), (User)user)) != null) {
            this.bank = b.getBankId();
        }
        if (fetchFilter.getOrderTypeComparator() != null) {
            this.orderTypeComparator = fetchFilter.getOrderTypeComparator().ordinal();
        }
        this.orderType = fetchFilter.getOrderType();
        if (fetchFilter.getFetcherComparator() != null) {
            this.fetcherComparator = fetchFilter.getFetcherComparator().ordinal();
        }
        this.fetcher = fetchFilter.getFetcher();
        this.dateComparator = fetchFilter.getDateComparatorIndex();
        if (this.dateComparator < 0) {
            this.dateComparator = null;
        }
        this.dateFrom = fetchFilter.getFromDate();
        this.dateTo = fetchFilter.getToDate();
    }

    public Form<FetchFilterForm> validate(Form<FetchFilterForm> form, FetchFilter fetchFilter) {
        User user = fetchFilter.getUser();
        if (this.bank == null || this.bank < 0) {
            fetchFilter.setBank(null);
        } else {
            BankSettings b = BankSettings.getByIdAndUser((Integer)this.bank, (User)user);
            if (b != null) {
                fetchFilter.setBank(b);
            } else {
                form = form.withError("bank", "error.invalid");
            }
        }
        fetchFilter.setOrderTypeComparator(this.orderTypeComparator.intValue());
        fetchFilter.setOrderType(this.orderType);
        fetchFilter.setFetcherComparator(this.fetcherComparator.intValue());
        fetchFilter.setFetcher(this.fetcher);
        if (this.dateComparator == null || this.dateComparator < 0) {
            fetchFilter.setDateComparator(null);
            fetchFilter.setFromDate(null);
            fetchFilter.setToDate(null);
            if (this.dateFrom != null || this.dateTo != null) {
                form = form.withError("dateComparator", "error.invalid");
            }
        } else {
            fetchFilter.setDateComparatorIndex(this.dateComparator.intValue());
            if (fetchFilter.getDateComparator() == FilterComparator.Date.BETWEEN) {
                if (this.dateFrom == null && this.dateTo == null) {
                    fetchFilter.setFromDate(null);
                    fetchFilter.setToDate(null);
                    fetchFilter.setDateComparator(null);
                } else {
                    if (this.dateFrom == null) {
                        fetchFilter.setFromDate(null);
                    } else {
                        fetchFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                    }
                    if (this.dateTo == null) {
                        fetchFilter.setDateComparator(FilterComparator.Date.GREATER);
                        fetchFilter.setToDate(null);
                    } else if (this.dateFrom == null) {
                        fetchFilter.setDateComparator(FilterComparator.Date.LESS);
                        fetchFilter.setFromDate(new java.sql.Date(this.dateTo.getTime()));
                    } else {
                        fetchFilter.setToDate(new java.sql.Date(this.dateTo.getTime()));
                    }
                }
            } else {
                if (this.dateFrom == null) {
                    form = form.withError("dateFrom", "error.invalid");
                    fetchFilter.setFromDate(null);
                } else {
                    fetchFilter.setFromDate(new java.sql.Date(this.dateFrom.getTime()));
                }
                fetchFilter.setToDate(null);
            }
        }
        return form;
    }
}

