/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.routes;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.BTFTranslator;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import play.data.Form;
import play.data.validation.Constraints;
import play.libs.Json;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class FetchFileForm {
    @Constraints.Required
    public Integer bankId;
    @Constraints.Required
    public String orderOrFileType;
    public boolean fromToFetch = true;
    public Date fromDate = new Date();
    public Date toDate = new Date();
    private BankUser bankUser;

    public static String loadJsParameters(User user) {
        ObjectNode resultJson = Json.newObject();
        ArrayNode ebics3BanksNode = resultJson.putArray("ebics3Banks");
        Seq<Tuple2<String, String>> readyEbics3Banks = GeneralUtils.getReadyBanks(user.getName(), false, true);
        readyEbics3Banks.foreach(v2 -> ebics3BanksNode.add((String)v2._1));
        resultJson.put("userIsAdmin", user.isAdmin() || user.isTenantAdmin());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadBtfModalJsParameters(String btfModalHtmlID, String btfTextFieldHtmlID, String btfButtonHtmlID) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("createBtfStringUrl", routes.BtfUtils.mergeBtfString("SERVICE_NAME", "SERVICE_OPTION", "SCOPE", "CONTAINER", "MESSAGE", "VARIANT", "VERSION", "FORMAT", "false").toString());
        resultJson.put("splitBtfStringUrl", routes.BtfUtils.splitBtfString("BTF_STRING", "PMT_TYPE_NAME", -1).toString());
        resultJson.put("modalHtmlID", btfModalHtmlID);
        ArrayNode pmtTypesNode = resultJson.putArray("btfElements");
        ObjectNode btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", btfTextFieldHtmlID);
        btfElement.put("buttonHtmlID", btfButtonHtmlID);
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public Form<FetchFileForm> validate(Form<FetchFileForm> form, User user) {
        boolean isFrenchBank;
        BankSettings bank = BankSettings.getById((Integer)this.bankId);
        if (bank == null) {
            form = form.withError("bankId", "fetched.fetch.error.nobank");
            isFrenchBank = false;
        } else {
            this.bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
            if (this.bankUser == null || this.bankUser.getState() != BankUser.UserState.READY) {
                form = form.withError("bankId", "fetched.fetch.error.nobankaccess");
            }
            isFrenchBank = bank.isFrenchBank();
        }
        if (this.orderOrFileType == null || this.orderOrFileType.isEmpty()) {
            form = form.withError("orderOrFileType", "error.required");
        } else if (bank != null && BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion())) {
            if (!this.orderOrFileType.matches("[A-Z0-9]{3}") && !BTFTranslator.isBTFString((String)this.orderOrFileType)) {
                form = form.withError("orderOrFileType", "fetched.fetch.error.invalidordertype");
            }
        } else if (!isFrenchBank && !this.orderOrFileType.matches("[A-Z0-9]{3}")) {
            form = form.withError("orderOrFileType", "fetched.fetch.error.invalidordertype");
        }
        if (this.fromToFetch) {
            if (this.fromDate == null) {
                form = form.withError("fromDate", "error.required");
            } else if (this.toDate == null) {
                form = form.withError("toDate", "error.required");
            }
            if (this.fromDate != null && this.toDate != null && this.fromDate.after(this.toDate)) {
                form = form.withError("toDate", "fetched.fetch.error.invaliddaterange");
            }
        } else {
            this.fromDate = null;
            this.toDate = null;
        }
        return form;
    }

    public BankUser getBankUser() {
        return this.bankUser;
    }
}

