/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.api.RecipientData;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.Locale;
import models.DtazvPaymentForm;
import models.RecipientForm;
import play.data.Form;
import play.i18n.Messages;
import views.Utils;

public final class DtazvRecipientForm
extends RecipientForm {
    public String name2;
    public String street;
    public String town;
    public String countryCode;
    public String accountNumber;
    public String bankCode;
    public String bankName;
    public String bankName2;
    public String bankStreet;
    public String bankTown;
    public String bankCountryCode;
    public String purpose1;
    public String purpose2;
    public String purpose3;
    public String purpose4;
    public String bankNameDisplay;
    public String feeType;

    public DtazvRecipientForm() {
    }

    public DtazvRecipientForm(PaymentRecipient paymentRecipient) {
        String sclBankName;
        DtazvRecipientData recipient = new DtazvRecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.name2 = recipient.getName2();
        this.street = recipient.getStreet();
        this.town = recipient.getTown();
        this.countryCode = recipient.getCountry();
        this.accountNumber = IbanUtil.formatIfIBAN((String)recipient.getAccountNumber());
        this.bankCode = recipient.getBankCode();
        this.bankName = recipient.getBankName();
        this.bankName2 = recipient.getBankName2();
        this.bankStreet = recipient.getBankStreet();
        this.bankTown = recipient.getBankTown();
        this.bankCountryCode = recipient.getBankCountry();
        this.purpose1 = recipient.getPurpose1();
        this.purpose2 = recipient.getPurpose2();
        this.purpose3 = recipient.getPurpose3();
        this.purpose4 = recipient.getPurpose4();
        this.feeType = recipient.getFeeType();
        if (this.bankCode != null && RegularExpressions.BIC.matches(this.bankCode) && (sclBankName = BicLoader.getInstance().getBankName(this.bankCode)) != null) {
            this.bankNameDisplay = sclBankName;
        }
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        this.name = DtazvPaymentForm.convertToDtazvStringFormat(this.name, 35);
        this.name2 = DtazvPaymentForm.convertToDtazvStringFormat(this.name2, 35);
        this.street = DtazvPaymentForm.convertToDtazvStringFormat(this.street, 35);
        this.town = DtazvPaymentForm.convertToDtazvStringFormat(this.town, 35);
        this.bankName = DtazvPaymentForm.convertToDtazvStringFormat(this.bankName, 35);
        this.bankName2 = DtazvPaymentForm.convertToDtazvStringFormat(this.bankName2, 35);
        this.bankStreet = DtazvPaymentForm.convertToDtazvStringFormat(this.bankStreet, 35);
        this.bankTown = DtazvPaymentForm.convertToDtazvStringFormat(this.bankTown, 35);
        this.purpose1 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose1, 35);
        this.purpose2 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose2, 35);
        this.purpose3 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose3, 35);
        this.purpose4 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose4, 35);
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (this.accountNumber != null && this.accountNumber.length() > 0) {
            this.accountNumber = this.accountNumber.replaceAll(" ", "").trim();
        }
        if (this.bankCode != null && this.bankCode.length() > 0) {
            this.bankCode = this.bankCode.replaceAll(" ", "").trim();
        }
        if (this.displayName == null || this.displayName.length() == 0) {
            form = form.withError("displayName", messages.at("error.required", new Object[0]));
        }
        if (this.name == null || this.name.length() == 0) {
            form = form.withError("name", messages.at("error.required", new Object[0]));
        } else if (!RegularExpressions.DTAZV_GUI.matches(this.name)) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        }
        if (this.name2 != null && this.name2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.name2)) {
            form = form.withError("name2", messages.at("error.invalid", new Object[0]));
        }
        if (this.street != null && this.street.length() > 0) {
            if (!RegularExpressions.DTAZV_GUI.matches(this.street)) {
                form = form.withError("street", messages.at("error.invalid", new Object[0]));
            }
        } else if (this.accountNumber == null || this.accountNumber.length() == 0) {
            form = form.withError("street", messages.at("recipients.error.dtazv.bankconnectionoraddressneeded", new Object[0]));
        }
        if (this.town != null && this.town.length() > 0) {
            if (!RegularExpressions.DTAZV_GUI.matches(this.town)) {
                form = form.withError("town", messages.at("error.invalid", new Object[0]));
            }
        } else if (this.accountNumber == null || this.accountNumber.length() == 0) {
            form = form.withError("town", messages.at("recipients.error.dtazv.bankconnectionoraddressneeded", new Object[0]));
        }
        if (this.countryCode == null || this.countryCode.length() == 0) {
            form = form.withError("countryCode", messages.at("error.required", new Object[0]));
        } else if (CountriesLoader.getInstance((Locale)messages.lang().locale()).getCountryName(this.countryCode) == null) {
            form = form.withError("countryCode", messages.at("error.invalid", new Object[0]));
        }
        if (this.bankName != null && this.bankName.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.bankName)) {
            form = form.withError("bankName", messages.at("error.invalid", new Object[0]));
        }
        if (this.bankName2 != null && this.bankName2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.bankName2)) {
            form = form.withError("bankName", messages.at("error.invalid", new Object[0]));
        }
        if (this.bankStreet != null && this.bankStreet.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.bankStreet)) {
            form = form.withError("bankStreet", messages.at("error.invalid", new Object[0]));
        }
        if (this.bankTown != null && this.bankTown.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.bankTown)) {
            form = form.withError("bankTown", messages.at("error.invalid", new Object[0]));
        }
        if (this.bankCountryCode != null && this.bankCountryCode.length() > 0 && CountriesLoader.getInstance((Locale)messages.lang().locale()).getCountryName(this.bankCountryCode) == null) {
            form = form.withError("bankCountryCode", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose1 != null && this.purpose1.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose1)) {
            form = form.withError("purpose1", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose2 != null && this.purpose2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose2)) {
            form = form.withError("purpose2", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose3 != null && this.purpose3.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose3)) {
            form = form.withError("purpose3", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose4 != null && this.purpose4.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose4)) {
            form = form.withError("purpose4", messages.at("error.invalid", new Object[0]));
        }
        boolean allowInvalidBankConnections = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        if (this.accountNumber == null || this.accountNumber.length() == 0) {
            if (!(this.street != null && this.street.length() != 0 || this.town != null && this.town.length() != 0)) {
                form = form.withError("accountNumber", messages.at("recipients.error.dtazv.bankconnectionoraddressneeded", new Object[0]));
            }
        } else if (!allowInvalidBankConnections && RegularExpressions.IBAN.matches(this.accountNumber) && !IbanUtil.checkIban((String)this.accountNumber)) {
            form = form.withError("accountNumber", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.accountNumber == null || this.accountNumber.length() <= 0 || this.bankCode != null && this.bankCode.length() != 0 || this.bankName != null && this.bankName.length() != 0 && this.bankStreet != null && this.bankStreet.length() != 0 && this.bankTown != null && this.bankTown.length() != 0 && this.bankCountryCode != null && this.bankCountryCode.length() != 0)) {
            form = form.withError("bankTown", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        boolean isNewRecipient;
        Tenant tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        boolean bl = isNewRecipient = paymentRecipient.getId() == null;
        if (isNewRecipient) {
            this.displayName = RecipientData.getUniqueDisplayName((String)this.displayName, (PaymentType)PaymentType.DTAZV, (Tenant)tenant);
        }
        DtazvRecipientData recipientData = new DtazvRecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        if (DtazvRecipientForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            recipientData.setDisplayName(this.displayName);
        }
        String oldName = paymentRecipient.getName();
        boolean nameChanged = false;
        if (DtazvRecipientForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            nameChanged = !isNewRecipient && Utils.fieldValueChanged(oldName, this.name);
            recipientData.setName(this.name);
        }
        if (DtazvRecipientForm.isFieldEnabled("name2", user, paymentRecipient.getId())) {
            recipientData.setName2(this.name2);
        }
        if (DtazvRecipientForm.isFieldEnabled("street", user, paymentRecipient.getId())) {
            recipientData.setStreet(this.street);
        }
        if (DtazvRecipientForm.isFieldEnabled("town", user, paymentRecipient.getId())) {
            recipientData.setTown(this.town);
        }
        if (DtazvRecipientForm.isFieldEnabled("countryCode", user, paymentRecipient.getId())) {
            recipientData.setCountry(this.countryCode);
        }
        String oldAccNbr = recipientData.getAccountNumber();
        boolean accNbrChanged = false;
        if (DtazvRecipientForm.isFieldEnabled("accountNumber", user, paymentRecipient.getId())) {
            accNbrChanged = !isNewRecipient && Utils.fieldValueChanged(oldAccNbr, this.accountNumber);
            recipientData.setAccountNumber(this.accountNumber);
        }
        String oldBankCode = recipientData.getBankCode();
        boolean bankCodeChanged = false;
        if (DtazvRecipientForm.isFieldEnabled("bankCode", user, paymentRecipient.getId())) {
            bankCodeChanged = !isNewRecipient && Utils.fieldValueChanged(oldBankCode, this.bankCode);
            recipientData.setBankCode(this.bankCode);
        }
        if (DtazvRecipientForm.isFieldEnabled("bankName", user, paymentRecipient.getId())) {
            recipientData.setBankName(this.bankName);
        }
        if (DtazvRecipientForm.isFieldEnabled("bankName2", user, paymentRecipient.getId())) {
            recipientData.setBankName2(this.bankName2);
        }
        if (DtazvRecipientForm.isFieldEnabled("bankStreet", user, paymentRecipient.getId())) {
            recipientData.setBankStreet(this.bankStreet);
        }
        if (DtazvRecipientForm.isFieldEnabled("bankTown", user, paymentRecipient.getId())) {
            recipientData.setBankTown(this.bankTown);
        }
        if (DtazvRecipientForm.isFieldEnabled("bankCountryCode", user, paymentRecipient.getId())) {
            recipientData.setBankCountry(this.bankCountryCode);
        }
        if (DtazvRecipientForm.isFieldEnabled("feeType", user, paymentRecipient.getId())) {
            recipientData.setFeeType(this.feeType);
        }
        if (DtazvRecipientForm.isFieldEnabled("purpose1", user, paymentRecipient.getId())) {
            recipientData.setPurpose1(this.purpose1);
        }
        if (DtazvRecipientForm.isFieldEnabled("purpose2", user, paymentRecipient.getId())) {
            recipientData.setPurpose2(this.purpose2);
        }
        if (DtazvRecipientForm.isFieldEnabled("purpose3", user, paymentRecipient.getId())) {
            recipientData.setPurpose3(this.purpose3);
        }
        if (DtazvRecipientForm.isFieldEnabled("purpose4", user, paymentRecipient.getId())) {
            recipientData.setPurpose4(this.purpose4);
        }
        if (DtazvRecipientForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            recipientData.setTenant(tenant);
        }
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
        if (nameChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.NAME, (String)oldName, (String)this.name);
        }
        if (accNbrChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.ACCOUNT_NUMBER, (String)oldAccNbr, (String)this.accountNumber);
        }
        if (bankCodeChanged) {
            Logger.logRecipientModified((User)user, (PaymentRecipient)paymentRecipient, (Logger.RecipientField)Logger.RecipientField.BANK_CODE, (String)oldBankCode, (String)this.bankCode);
        }
    }
}

