/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.CountriesLoader;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.FormSettings;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.api.PermissionsLoader;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvApi;
import de.businesslogics.banking.dta.api.DtazvOriginatorData;
import de.businesslogics.banking.dta.api.DtazvRecipientData;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.format.dta.DTAReader;
import de.businesslogics.format.dta.DTAZVPayment;
import de.businesslogics.format.dta.DTAZVTransaction;
import de.businesslogics.format.dta.DtazvPaymentType;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.validation.RegularExpressions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import models.PaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import play.data.Form;
import play.data.FormFactory;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class DtazvPaymentForm
extends PaymentForm {
    public static final PaymentTransferType.PmtType[] PMT_TYPES = new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.DTAZV_TRANSFER};
    public static final BigDecimal MAX_AMOUNT = new BigDecimal("99999999999999.999");
    public static final BigDecimal EUE_MAX_AMOUNT = BigDecimal.valueOf(50000L);
    private DTAZVPayment paymentData;
    public boolean counterValue;
    public String counterValueCurrency = "EUR";
    public String purpose2;
    public String purpose3;
    public String purpose4;
    @Constraints.Required
    public String azvPaymentType;
    public String originatorName2;
    public String originatorStreet;
    public String originatorTown;
    public String originatorContact;
    public String originatorReference;
    public String originatorCustomerNumber;
    public String recipientName2;
    public String recipientStreet;
    public String recipientTown;
    public String recipientCountryCode;
    public String recipientOrderComment1;
    public String recipientOrderComment2;
    public String recipientBankName;
    public String recipientBankName2;
    public String recipientBankStreet;
    public String recipientBankTown;
    public String recipientBankCountryCode;
    public String recipientBankNameDisplay;
    public Integer feeAccountId;
    public String feeType;
    public String instructionCode1;
    public String instructionCode2;
    public String instructionCode3;
    public String instructionCode4;
    public String instructionAdditionalInfo;

    public static boolean isAzvPmtType(PaymentTransferType.PmtType pmtType) {
        return Arrays.asList(PMT_TYPES).contains(pmtType);
    }

    public static List<DtazvOriginatorData> loadOriginators(User user) {
        ArrayList<DtazvOriginatorData> result = new ArrayList<DtazvOriginatorData>();
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findOriginatorsForPaymentType((PaymentType)PaymentType.DTAZV, (List)user.getTenants())) {
            DtazvOriginatorData dtazvOriginatorData = new DtazvOriginatorData();
            try {
                dtazvOriginatorData.setPaymentOriginator(paymentOriginator);
                result.add(dtazvOriginatorData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load SEPA originator with ID: " + paymentOriginator.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        return result;
    }

    public static Seq<Tuple2<String, String>> loadOriginatorSequence(User user, boolean includeEmptyLine) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmptyLine) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        for (DtazvOriginatorData originator : DtazvPaymentForm.loadOriginators(user)) {
            result.add(Scala.Tuple((Object)originator.getPaymentOriginator().getId().toString(), (Object)Utils.addZWNJ(originator.getName())));
        }
        return Scala.toSeq(result);
    }

    public static int getRecipientsCount(User user) {
        ArrayList<PaymentType> paymentTypes = new ArrayList<PaymentType>();
        paymentTypes.add(PaymentType.DTAZV);
        return PaymentRecipient.countRecipientsForPaymentTypes(paymentTypes, (List)user.getTenants());
    }

    public static List<DtazvRecipientData> loadRecipients(User user) {
        ArrayList<DtazvRecipientData> result = new ArrayList<DtazvRecipientData>();
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)PaymentType.DTAZV, (List)user.getTenants())) {
            DtazvRecipientData dtazvRecipientData = new DtazvRecipientData();
            try {
                dtazvRecipientData.setPaymentRecipient(paymentRecipient);
                result.add(dtazvRecipientData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load recipient with ID " + paymentRecipient.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return result;
    }

    public static boolean isFieldEnabled(String fieldName, User operator) {
        boolean allowOriginatorRecording = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, operator).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean allowRecipientRecording = PreferenceUtil.allowUnrestrictedRecipientRecording((User)operator);
        if ("originatorName2".equals(fieldName) || "originatorStreet".equals(fieldName) || "originatorTown".equals(fieldName) || "originatorContact".equals(fieldName)) {
            return allowOriginatorRecording;
        }
        if ("recipientCountryCode".equals(fieldName) || "recipientBankCountryCode".equals(fieldName) || "recipientAccount".equals(fieldName) || "recipientBankCode".equals(fieldName) || "recipientName2".equals(fieldName) || "recipientStreet".equals(fieldName) || "recipientTown".equals(fieldName) || "recipientBankName".equals(fieldName) || "recipientBankName2".equals(fieldName) || "recipientBankStreet".equals(fieldName) || "recipientBankTown".equals(fieldName)) {
            return allowRecipientRecording;
        }
        return true;
    }

    public static String loadJsParameters(User user, Messages messages, boolean isNew, boolean formHasError) {
        ObjectNode node;
        DatabasePreferenceStore paymentsPreferenceStore = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user);
        boolean overwriteRecipientData = isNew || paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.OVERWRITE_RECIPIENT_DATA);
        boolean allowOriginatorRecording = paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        boolean initializeAccountAndOriginator = isNew && !PreferenceConstants.InitializationOfAccAndOrig.NONE.name().equals(paymentsPreferenceStore.getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG));
        ObjectNode resultJson = Json.newObject();
        resultJson.put("initializeAccountAndOriginator", initializeAccountAndOriginator);
        resultJson.put("hasError", formHasError);
        resultJson.put("isNew", isNew);
        resultJson.put("overwriteRecipientData", overwriteRecipientData);
        resultJson.put("showRecipientWithAccountNumber", paymentsPreferenceStore.getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISPLAY_RECIPIENTS_WITH_ACCOUNT_NUMBER));
        resultJson.put("searchOriginatorsUrl", routes.Payments.findOriginators("SEARCH", 999, "DTAZV").toString());
        resultJson.put("searchRecipientsUrl", routes.Payments.findRecipients("SEARCH", 999, "DTAZV").toString());
        resultJson.put("searchOriginatorCustomerNumberUrl", routes.Payments.findDtazvCustomerNumberForOriginatorAccount(999).toString());
        resultJson.put("displayNameLocalized", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.displayName", (Object[])new Object[0]));
        PermissionsLoader.AccountType accountType = PermissionsLoader.AccountType.GERMAN;
        ArrayNode accountsNode = resultJson.putArray("accounts");
        for (Object account : new PermissionsLoader(user).loadAccounts(new String[]{"AZV", "XCT:DE_dtazv"}, accountType)) {
            node = accountsNode.addObject();
            node.put("accountId", account.getId());
            if (account.getCurrency() != null && !account.getCurrency().isEmpty()) {
                node.put("currency", account.getCurrency());
            }
            if (account.getAccountHolder() != null && !account.getAccountHolder().isEmpty()) {
                node.put("holder", DtazvPaymentForm.convertToDtazvStringFormat(account.getAccountHolder(), 35));
            }
            if (account.getDtazvOriginator() != null) {
                if (allowOriginatorRecording) {
                    node.put("defaultOriginator", account.getDtazvOriginator().getName());
                } else {
                    node.put("defaultOriginator", account.getDtazvOriginator().getId());
                }
            }
            if (user.getTenants().size() <= 1) continue;
            node.put("tenantId", account.getBank().getTenant().getId());
        }
        ArrayNode originatorsNode = resultJson.putArray("originators");
        for (DtazvOriginatorData originator : DtazvPaymentForm.loadOriginators(user)) {
            node = originatorsNode.addObject();
            node.put("id", originator.getPaymentOriginator().getId());
            if (user.getTenants().size() > 1) {
                node.put("tenantId", originator.getPaymentOriginator().getTenant().getId());
            }
            if (originator.getDefaultAccount() != null) {
                node.put("defaultAccountId", originator.getDefaultAccount().getId());
            }
            node.put("name", originator.getName());
            node.put("name2", originator.getName2());
            node.put("street", originator.getStreet());
            node.put("town", originator.getTown());
            node.put("contact", originator.getContact());
        }
        if (user.getTenants().size() > 1) {
            ArrayNode recipientsNode = resultJson.putArray("recipients");
            for (DtazvRecipientData recipientData : DtazvPaymentForm.loadRecipients(user)) {
                recipientsNode.addObject().put("id", recipientData.getPaymentRecipient().getId()).put("tenantId", recipientData.getPaymentRecipient().getTenant().getId());
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public DtazvPaymentForm() {
    }

    public DtazvPaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, PaymentFolder folder, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, folder, saveRecipient);
        Account account;
        this.paymentData = new DTAZVPayment();
        this.paymentData.getTransactions().add(new DTAZVTransaction());
        this.isUrgent = this.isUrgentPmtType(pmtType);
        this.currency = "EUR";
        this.counterValueCurrency = "EUR";
        if (this.originatorAccountId != null && (account = (Account)DB.find(Account.class, (Object)this.originatorAccountId)) != null) {
            this.originatorCustomerNumber = account.getGermanAccountNumber();
        }
    }

    public DtazvPaymentForm(Object databaseVO, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(databaseVO, saveRecipient);
        this.loadPayment();
        this.loadPaymentDataInfo(allowRecipientRecording);
        this.fillInBankNameForDisplaying();
    }

    private void fillInBankNameForDisplaying() {
        String sclBankName;
        if (this.recipientBankCode != null && RegularExpressions.BIC.matches(this.recipientBankCode) && (sclBankName = BicLoader.getInstance().getBankName(this.recipientBankCode)) != null) {
            this.recipientBankNameDisplay = sclBankName;
        }
    }

    public DtazvPaymentForm(Object dsOrder, DTAZVPayment paymentData, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(dsOrder, saveRecipient);
        Account account;
        this.paymentData = paymentData;
        this.loadPaymentDataInfo(allowRecipientRecording);
        this.isUrgent = this.isUrgentPmtType(this.getPmtType());
        this.fillInBankNameForDisplaying();
        if (this.originatorAccountId != null && (account = (Account)DB.find(Account.class, (Object)this.originatorAccountId)) != null) {
            this.originatorCustomerNumber = account.getGermanAccountNumber();
        }
    }

    @Override
    public PaymentHandler<?> loadPaymentHandler(User user) throws PaymentException {
        Account originatorAccount;
        if (this.paymentData == null) {
            this.loadPayment();
        }
        boolean newPayment = false;
        if (this.paymentData == null) {
            this.paymentData = new DTAZVPayment();
            this.paymentData.getTransactions().add(new DTAZVTransaction());
            newPayment = true;
        }
        if ((originatorAccount = (Account)DB.find(Account.class, (Object)this.originatorAccountId)) != null && originatorAccount.getGermanBankCode() != null) {
            this.paymentData.setBlz(Integer.parseInt(originatorAccount.getGermanBankCode()));
        }
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.ORIGINATOR, this.paymentData.getOriginator(), this.originatorName);
        }
        this.paymentData.setOriginator(this.originatorName);
        this.paymentData.setOriginator2(this.originatorName2);
        this.paymentData.setOriginator3(this.originatorStreet);
        this.paymentData.setOriginator4(this.originatorTown);
        this.paymentData.setCustomerNumber(Long.parseLong(this.originatorCustomerNumber));
        if (!newPayment) {
            this.reportFieldChange(Logger.PaymentField.EXECUTION_DATE, this.paymentData.getExecutionDate(), this.executionDate);
        }
        this.paymentData.setExecutionDate(this.executionDate);
        DTAZVTransaction transaction = this.getTransaction();
        if (transaction != null) {
            Account feeAccount;
            if (originatorAccount != null) {
                if (originatorAccount.getGermanAccountNumber() != null) {
                    transaction.setAccount(Long.parseLong(originatorAccount.getGermanAccountNumber()));
                }
                if (originatorAccount.getGermanBankCode() != null) {
                    transaction.setBlz(Integer.parseInt(originatorAccount.getGermanBankCode()));
                }
                transaction.setAccountCurrency(originatorAccount.getCurrency());
            }
            if (this.recipientAccount != null) {
                String newIban = "/" + this.recipientAccount.replace(" ", "").trim();
                if (!newPayment) {
                    this.reportFieldChange(Logger.PaymentField.RECIPIENT_ACCOUNT_NUMBER, transaction.getIban() == null ? null : transaction.getIban().substring(1), newIban.substring(1));
                }
                transaction.setIban(newIban);
            }
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.RECIPIENT_BANK_CODE, transaction.getBic(), this.recipientBankCode);
            }
            transaction.setBic(this.recipientBankCode);
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.RECIPIENT, transaction.getRecipient(), this.recipientName);
            }
            transaction.setRecipient(this.recipientName);
            transaction.setRecipient2(this.recipientName2);
            transaction.setRecipient3(this.recipientStreet);
            transaction.setRecipient4(this.recipientTown);
            transaction.setRecipientCountry(this.recipientCountryCode);
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.AMOUNT, transaction.getAmount(), this.amount);
            }
            if (this.amount != null) {
                transaction.setAmount(this.amount);
            } else {
                transaction.setAmount(null);
            }
            if (this.counterValue) {
                if (!newPayment) {
                    this.reportFieldChange(Logger.PaymentField.COUNTER_VALUE_CURRENCY, transaction.getCurrency(), this.counterValueCurrency);
                }
                transaction.setCurrency(this.counterValueCurrency);
            } else {
                if (!newPayment) {
                    this.reportFieldChange(Logger.PaymentField.CURRENCY, transaction.getCurrency(), this.currency);
                }
                transaction.setCurrency(this.currency);
            }
            if (!newPayment) {
                Object newPurpose;
                Object oldPurpose = transaction.getPurpose();
                if (oldPurpose != null) {
                    if (transaction.getPurpose2() != null && !transaction.getPurpose2().isEmpty()) {
                        oldPurpose = (String)oldPurpose + " " + transaction.getPurpose2();
                    }
                    if (transaction.getPurpose3() != null && !transaction.getPurpose3().isEmpty()) {
                        oldPurpose = (String)oldPurpose + " " + transaction.getPurpose3();
                    }
                    if (transaction.getPurpose4() != null && !transaction.getPurpose4().isEmpty()) {
                        oldPurpose = (String)oldPurpose + " " + transaction.getPurpose4();
                    }
                }
                if ((newPurpose = this.purpose) != null) {
                    if (this.purpose2 != null && !this.purpose2.isEmpty()) {
                        newPurpose = (String)newPurpose + " " + this.purpose2;
                    }
                    if (this.purpose3 != null && !this.purpose3.isEmpty()) {
                        newPurpose = (String)newPurpose + " " + this.purpose3;
                    }
                    if (this.purpose4 != null && !this.purpose4.isEmpty()) {
                        newPurpose = (String)newPurpose + " " + this.purpose4;
                    }
                }
                this.reportFieldChange(Logger.PaymentField.PURPOSE, oldPurpose, newPurpose);
            }
            transaction.setPurpose(this.purpose);
            transaction.setPurpose2(this.purpose2);
            transaction.setPurpose3(this.purpose3);
            transaction.setPurpose4(this.purpose4);
            if (!newPayment) {
                this.reportFieldChange(Logger.PaymentField.EXECUTION_DATE, transaction.getExecutionDate(), this.executionDate);
            }
            transaction.setExecutionDate(this.executionDate);
            transaction.setPaymentType(Byte.parseByte(this.azvPaymentType));
            transaction.setContact(this.originatorContact);
            transaction.setReference(this.originatorReference);
            transaction.setOrderComment(this.recipientOrderComment1);
            transaction.setOrderComment2(this.recipientOrderComment2);
            transaction.setBank(this.recipientBankName);
            transaction.setBank2(this.recipientBankName2);
            transaction.setBank3(this.recipientBankStreet);
            transaction.setBank4(this.recipientBankTown);
            transaction.setBankCountry(this.recipientBankCountryCode);
            boolean foundFeeAccount = false;
            if (this.feeAccountId != null && (feeAccount = (Account)DB.find(Account.class, (Object)this.feeAccountId)) != null && feeAccount.getGermanAccountNumber() != null && feeAccount.getGermanBankCode() != null) {
                transaction.setFeeAccount(Long.parseLong(feeAccount.getGermanAccountNumber()));
                transaction.setFeeBlz(Integer.parseInt(feeAccount.getGermanBankCode()));
                transaction.setFeeCurrency(feeAccount.getCurrency());
                foundFeeAccount = true;
            }
            if (!foundFeeAccount) {
                transaction.setFeeAccount(0L);
                transaction.setFeeBlz(0);
                transaction.setFeeCurrency(null);
            }
            if (this.feeType != null) {
                if (!newPayment) {
                    this.reportFieldChange(Logger.PaymentField.FEE_TYPE, Byte.toString(transaction.getFeeType()), this.feeType);
                }
                transaction.setFeeType(Byte.parseByte(this.feeType));
            } else {
                transaction.setFeeType((byte)0);
            }
            if (this.instructionCode1 != null) {
                transaction.setInstructionCode(Byte.parseByte(this.instructionCode1));
            } else {
                transaction.setInstructionCode((byte)0);
            }
            if (this.instructionCode2 != null) {
                transaction.setInstructionCode2(Byte.parseByte(this.instructionCode2));
            } else {
                transaction.setInstructionCode2((byte)0);
            }
            if (this.instructionCode3 != null) {
                transaction.setInstructionCode3(Byte.parseByte(this.instructionCode3));
            } else {
                transaction.setInstructionCode3((byte)0);
            }
            if (this.counterValue) {
                transaction.setInstructionCode4((byte)91);
            } else if (this.instructionCode4 != null) {
                transaction.setInstructionCode4(Byte.parseByte(this.instructionCode4));
            } else {
                transaction.setInstructionCode4((byte)0);
            }
            transaction.setInstructions(this.instructionAdditionalInfo);
        }
        return PaymentHandler.getHandler(this.paymentData, this.getPmtType());
    }

    @Override
    public boolean isUrgentPmtType(PaymentTransferType.PmtType pmtType) {
        return false;
    }

    @Override
    public boolean isCredit() {
        return true;
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        return PaymentType.DTAZV;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedOriginator(Form<? extends PaymentForm> form, Tenant tenant) {
        PaymentOriginator paymentOriginator;
        if (this.originatorName == null || this.originatorName.length() == 0) {
            return form.withError("originatorName", "error.required");
        }
        try {
            int originatorId = Integer.parseInt(this.originatorName);
            if (originatorId <= 0) {
                return form.withError("originatorName", "error.required");
            }
            paymentOriginator = (PaymentOriginator)DB.find(PaymentOriginator.class).where().eq("id", (Object)originatorId).eq("tenant", (Object)tenant).eq("paymentType", (Object)PaymentType.DTAZV).setMaxRows(1).findOne();
        }
        catch (NumberFormatException e) {
            paymentOriginator = null;
        }
        if (paymentOriginator == null) {
            return form.withError("originatorName", "error.originatorNotFound");
        }
        this.originatorName = paymentOriginator.getName();
        DtazvOriginatorData dtazvOriginator = new DtazvOriginatorData();
        try {
            dtazvOriginator.setPaymentOriginator(paymentOriginator);
            this.originatorName2 = dtazvOriginator.getName2();
            this.originatorStreet = dtazvOriginator.getStreet();
            this.originatorTown = dtazvOriginator.getTown();
            this.originatorContact = dtazvOriginator.getContact();
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load DTAZV originator!", e);
        }
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        List paymentRecipients;
        form.withGlobalError("");
        if (this.recipientName == null || this.recipientName.length() == 0) {
            return form.withError("recipientName", "error.required");
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName((PaymentType)PaymentType.DTAZV, (String)this.recipientName, (Tenant)tenant);
        if (paymentRecipient == null && (paymentRecipients = PaymentRecipient.findRecipientByName((PaymentType)PaymentType.DTAZV, (String)this.recipientName, (Tenant)tenant)).size() == 1) {
            paymentRecipient = (PaymentRecipient)paymentRecipients.get(0);
        }
        if (paymentRecipient == null) {
            return form.withError("recipientName", "error.recipientNotFound");
        }
        this.recipientName = paymentRecipient.getName();
        this.recipientAccount = paymentRecipient.getAccountNumber();
        this.recipientBankCode = paymentRecipient.getBankCode();
        DtazvRecipientData dtazvRecipientData = new DtazvRecipientData();
        try {
            dtazvRecipientData.setPaymentRecipient(paymentRecipient);
            this.recipientName2 = dtazvRecipientData.getName2();
            this.recipientStreet = dtazvRecipientData.getStreet();
            this.recipientTown = dtazvRecipientData.getTown();
            this.recipientCountryCode = dtazvRecipientData.getCountry();
            this.recipientBankName = dtazvRecipientData.getBankName();
            this.recipientBankName2 = dtazvRecipientData.getBankName2();
            this.recipientBankStreet = dtazvRecipientData.getBankStreet();
            this.recipientBankTown = dtazvRecipientData.getBankTown();
            this.recipientBankCountryCode = dtazvRecipientData.getBankCountry();
        }
        catch (IOException e) {
            BLLoggerPlay.warning("Failed to load DTAZV recipient!", e);
        }
        return form;
    }

    @Override
    protected Form<? extends PaymentForm> internalValidate(Form<? extends PaymentForm> form, Messages messages, FormFactory formFactory, User user, Map<String, String> flashMap) {
        this.originatorName = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorName, 35);
        this.originatorName2 = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorName2, 35);
        this.originatorStreet = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorStreet, 35);
        this.originatorTown = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorTown, 35);
        this.recipientName = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientName, 35);
        this.recipientName2 = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientName2, 35);
        this.recipientStreet = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientStreet, 35);
        this.recipientTown = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientTown, 35);
        this.recipientBankName = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientBankName, 35);
        this.recipientBankName2 = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientBankName2, 35);
        this.recipientBankStreet = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientBankStreet, 35);
        this.recipientBankTown = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientBankTown, 35);
        this.purpose = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose, 35);
        this.purpose2 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose2, 35);
        this.purpose3 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose3, 35);
        this.purpose4 = DtazvPaymentForm.convertToDtazvStringFormat(this.purpose4, 35);
        this.originatorContact = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorContact, 35);
        this.originatorReference = DtazvPaymentForm.convertToDtazvStringFormat(this.originatorReference, 27);
        this.recipientOrderComment1 = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientOrderComment1, 35);
        this.recipientOrderComment2 = DtazvPaymentForm.convertToDtazvStringFormat(this.recipientOrderComment2, 35);
        this.instructionAdditionalInfo = DtazvPaymentForm.convertToDtazvStringFormat(this.instructionAdditionalInfo, 25);
        if (this.recipientAccount != null && this.recipientAccount.length() > 0) {
            this.recipientAccount = this.recipientAccount.replaceAll(" ", "").trim();
        }
        if (this.recipientBankCode != null && this.recipientBankCode.length() > 0) {
            this.recipientBankCode = this.recipientBankCode.replaceAll(" ", "").trim();
        }
        if (this.getPaymentContextType() != PaymentContextType.PERIODIC_PAYMENT && this.getPaymentContextType() != PaymentContextType.PAYMENT_TEMPLATE) {
            if (this.executionDate == null) {
                form = form.withError("executionDate", messages.at("error.required", new Object[0]));
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                if (this.executionDate.before(cal.getTime())) {
                    this.executionDate = cal.getTime();
                    form = form.withError("executionDate", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.executionDateUpdated", (Object[])new Object[0]));
                    Form tempForm = formFactory.form(DtazvPaymentForm.class).fill((Object)this);
                    for (ValidationError error : form.errors()) {
                        tempForm = tempForm.withError(error);
                    }
                    form = tempForm;
                }
            }
        } else if (this.executionDate == null) {
            this.executionDate = ((PaymentForm)form.get()).firstExecution;
        }
        if (this.originatorAccountId == null) {
            form = form.withError("originatorAccountId", messages.at("error.required", new Object[0]));
        } else {
            Account account = (Account)DB.find(Account.class, (Object)this.originatorAccountId);
            if (account == null) {
                form = form.withError("originatorAccountId", messages.at("payment.error.unknownaccount", new Object[0]));
            } else if (account.getGermanBankCode() == null || account.getGermanBankCode().length() != 8 || account.getGermanAccountNumber() == null || account.getGermanAccountNumber().length() == 0) {
                form = form.withError("originatorAccountId", messages.at("payment.error.nogermanaccount", new Object[0]));
            }
        }
        if (this.feeAccountId != null) {
            Account feeAccount = (Account)DB.find(Account.class, (Object)this.feeAccountId);
            if (feeAccount == null) {
                form = form.withError("feeAccountId", messages.at("payment.error.unknownaccount", new Object[0]));
            } else if (feeAccount.getGermanBankCode() == null || feeAccount.getGermanBankCode().length() != 8 || feeAccount.getGermanAccountNumber() == null || feeAccount.getGermanAccountNumber().length() == 0) {
                form = form.withError("feeAccountId", messages.at("payment.error.nogermanaccount", new Object[0]));
            }
        }
        if (this.originatorName == null || this.originatorName.length() == 0) {
            form = form.withError("originatorName", messages.at("error.required", new Object[0]));
        } else if (!RegularExpressions.DTAZV_GUI.matches(this.originatorName)) {
            form = form.withError("originatorName", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorName2 != null && this.originatorName2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.originatorName2)) {
            form = form.withError("originatorName2", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorStreet != null && this.originatorStreet.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.originatorStreet)) {
            form = form.withError("originatorStreet", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorTown != null && this.originatorTown.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.originatorTown)) {
            form = form.withError("originatorTown", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorContact != null && this.originatorContact.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.originatorContact)) {
            form = form.withError("originatorContact", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorReference != null && this.originatorReference.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.originatorReference)) {
            form = form.withError("originatorReference", messages.at("error.invalid", new Object[0]));
        }
        if (this.originatorCustomerNumber != null && this.originatorCustomerNumber.length() > 0) {
            try {
                if (Long.parseLong(this.originatorCustomerNumber) <= 0L) {
                    form = form.withError("originatorCustomerNumber", messages.at("error.negativevalue", new Object[0]));
                }
            }
            catch (NumberFormatException e) {
                form = form.withError("originatorCustomerNumber", messages.at("error.notnumeric", new Object[0]));
            }
        } else {
            form = form.withError("originatorCustomerNumber", messages.at("error.required", new Object[0]));
        }
        boolean allowInvalidBankConnections = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
        boolean isChequePayment = DtazvApi.isChequePaymentType((String)this.azvPaymentType);
        if (this.recipientAccount == null || this.recipientAccount.length() == 0) {
            if (!isChequePayment) {
                form = form.withError("recipientAccount", messages.at("error.required", new Object[0]));
            }
        } else if (!allowInvalidBankConnections && RegularExpressions.IBAN.matches(this.recipientAccount) && !IbanUtil.checkIban((String)this.recipientAccount)) {
            form = form.withError("recipientAccount", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.recipientBankCode != null && (this.recipientBankCode.length() != 0 || isChequePayment || this.recipientBankName != null && this.recipientBankName.length() != 0 || this.recipientBankStreet != null && this.recipientBankStreet.length() != 0 || this.recipientBankTown != null && this.recipientBankTown.length() != 0 || this.recipientBankCountryCode != null && this.recipientBankCountryCode.length() != 0))) {
            form = form.withError("recipientBankCode", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        }
        if (this.recipientName == null || this.recipientName.length() == 0) {
            form = form.withError("recipientName", messages.at("error.required", new Object[0]));
        } else if (!RegularExpressions.DTAZV_GUI.matches(this.recipientName)) {
            form = form.withError("recipientName", messages.at("error.invalid", new Object[0]));
        }
        if (this.recipientName2 != null && this.recipientName2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientName2)) {
            form = form.withError("recipientName2", messages.at("error.invalid", new Object[0]));
        }
        if (this.recipientStreet != null && this.recipientStreet.length() > 0) {
            if (!RegularExpressions.DTAZV_GUI.matches(this.recipientStreet)) {
                form = form.withError("recipientStreet", messages.at("error.invalid", new Object[0]));
            }
        } else if (isChequePayment) {
            form = form.withError("recipientStreet", messages.at("dtazvpayment.error.recipientaddressneeded", new Object[0]));
        }
        if (this.recipientTown != null && this.recipientTown.length() > 0) {
            if (!RegularExpressions.DTAZV_GUI.matches(this.recipientTown)) {
                form = form.withError("recipientTown", messages.at("error.invalid", new Object[0]));
            }
        } else if (isChequePayment) {
            form = form.withError("recipientTown", messages.at("dtazvpayment.error.recipientaddressneeded", new Object[0]));
        }
        if (this.recipientCountryCode == null || this.recipientCountryCode.length() == 0) {
            form = form.withError("recipientCountryCode", messages.at("error.required", new Object[0]));
        } else if (CountriesLoader.getInstance((Locale)messages.lang().locale()).getCountryName(this.recipientCountryCode) == null) {
            form = form.withError("recipientCountryCode", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.recipientBankCode != null && this.recipientBankCode.length() != 0 || this.recipientBankName != null && this.recipientBankName.length() != 0 || isChequePayment)) {
            form = form.withError("recipientBankName", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        } else if (this.recipientBankName != null && this.recipientBankName.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientBankName)) {
            form = form.withError("recipientBankName", messages.at("error.invalid", new Object[0]));
        }
        if (this.recipientBankName2 != null && this.recipientBankName2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientBankName2)) {
            form = form.withError("recipientBankName2", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.recipientBankCode != null && this.recipientBankCode.length() != 0 || this.recipientBankStreet != null && this.recipientBankStreet.length() != 0 || isChequePayment)) {
            form = form.withError("recipientBankStreet", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        } else if (this.recipientBankStreet != null && this.recipientBankStreet.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientBankStreet)) {
            form = form.withError("recipientBankStreet", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.recipientBankCode != null && this.recipientBankCode.length() != 0 || this.recipientBankTown != null && this.recipientBankTown.length() != 0 || isChequePayment)) {
            form = form.withError("recipientBankTown", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        } else if (this.recipientBankTown != null && this.recipientBankTown.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientBankTown)) {
            form = form.withError("recipientBankTown", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.recipientBankCountryCode != null && this.recipientBankCountryCode.length() != 0 || isChequePayment || this.recipientBankCode != null && this.recipientBankCode.length() != 0)) {
            form = form.withError("recipientBankCountryCode", messages.at("dtazvpayment.error.bankaddressneeded", new Object[0]));
        } else if (this.recipientBankCountryCode != null && this.recipientBankCountryCode.length() > 0 && CountriesLoader.getInstance((Locale)messages.lang().locale()).getCountryName(this.recipientBankCountryCode) == null) {
            form = form.withError("recipientBankCountryCode", messages.at("error.invalid", new Object[0]));
        }
        if (this.isUrgent) {
            if (EUE_MAX_AMOUNT.compareTo(this.amount) < 0) {
                form = form.withError("amount", messages.at("dtazvpayment.error.euemaxamount", new Object[0]));
            }
            if (!"EUR".equals(this.currency)) {
                form = form.withError("amount", messages.at("dtazvpayment.error.euecurrency", new Object[0]));
            }
        } else if (MAX_AMOUNT.compareTo(this.amount) < 0) {
            form = form.withError("amount", messages.at("dtazvpayment.error.maxamount", new Object[0]));
        }
        if (Branding.getBranding().isPurposeMandatory() && (this.purpose == null || this.purpose.isEmpty())) {
            form = form.withError("purpose", messages.at("error.required", new Object[0]));
        }
        if (this.purpose != null && this.purpose.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose)) {
            form = form.withError("purpose", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose2 != null && this.purpose2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose2)) {
            form = form.withError("purpose2", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose3 != null && this.purpose3.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose3)) {
            form = form.withError("purpose3", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose4 != null && this.purpose4.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.purpose4)) {
            form = form.withError("purpose4", messages.at("error.invalid", new Object[0]));
        }
        if (!this.isUrgent) {
            if (this.azvPaymentType == null || this.azvPaymentType.length() == 0) {
                form = form.withError("azvPaymentType", messages.at("error.required", new Object[0]));
            } else if (DtazvPaymentType.getForKey((String)this.azvPaymentType) == null) {
                form = form.withError("azvPaymentType", messages.at("error.invalid", new Object[0]));
            }
        } else {
            this.azvPaymentType = "11";
        }
        if (this.recipientOrderComment1 != null && this.recipientOrderComment1.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientOrderComment1)) {
            form = form.withError("recipientOrderComment1", messages.at("error.invalid", new Object[0]));
        }
        if (this.recipientOrderComment2 != null && this.recipientOrderComment2.length() > 0 && !RegularExpressions.DTAZV_GUI.matches(this.recipientOrderComment2)) {
            form = form.withError("recipientOrderComment2", messages.at("error.invalid", new Object[0]));
        }
        if (this.instructionAdditionalInfo != null && this.instructionAdditionalInfo.length() > 0 && !RegularExpressions.DTAUS_GUI.matches(this.instructionAdditionalInfo)) {
            form = form.withError("instructionAdditionalInfo", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    protected void internalRecipientHandling(User user, PaymentHandler<?> payment, Tenant tenant) {
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        return DtazvApi.getPmtType();
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(DtazvPaymentForm.class).fill((Object)this);
    }

    @Override
    protected FormSettings.Form getFormSettingsType() {
        return FormSettings.Form.DTAZV_PAYMENT;
    }

    public boolean hasFurtherOriginatorData() {
        return this.originatorName2 != null && !this.originatorName2.isEmpty() || this.originatorStreet != null && !this.originatorStreet.isEmpty() || this.originatorTown != null && !this.originatorTown.isEmpty() || this.originatorContact != null && !this.originatorContact.isEmpty() || this.originatorReference != null && !this.originatorReference.isEmpty();
    }

    public boolean hasRecipientBankData() {
        return this.recipientBankName != null && !this.recipientBankName.isEmpty() || this.recipientBankName2 != null && !this.recipientBankName2.isEmpty() || this.recipientBankStreet != null && !this.recipientBankStreet.isEmpty() || this.recipientBankTown != null && !this.recipientBankTown.isEmpty() || this.recipientBankCountryCode != null && !this.recipientBankCountryCode.isEmpty();
    }

    public boolean hasInstructionData() {
        return this.instructionCode1 != null && !this.instructionCode1.isEmpty() || this.instructionCode2 != null && !this.instructionCode2.isEmpty() || this.instructionCode3 != null && !this.instructionCode3.isEmpty() || this.instructionCode4 != null && !this.instructionCode4.isEmpty() || this.instructionAdditionalInfo != null && !this.instructionAdditionalInfo.isEmpty();
    }

    private void loadPayment() throws PaymentException {
        byte[] rawPaymentData = this.getPaymentData();
        if (rawPaymentData != null) {
            try {
                this.paymentData = DTAZVPayment.readFrom((DTAReader)new DTAReader((InputStream)new ByteArrayInputStream(rawPaymentData)));
            }
            catch (IOException e) {
                throw new PaymentException("Failed to parse DTAZV payment data!", e);
            }
        } else {
            this.paymentData = null;
        }
    }

    private void loadPaymentDataInfo(boolean allowRecipientRecording) {
        if (this.paymentData != null) {
            this.originatorName = this.paymentData.getOriginator();
            this.originatorName2 = this.paymentData.getOriginator2();
            this.originatorStreet = this.paymentData.getOriginator3();
            this.originatorTown = this.paymentData.getOriginator4();
            this.originatorCustomerNumber = String.valueOf(this.paymentData.getCustomerNumber());
            DTAZVTransaction transaction = this.getTransaction();
            if (transaction != null) {
                Account feeAccount;
                PaymentRecipient paymentRecipient;
                Account originatorAccount = Account.findGermanAccount((BankSettings)this.getBankFromVO(), (String)String.valueOf(this.paymentData.getBlz()), (String)String.valueOf(transaction.getAccount()), (String)transaction.getAccountCurrency());
                if (originatorAccount != null) {
                    this.originatorAccountId = originatorAccount.getId();
                }
                this.originatorContact = transaction.getContact();
                this.originatorAccount = IbanUtil.formatIfIBAN((String)String.valueOf(transaction.getAccount()));
                this.originatorBankCode = String.valueOf(this.paymentData.getBlz());
                String iban = transaction.getIban();
                if (iban != null && iban.length() > 0 && iban.charAt(0) == '/') {
                    iban = iban.substring(1);
                }
                this.recipientAccount = IbanUtil.formatIfIBAN((String)iban);
                this.recipientBankCode = transaction.getBic();
                this.recipientName = allowRecipientRecording ? transaction.getRecipient() : ((paymentRecipient = PaymentRecipient.findRecipientByAccountInfo((PaymentType)PaymentType.DTAZV, (String)transaction.getRecipient(), (String)iban, (String)transaction.getBic(), (Tenant)this.bank.getTenant())) == null ? transaction.getRecipient() : paymentRecipient.getDisplayName());
                this.recipientName2 = transaction.getRecipient2();
                this.recipientStreet = transaction.getRecipient3();
                this.recipientTown = transaction.getRecipient4();
                this.recipientCountryCode = transaction.getRecipientCountry();
                this.recipientBankName = transaction.getBank();
                this.recipientBankName2 = transaction.getBank2();
                this.recipientBankStreet = transaction.getBank3();
                this.recipientBankTown = transaction.getBank4();
                this.recipientBankCountryCode = transaction.getBankCountry();
                this.purpose = transaction.getPurpose();
                this.purpose2 = transaction.getPurpose2();
                this.purpose3 = transaction.getPurpose3();
                this.purpose4 = transaction.getPurpose4();
                this.amount = transaction.getAmount();
                boolean bl = this.counterValue = transaction.getInstructionCode4() == 91;
                if (this.counterValue) {
                    this.currency = "EUR";
                    this.counterValueCurrency = transaction.getCurrency();
                } else {
                    this.currency = transaction.getCurrency();
                }
                this.executionDate = transaction.getExecutionDate();
                this.azvPaymentType = String.valueOf(transaction.getPaymentType());
                this.originatorReference = transaction.getReference();
                this.recipientOrderComment1 = transaction.getOrderComment();
                this.recipientOrderComment2 = transaction.getOrderComment2();
                if (transaction.getFeeBlz() != 0 && transaction.getFeeAccount() != 0L && (feeAccount = Account.findGermanAccount((BankSettings)this.getBankFromVO(), (String)String.valueOf(transaction.getFeeBlz()), (String)String.valueOf(transaction.getFeeAccount()), (String)transaction.getFeeCurrency())) != null) {
                    this.feeAccountId = feeAccount.getId();
                }
                this.feeType = String.valueOf(transaction.getFeeType());
                this.instructionCode1 = String.valueOf(transaction.getInstructionCode());
                this.instructionCode2 = String.valueOf(transaction.getInstructionCode2());
                this.instructionCode3 = String.valueOf(transaction.getInstructionCode3());
                this.instructionCode4 = String.valueOf(transaction.getInstructionCode4());
                this.instructionAdditionalInfo = transaction.getInstructions();
            }
        }
    }

    private DTAZVTransaction getTransaction() {
        if (this.paymentData.getTransactions() != null && this.paymentData.getTransactions().size() > 0) {
            return (DTAZVTransaction)this.paymentData.getTransactions().get(0);
        }
        return null;
    }

    public static String convertToDtazvStringFormat(String toConvert, int maximumLength) {
        if (toConvert == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Matcher umlautMatcher = Pattern.compile("[\u00c4\u00d6\u00dc]").matcher(toConvert.toUpperCase());
        while (umlautMatcher.find()) {
            umlautMatcher.appendReplacement(buffer, umlautMatcher.group(0) + "E");
        }
        umlautMatcher.appendTail(buffer);
        buffer = new StringBuffer(Normalizer.normalize(buffer, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", ""));
        for (int i = 0; i < buffer.length(); ++i) {
            if (RegularExpressions.DTAZV_GUI.matches(buffer.substring(i, i + 1))) continue;
            buffer.delete(i, i + 1);
        }
        if (buffer.length() > maximumLength) {
            return buffer.substring(0, maximumLength);
        }
        return buffer.toString();
    }
}

