/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.dta.api.DtazvOriginatorData;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.util.Locale;
import models.DtazvPaymentForm;
import models.OriginatorForm;
import play.data.Form;
import play.i18n.Messages;
import views.Utils;

public final class DtazvOriginatorForm
extends OriginatorForm {
    public String name2;
    public String street;
    public String town;
    public String contact;

    public DtazvOriginatorForm() {
    }

    public DtazvOriginatorForm(PaymentOriginator paymentOriginator) {
        DtazvOriginatorData originator = new DtazvOriginatorData();
        try {
            originator.setPaymentOriginator(paymentOriginator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.name = originator.getName();
        this.tenantId = originator.getTenant().getId();
        this.name2 = originator.getName2();
        this.street = originator.getStreet();
        this.town = originator.getTown();
        this.contact = originator.getContact();
        if (paymentOriginator.getDefaultAccount() != null) {
            this.defaultAccountId = paymentOriginator.getDefaultAccount().getId();
        }
    }

    @Override
    public Form<? extends OriginatorForm> validate(Form<? extends OriginatorForm> form, User user, Messages messages, PaymentOriginator paymentOriginator) {
        this.name = DtazvPaymentForm.convertToDtazvStringFormat(this.name, 35);
        this.name2 = DtazvPaymentForm.convertToDtazvStringFormat(this.name2, 35);
        this.street = DtazvPaymentForm.convertToDtazvStringFormat(this.street, 35);
        this.town = DtazvPaymentForm.convertToDtazvStringFormat(this.town, 35);
        this.contact = DtazvPaymentForm.convertToDtazvStringFormat(this.contact, 35);
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            return form.withError("tenantId", tenantError);
        }
        this.tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        String accountError = this.checkAccountId(user);
        if (accountError != null) {
            return form.withError("defaultAccountId", accountError);
        }
        if (!RegularExpressions.DTAZV_GUI.matches(this.name) || this.name.length() > 35) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        } else {
            PaymentOriginator existingOriginator = PaymentOriginator.findOriginatorByName((PaymentType)PaymentType.DTAZV, (String)this.name, (Tenant)this.tenant);
            if (!(existingOriginator == null || paymentOriginator != null && paymentOriginator.getId() != null && paymentOriginator.getId().equals(existingOriginator.getId()))) {
                form = form.withError("name", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            }
        }
        if (!(this.name2 == null || this.name2.length() <= 0 || RegularExpressions.DTAZV_GUI.matches(this.name2) && this.name2.length() <= 35)) {
            form = form.withError("name2", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.street == null || this.street.length() <= 0 || RegularExpressions.DTAZV_GUI.matches(this.street) && this.street.length() <= 35)) {
            form = form.withError("street", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.town == null || this.town.length() <= 0 || RegularExpressions.DTAZV_GUI.matches(this.town) && this.town.length() <= 35)) {
            form = form.withError("town", messages.at("error.invalid", new Object[0]));
        }
        if (!(this.contact == null || this.contact.length() <= 0 || RegularExpressions.DTAZV_GUI.matches(this.contact) && this.contact.length() <= 35)) {
            form = form.withError("contact", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentOriginator paymentOriginator, User user) throws IOException {
        DtazvOriginatorData originatorData = new DtazvOriginatorData();
        originatorData.setPaymentOriginator(paymentOriginator);
        boolean isNewOriginator = paymentOriginator.getId() == null;
        String oldName = originatorData.getName();
        boolean nameChanged = false;
        if (DtazvOriginatorForm.isFieldEnabled("name", user)) {
            nameChanged = !isNewOriginator && Utils.fieldValueChanged(oldName, this.name);
            originatorData.setName(this.name);
        }
        if (DtazvOriginatorForm.isFieldEnabled("name2", user)) {
            originatorData.setName2(this.name2);
        }
        if (DtazvOriginatorForm.isFieldEnabled("street", user)) {
            originatorData.setStreet(this.street);
        }
        if (DtazvOriginatorForm.isFieldEnabled("town", user)) {
            originatorData.setTown(this.town);
        }
        if (DtazvOriginatorForm.isFieldEnabled("contact", user)) {
            originatorData.setContact(this.contact);
        }
        Tenant oldTenant = originatorData.getTenant();
        boolean tenantChanged = false;
        if (DtazvOriginatorForm.isFieldEnabled("tenantId", user)) {
            tenantChanged = !isNewOriginator && this.tenant == null && oldTenant != null || this.tenant != null && oldTenant == null || this.tenant != null && !this.tenant.getId().equals(oldTenant.getId());
            originatorData.setTenant(this.tenant);
        }
        Account oldAccount = originatorData.getDefaultAccount();
        boolean accountChanged = false;
        if (DtazvOriginatorForm.isFieldEnabled("defaultAccountId", user)) {
            accountChanged = !isNewOriginator && this.defaultAccount == null && oldAccount != null || this.defaultAccount != null && oldAccount == null || this.defaultAccount != null && !this.defaultAccount.getId().equals(oldAccount.getId());
            originatorData.setDefaultAccount(this.defaultAccount);
        }
        originatorData.save();
        if (nameChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.NAME, (String)oldName, (String)this.name);
        }
        if (tenantChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.TENANT_ID, (String)(oldTenant == null ? null : oldTenant.getName() + " (" + oldTenant.getId() + ")"), this.tenant == null ? null : this.tenant.getName() + " (" + this.tenant.getId() + ")");
        }
        if (accountChanged) {
            Logger.logOriginatorModified((User)user, (PaymentOriginator)paymentOriginator, (Logger.OriginatorField)Logger.OriginatorField.DEFAULT_ACCOUNT, (String)(oldAccount == null ? null : oldAccount.getName() + " (" + oldAccount.getId() + ")"), this.defaultAccount == null ? null : this.defaultAccount.getName() + " (" + this.defaultAccount.getId() + ")");
        }
    }
}

