/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.FetchSchedule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public class CreateMissingSchedulesForm {
    public Map<String, ScheduleParameters> selectedSchedules = new HashMap<String, ScheduleParameters>();

    public static Frequency getDefaultFrequencyForSchedulerType(FetchSchedule.SchedulerType schedulerType) {
        switch (schedulerType) {
            case ADVICES: 
            case PROTOCOL: {
                return Frequency.FREQUENCY_HOURLY;
            }
            case STATEMENTS: 
            case DTI: 
            case SEPANOTIFICATIONS: 
            case FREE: {
                return Frequency.FREQUENCY_DAILY;
            }
            case BKA: 
            case BKI: {
                return Frequency.FREQUENCY_MONTHLY;
            }
        }
        throw new RuntimeException("Failed to determine default fetch frequency for unknown scheduler type " + String.valueOf((Object)schedulerType));
    }

    public static Seq<Tuple2<String, String>> getSelectableFrequencyTypes(Messages messages) {
        ArrayList<Tuple2> resultList = new ArrayList<Tuple2>();
        resultList.add(Scala.Tuple((Object)Frequency.FREQUENCY_HOURLY.name(), (Object)messages.at("fetchschedule.createMissing.frequency.hourly", new Object[0])));
        resultList.add(Scala.Tuple((Object)Frequency.FREQUENCY_DAILY.name(), (Object)messages.at("fetchschedule.createMissing.frequency.workdays", new Object[0])));
        resultList.add(Scala.Tuple((Object)Frequency.FREQUENCY_MONTHLY.name(), (Object)messages.at("fetchschedule.createMissing.frequency.monthly", new Object[0])));
        return Scala.toSeq(resultList);
    }

    public static enum Frequency {
        FREQUENCY_HOURLY,
        FREQUENCY_DAILY,
        FREQUENCY_MONTHLY;

    }

    public static class ScheduleParameters {
        private static final char LIMITER = ';';
        public boolean selected;
        public String frequency;

        public ScheduleParameters() {
        }

        public ScheduleParameters(boolean selected, String frequency) {
            this.selected = selected;
            this.frequency = frequency;
        }

        public String toString() {
            String selectedString = String.valueOf(this.selected);
            String frequencyNonNull = this.frequency == null ? "" : this.frequency;
            return selectedString.trim() + ";" + frequencyNonNull.trim();
        }

        public static ScheduleParameters fromString(String str) {
            if (str != null && !str.isEmpty()) {
                int posLimiter = str.indexOf(59);
                boolean selected = Boolean.parseBoolean(str.substring(0, posLimiter));
                String frequency = str.substring(posLimiter + 1);
                return new ScheduleParameters(selected, frequency);
            }
            return null;
        }
    }
}

