/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.util.BLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import models.PasswordForm;
import play.data.Form;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

@Constraints.Validate
public class CopyKeysForm
extends PasswordForm
implements Constraints.Validatable<List<ValidationError>> {
    @Constraints.Required
    public String userIdCopyTo;
    @Constraints.Required
    public String passwordCopyTo;
    public User foundUser = null;

    public static Seq<Tuple2<String, String>> getUserList(BankUser bankUser, Messages messages) {
        CopyKeysForm form = new CopyKeysForm();
        List users2 = User.getAllForTenants((Collection)bankUser.getUser().getTenants(), (boolean)true);
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (User u : users2) {
            if (u.getId().equals(bankUser.getUser().getId())) continue;
            BankUser bu = BankUser.findBankUser((BankSettings)bankUser.getBank(), (User)u);
            if (bu != null && BankUser.UserState.READY.equals((Object)bu.getState())) {
                result.add(Scala.Tuple((Object)String.valueOf(u.getId()), (Object)(u.getName() + " " + messages.at("bank.copyKeys.overwrite", new Object[0]))));
                continue;
            }
            result.add(Scala.Tuple((Object)String.valueOf(u.getId()), (Object)u.getName()));
        }
        return Scala.toSeq(result);
    }

    public List<ValidationError> validate() {
        return null;
    }

    public Form<CopyKeysForm> checkUserToCopyAndPassword(Form<CopyKeysForm> form, BankUser bankUser) {
        List users2 = User.getAllForTenants((Collection)bankUser.getUser().getTenants(), (boolean)true);
        Integer idToCompare = Integer.valueOf(this.userIdCopyTo);
        for (User u : users2) {
            if (!u.getId().equals(idToCompare)) continue;
            this.foundUser = u;
            break;
        }
        if (this.foundUser == null) {
            form = form.withError("userIdCopyTo", "bank.copyKeys.userNotFound");
        } else if (this.passwordCopyTo == null || this.passwordCopyTo.isEmpty()) {
            form = form.withError("passwordCopyTo", "bank.copyKeys.passwordWrong");
        } else {
            try {
                if (!DatabaseToken.checkPassword((User)this.foundUser, (char[])this.passwordCopyTo.toCharArray(), (BLLogger)BLLoggerPlay.getLogger())) {
                    form = form.withError("passwordCopyTo", "bank.copyKeys.passwordWrong");
                }
            }
            catch (Exception e) {
                form = form.withError("passwordCopyTo", "bank.copyKeys.passwordWrong");
            }
        }
        return form;
    }
}

