/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.ConversionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import play.data.Form;
import play.data.validation.Constraints;

public class ConversionForm {
    @Constraints.Required
    public String name;
    public String type;
    public boolean includeHeader;
    @Constraints.Required
    public String fieldSeparator;
    public String textSeparator;
    public String dateFormat;
    public String numberFormat;
    public String fields;
    public Integer tenantId;
    public String referer;

    public static ConversionForm fill(Conversion conversion) {
        ConversionForm toReturn = new ConversionForm();
        toReturn.name = conversion.getName();
        toReturn.type = conversion.getType().name();
        toReturn.includeHeader = conversion.isIncludeHeader();
        toReturn.fieldSeparator = conversion.getFieldSeparator();
        toReturn.textSeparator = conversion.getTextSeparator();
        toReturn.dateFormat = conversion.getDateFormat();
        toReturn.numberFormat = conversion.getNumberFormat();
        StringBuilder b = new StringBuilder();
        int emptyCount = 0;
        for (Conversion.Field f : conversion.getFieldsAsList()) {
            if (f == Conversion.Field.EMPTY) {
                b.append("EMPTY").append(emptyCount);
                ++emptyCount;
            } else {
                b.append(f.name());
            }
            b.append(",");
        }
        toReturn.fields = b.toString();
        toReturn.tenantId = conversion.getTenant().getId();
        return toReturn;
    }

    public static ConversionForm getDefault(Locale locale) {
        ConversionForm toReturn = new ConversionForm();
        toReturn.includeHeader = true;
        toReturn.fieldSeparator = ";";
        toReturn.textSeparator = "\"";
        toReturn.dateFormat = ConversionHelper.getDefaultDateFormat((Locale)locale);
        return toReturn;
    }

    public static boolean isFieldEnabled(String fieldName, Integer conversionId) {
        boolean isNewConversion;
        boolean bl = isNewConversion = conversionId == null;
        if ("tenantId".equals(fieldName)) {
            return isNewConversion;
        }
        return true;
    }

    public Form<ConversionForm> validateAndSave(Form<ConversionForm> form, Conversion conversion, User user, Locale locale) {
        String error = TenantUtils.checkTenantId(this.tenantId, user);
        if (error != null) {
            return form.withError("tenantId", error);
        }
        Tenant tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        switch (Conversion.nameIsValid((Conversion)conversion, (String)this.name, (Tenant)tenant)) {
            case EXISTS: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            }
            case EMPTY: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.error.empty", (Object[])new Object[0]));
            }
        }
        if (ConversionForm.isFieldEnabled("name", conversion.getId())) {
            conversion.setName(this.name);
        }
        if (ConversionForm.isFieldEnabled("type", conversion.getId())) {
            conversion.setType(Conversion.Type.valueOf((String)this.type));
        }
        if (ConversionForm.isFieldEnabled("includeHeader", conversion.getId())) {
            conversion.setIncludeHeader(this.includeHeader);
        }
        if (ConversionForm.isFieldEnabled("fieldSeparator", conversion.getId())) {
            conversion.setFieldSeparator(ConversionHelper.getSeparator((String)this.fieldSeparator, (Locale)locale));
        }
        if (ConversionForm.isFieldEnabled("textSeparator", conversion.getId())) {
            conversion.setTextSeparator(ConversionHelper.getSeparator((String)this.textSeparator, (Locale)locale));
        }
        if (ConversionForm.isFieldEnabled("dateFormat", conversion.getId())) {
            conversion.setDateFormat(this.dateFormat);
        }
        conversion.setNumberFormat("0.00");
        if (ConversionForm.isFieldEnabled("fields", conversion.getId())) {
            conversion.setFieldsAsList(this.buildFieldList());
        }
        if (ConversionForm.isFieldEnabled("tenantId", conversion.getId())) {
            conversion.setTenant(tenant);
        }
        conversion.save();
        return form;
    }

    private List<Integer> buildFieldList() {
        String[] fieldArray;
        ArrayList<Integer> toReturn = new ArrayList<Integer>();
        for (String s : fieldArray = this.fields.split(",")) {
            if (s.length() == 0) continue;
            Conversion.Field f = s.startsWith("EMPTY") ? Conversion.Field.EMPTY : Conversion.Field.valueOf((String)s);
            toReturn.add(f.getId());
        }
        return toReturn;
    }
}

