/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import java.util.Collections;
import java.util.Locale;
import play.data.Form;

public class CmFolderNameForm {
    public String name;
    public Integer tenantId;

    public Form<CmFolderNameForm> validateFolderChanges(Form<CmFolderNameForm> form, CmFolder folder, User user, Locale locale) {
        Tenant tenant;
        if (this.name.length() > 255) {
            return form.withError("name", "cm.acc.folders.error.tooLong", Collections.singletonList(this.name.length() - 255));
        }
        if (folder.getId() == null) {
            String error = TenantUtils.checkTenantId(this.tenantId, user);
            if (error != null) {
                return form.withError("tenantId", error);
            }
            tenant = TenantUtils.getTenantByIdAndUser(this.tenantId, user);
        } else {
            tenant = folder.getTenant();
        }
        switch (CmFolder.nameIsValid((CmFolder)folder, (String)this.name, (Tenant)tenant)) {
            case EXISTS: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.nameAlreadyExists", (Object[])new Object[0]));
            }
            case EMPTY: {
                return form.withError("name", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.error.empty", (Object[])new Object[0]));
            }
        }
        folder.setTenant(tenant);
        folder.setName(this.name);
        DB.save((Object)folder);
        return form;
    }
}

