/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.TenantUtils;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.sepa.api.ChequeRecipientData;
import de.businesslogics.format.AddressData;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import models.RecipientForm;
import models.payments.PaymentUtils;
import play.data.Form;
import play.i18n.Messages;

public class ChequeRecipientForm
extends RecipientForm {
    public String dept;
    public String subdept;
    public String street;
    public String buildingnumber;
    public String buildingname;
    public String floor;
    public String town;
    public String postcode;
    public String subcountry;
    public String country = "";
    public String purpose;

    public ChequeRecipientForm() {
    }

    public ChequeRecipientForm(PaymentRecipient paymentRecipient) {
        ChequeRecipientData recipient = new ChequeRecipientData();
        try {
            recipient.setPaymentRecipient(paymentRecipient);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.id = paymentRecipient.getId();
        this.displayName = recipient.getDisplayName();
        this.name = recipient.getName();
        this.tenantId = recipient.getTenant().getId();
        this.purpose = recipient.getPurpose();
        AddressData rAddress = recipient.getAddress();
        if (rAddress != null) {
            this.dept = rAddress.getDepartment();
            this.subdept = rAddress.getSubDepartment();
            this.street = rAddress.getStreetName();
            this.buildingnumber = rAddress.getBuildingNumber();
            this.buildingname = rAddress.getBuildingName();
            this.floor = rAddress.getFloor();
            this.town = rAddress.getTownName();
            this.postcode = rAddress.getPostCode();
            this.subcountry = rAddress.getCountrySubDivision();
            this.country = rAddress.getCountry();
        }
    }

    @Override
    public Form<? extends RecipientForm> validate(Form<? extends RecipientForm> form, Messages messages, User user) {
        String tenantError = TenantUtils.checkTenantId(this.tenantId, user);
        if (tenantError != null) {
            form = form.withError("tenantId", tenantError);
        }
        if (this.name != null && this.name.length() > 70) {
            this.name = this.name.substring(0, 70);
        }
        if (this.purpose != null && this.purpose.length() > 140) {
            this.purpose = this.purpose.substring(0, 140);
        }
        if (!RegularExpressions.SEPA_GUI.matches(this.name)) {
            form = form.withError("name", messages.at("error.invalid", new Object[0]));
        }
        if (this.purpose != null && !RegularExpressions.SEPA_GUI.matches(this.purpose)) {
            form = form.withError("purpose", messages.at("error.invalid", new Object[0]));
        }
        return form;
    }

    @Override
    public void store(PaymentRecipient paymentRecipient, User user) throws IOException {
        ChequeRecipientData recipientData = new ChequeRecipientData();
        recipientData.setPaymentRecipient(paymentRecipient);
        if (ChequeRecipientForm.isFieldEnabled("displayName", user, paymentRecipient.getId())) {
            recipientData.setDisplayName(this.displayName);
        }
        if (ChequeRecipientForm.isFieldEnabled("name", user, paymentRecipient.getId())) {
            recipientData.setName(this.name);
        }
        if (ChequeRecipientForm.isFieldEnabled("purpose", user, paymentRecipient.getId())) {
            recipientData.setPurpose(this.purpose);
        }
        if (ChequeRecipientForm.isFieldEnabled("country", user, paymentRecipient.getId())) {
            AddressData rAddress = PaymentUtils.getFullAddressData(this.dept, this.subdept, this.street, this.buildingnumber, this.buildingname, this.floor, this.town, this.postcode, this.subcountry, "", this.country);
            recipientData.setAddress(rAddress);
        }
        if (ChequeRecipientForm.isFieldEnabled("tenantId", user, paymentRecipient.getId())) {
            recipientData.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        }
        recipientData.save(user, PreferenceUtil.useFourEyesForRecipientRecording((User)user));
    }
}

