/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.PasswordRequirement;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import io.ebean.Transaction;
import java.io.IOException;
import java.util.Locale;
import models.PasswordForm;
import play.data.Form;
import play.data.validation.Constraints;

public final class ChangePasswordForm
extends PasswordForm {
    @Constraints.Required
    public String newPassword;
    @Constraints.Required
    public String confirmNewPassword;

    public Form<ChangePasswordForm> validate(Form<ChangePasswordForm> form, User user, boolean checkOTP, Locale locale) {
        if ((form = this.checkPassword(form, user, PasswordForm.PasswordType.LOGIN_PASSWORD, checkOTP, locale)).hasErrors()) {
            form = form.withError("oldPassword", "general.passwordwrong");
        }
        if (this.newPassword == null || this.newPassword.length() == 0) {
            form = form.withError("newPassword", "error.required");
        } else if (!this.newPassword.equals(this.confirmNewPassword)) {
            form = form.withError("confirmNewPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
            form = form.withError("newPassword", BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.passwordsNotMatching", (Object[])new Object[0]));
        } else {
            String requirement = PasswordRequirement.getRequirement().check(this.newPassword.toCharArray(), user, locale);
            if (requirement != null) {
                form = form.withError("newPassword", requirement);
            }
        }
        return form;
    }

    public boolean update(User user) {
        boolean bl;
        block8: {
            Transaction t = DB.beginTransaction();
            try {
                DatabaseToken.updateLoginPassword((User)user, (char[])this.password.toCharArray(), (char[])this.newPassword.toCharArray());
                DatabaseToken.updateSignaturePassword((User)user, (char[])this.password.toCharArray(), (char[])this.newPassword.toCharArray());
                PasswordRequirement.getRequirement().saveUsage(user, this.newPassword.toCharArray(), BLLoggerPlay.getLogger());
                t.commit();
                bl = true;
                if (t == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (t != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidPasswordException | IOException e) {
                    BLLoggerPlay.error("Failed to update password!", e);
                    return false;
                }
            }
            t.close();
        }
        return bl;
    }
}

