/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.CmBookingFilter;
import java.math.BigDecimal;
import java.util.Date;

public class BookingFilterForm {
    public Date bookingDateFrom;
    public Date bookingDateTo;
    public Date bookingDateSingle;
    public int bookingDateComparator;
    public Date valueDateFrom;
    public Date valueDateTo;
    public Date valueDateSingle;
    public int valueDateComparator;
    public String text;
    public int textComparator;
    public BigDecimal amountFrom;
    public BigDecimal amountTo;
    public BigDecimal amountSingle;
    public int amountComparator;
    public int bookingDirection;
    public String bookingTypeText;
    public int bookingType;

    public static BookingFilterForm getData(CmBookingFilter filter) {
        BookingFilterForm data = new BookingFilterForm();
        if (filter != null) {
            data.bookingDateFrom = filter.getBookingDateFrom();
            data.bookingDateTo = filter.getBookingDateTo();
            data.bookingDateSingle = filter.getBookingDateFrom();
            data.bookingDateComparator = filter.getBookingDateComparatorId();
            data.valueDateFrom = filter.getValueDateFrom();
            data.valueDateTo = filter.getValueDateTo();
            data.valueDateSingle = filter.getValueDateFrom();
            data.valueDateComparator = filter.getValueDateComparatorId();
            data.text = filter.getText();
            data.textComparator = filter.getTextComparatorId();
            data.amountFrom = filter.getAmountFrom();
            data.amountTo = filter.getAmountTo();
            data.amountSingle = filter.getAmountFrom();
            data.amountComparator = filter.getAmountComparatorId();
            data.bookingDirection = filter.getBookingDirection() == null ? 0 : filter.getBookingDirection().ordinal();
            data.bookingTypeText = filter.getBookingTypeText();
            data.bookingType = filter.getBookingTypeId();
        }
        return data;
    }

    public void saveData(CmBookingFilter filter) {
        boolean empty = true;
        if (this.bookingDateFrom != null) {
            filter.setBookingDateFrom(new java.sql.Date(this.bookingDateFrom.getTime()));
            empty = false;
        } else {
            filter.setBookingDateFrom(null);
        }
        if (this.bookingDateTo != null) {
            filter.setBookingDateTo(new java.sql.Date(this.bookingDateTo.getTime()));
            empty = false;
        } else {
            filter.setBookingDateTo(null);
        }
        filter.setBookingDateComparator(this.bookingDateComparator);
        if (this.valueDateFrom != null) {
            filter.setValueDateFrom(new java.sql.Date(this.valueDateFrom.getTime()));
            empty = false;
        } else {
            filter.setValueDateFrom(null);
        }
        if (this.valueDateTo != null) {
            filter.setValueDateTo(new java.sql.Date(this.valueDateTo.getTime()));
            empty = false;
        } else {
            filter.setValueDateTo(null);
        }
        filter.setValueDateComparator(this.valueDateComparator);
        filter.setText(this.text);
        if (this.text != null && this.text.length() > 0) {
            empty = false;
        }
        filter.setTextComparator(this.textComparator);
        filter.setAmountFrom(this.amountFrom);
        if (this.amountFrom != null) {
            empty = false;
        }
        filter.setAmountTo(this.amountTo);
        if (this.amountTo != null) {
            empty = false;
        }
        filter.setAmountComparator(this.amountComparator);
        filter.setBookingDirection(this.bookingDirection);
        if (this.bookingDirection != 0) {
            empty = false;
        }
        filter.setBookingTypeText(this.bookingTypeText);
        filter.setBookingType(this.bookingType);
        if (filter.getBookingType() != null && !filter.getBookingType().equals((Object)CmBookingFilter.BookingType.ALL)) {
            if (CmBookingFilter.isBookingTypeWithTextField((CmBookingFilter.BookingType)filter.getBookingType())) {
                if (this.bookingTypeText != null && this.bookingTypeText.length() > 0) {
                    empty = false;
                }
            } else {
                empty = false;
            }
        }
        if (empty) {
            filter.reset();
        } else {
            filter.save();
        }
    }
}

