/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BankOrder;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.vo.User;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.BankOrderWithFileAndPossibleBanks;

public class BankSelectionForm {
    public Map<Integer, BankOrderWithFileAndPossibleBanks> entries = new HashMap<Integer, BankOrderWithFileAndPossibleBanks>();

    public BankSelectionForm() {
    }

    public BankSelectionForm(List<BankOrderWithFileAndPossibleBanks> orders) {
        int counter = 0;
        for (BankOrderWithFileAndPossibleBanks e : orders) {
            this.entries.put(counter++, e);
        }
    }

    public void setEntries(Map<Integer, BankOrderWithFileAndPossibleBanks> entries) {
        this.entries = entries;
    }

    public Map<Integer, BankOrderWithFileAndPossibleBanks> getEntries() {
        return this.entries;
    }

    public void setBankOrdersFromString(User user, Locale locale) throws DisplayFileException, IOException, KnownFormatException {
        for (BankOrderWithFileAndPossibleBanks o : this.entries.values()) {
            if (o.bankOrder != null || o.bankOrderString == null || o.bankOrderString.isEmpty()) continue;
            o.bankOrder = BankOrder.fromString(user, o.bankOrderString, locale);
        }
    }

    public BankOrderWithFileAndPossibleBanks getFileAndBankForOrder(String bankOrder) {
        for (BankOrderWithFileAndPossibleBanks o : this.entries.values()) {
            if (!o.bankOrderString.equals(bankOrder)) continue;
            return o;
        }
        return null;
    }
}

