/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BankOrder;
import de.businesslogics.banking.database.vo.OpenPayment;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class BankOrderWithPayments {
    private final BankOrder bankOrder;
    private final List<OpenPayment> openPayments;

    public static List<BankOrderWithPayments> sortByPmtType(List<BankOrderWithPayments> bankOrders) {
        if (bankOrders == null) {
            return null;
        }
        return bankOrders.stream().sorted(Comparator.comparing(bo -> bo.getBankOrder().getPmtType())).toList();
    }

    public static List<BankOrderWithPayments> getListFromMap(Map<BankOrder, List<OpenPayment>> bankOrdersMap) {
        ArrayList<BankOrderWithPayments> result = new ArrayList<BankOrderWithPayments>();
        for (Map.Entry<BankOrder, List<OpenPayment>> entry : bankOrdersMap.entrySet()) {
            result.add(new BankOrderWithPayments(entry.getKey(), entry.getValue()));
        }
        return BankOrderWithPayments.sortByPmtType(result);
    }

    public BankOrderWithPayments(BankOrder bankOrder, List<OpenPayment> openPayments) {
        this.bankOrder = bankOrder;
        this.openPayments = openPayments == null ? null : new ArrayList<OpenPayment>(openPayments);
    }

    public BankOrder getBankOrder() {
        return this.bankOrder;
    }

    public List<OpenPayment> getOpenPayments() {
        return this.openPayments;
    }

    public String toString() {
        return this.bankOrder.toString();
    }
}

