/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.BankDetails;
import controllers.Banks;
import controllers.routes;
import controllers.util.BLLoggerAdmin;
import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.FetchParameterUtil;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.api.sepa.SepaSchemeHandler;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmBank;
import de.businesslogics.banking.database.vo.DsBank;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserPermission;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.sepa.api.SepaApi;
import de.businesslogics.banking.transfer.api.CustomerProtocolSettings;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.banking.transfer.api.ProtocolFormat;
import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.format.sepa.GeneralSEPAWriter;
import de.businesslogics.util.BLLogger;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import models.payments.PaymentUtils;
import play.data.validation.Constraints;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public class BankDetailsForm {
    private static final long ONE_DAY_IN_MS = 86400000L;
    public Integer tenant;
    @Constraints.Required
    public String name;
    @Constraints.Required
    public String url;
    @Constraints.Required
    public String hostId;
    @Constraints.Required
    public String customerId;
    public String userId;
    public String icon;
    public String orderNumber;
    public String countryCode;
    public String oldCountryCode;
    public String encHash;
    public String authHash;
    public Map<Integer, String> users = new HashMap<Integer, String>();
    public boolean statementActive;
    public String statementFormat;
    public String statementFetchType;
    public Date statementLastFetch;
    public String statementFetchMode = CmBank.FetchMode.DATE.name();
    public boolean adviceActive;
    public String adviceFormat;
    public String adviceFetchType;
    public Date adviceLastFetch;
    public String adviceFetchMode = CmBank.FetchMode.DATE.name();
    public boolean adviceCumulative;
    public boolean adviceMultipleBooking;
    public boolean creditAdvicesForSepaInstantCreditTransfersActive;
    public String creditAdvicesForSepaInstantCreditTransfersFormat;
    public String creditAdvicesForSepaInstantCreditTransfersFetchType;
    public Date creditAdvicesForSepaInstantCreditTransfersLastFetch;
    public String creditAdvicesForSepaInstantCreditTransfersFetchMode = CmBank.FetchMode.DATE.name();
    public boolean vbCalculationWithCreditAdvices;
    public boolean batchedTransactionFilesActive;
    public String batchedTransactionFilesFormat;
    public String batchedTransactionFilesFetchType;
    public Date batchedTransactionFilesLastFetch;
    public String batchedTransactionFilesFetchMode = CmBank.FetchMode.DATE.name();
    public boolean bkaActive;
    public String bkaFetchType;
    public Date bkaLastFetch;
    public String bkaFetchMode = CmBank.FetchMode.DATE.name();
    public boolean bkiActive;
    public String bkiFetchType;
    public Date bkiLastFetch;
    public String bkiFetchMode = CmBank.FetchMode.DATE.name();
    public boolean protocolActive;
    public String protocolFormat;
    public Date protocolLastFetch;
    public String protocolFetchMode = CmBank.FetchMode.DATE.name();
    public boolean notificationsActive;
    public Date notificationsLastFetch;
    public String notificationsFetchMode = CmBank.FetchMode.DATE.name();
    public boolean notificationsSepaTransferActive;
    public String notificationsSepaTransferFetchType;
    public boolean notificationsSepaInstantTransferActive;
    public String notificationsSepaInstantTransferFetchType;
    public boolean notificationsSepaDebitActive;
    public String notificationsSepaDebitFetchType;
    public boolean notificationsSepaCallbackActive;
    public String notificationsSepaCallbackFetchType;
    public boolean notificationsSepaForeignActive;
    public String notificationsSepaForeignFetchType;
    public boolean notificationsVopActive;
    public String notificationsVopFetchType;
    public Map<PaymentTransferType.PmtType, SendparameterInputs> sendParameters;
    public boolean dtazvOneLogicalFile;
    public boolean mt101OneLogicalFile;
    public boolean mt101SwiftHeader;
    public boolean vopActivated;
    public boolean vopMandatory;
    public Integer maxExecutionDate = null;
    public Integer leadTimeForDebits = null;
    public Integer urgentPaymentNumberPerFile = null;
    public boolean desActive;
    public boolean desHvz;
    public boolean transportOnly;

    public static String[] getKeyInfo(BankUser bankUser, Messages messages) {
        StringBuilder sbSig = new StringBuilder();
        StringBuilder sbEnc = new StringBuilder();
        StringBuilder sbAuth = new StringBuilder();
        SignatureVersion sigVersion = SignatureVersion.getInstance((String)bankUser.getSignatureVersion());
        if (sigVersion != null) {
            sbSig.append(BankDetailsForm.keyVersionAndLength(sigVersion.getValue(), bankUser.getSigKeyLength(), messages));
            ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bankUser.getBank().getProtocolVersion());
            boolean isOldProtocol = ProtocolVersion.H002.equals((Object)protocolVersion) || ProtocolVersion.H003.equals((Object)protocolVersion);
            String encVersion = isOldProtocol ? "E001" : "E002";
            sbEnc.append(BankDetailsForm.keyVersionAndLength(encVersion, bankUser.getEncrKeyLength(), messages));
            String authVersion = isOldProtocol ? "X001" : "X002";
            sbAuth.append(BankDetailsForm.keyVersionAndLength(authVersion, bankUser.getAuthKeyLength(), messages));
            try {
                DatabaseToken token = DatabaseToken.getInstance((BankUser)bankUser, null);
                sbSig.append(BankDetailsForm.keyCertInfo(token.getSigCerts(), messages));
                sbEnc.append(BankDetailsForm.keyCertInfo(token.getEncrCerts(), messages));
                sbAuth.append(BankDetailsForm.keyCertInfo(token.getAuthCerts(), messages));
            }
            catch (IOException | GeneralSecurityException e) {
                BLLoggerPlay.getLogger().logError(e.getMessage(), (Throwable)e);
            }
        }
        return new String[]{sbSig.toString(), sbEnc.toString(), sbAuth.toString()};
    }

    private static String keyVersionAndLength(String version, int length, Messages messages) {
        return messages.at("bankdetails.keyversion", new Object[]{version}) + ", " + messages.at("bankdetails.keylength", new Object[]{length});
    }

    private static String keyCertInfo(List<X509Certificate> certs, Messages messages) {
        StringBuilder result = new StringBuilder();
        if (certs != null && !certs.isEmpty()) {
            X509Certificate certificate = certs.getFirst();
            Date fromDate = certificate.getNotBefore();
            Date toDate = certificate.getNotAfter();
            if (fromDate != null) {
                result.append(", ");
                String from = DateFormat.getDateInstance(2, messages.lang().locale()).format(fromDate);
                if (toDate != null && toDate.getTime() < SignatureHandler.ENDLESS_CERT_EXPIRATION - 86400000L) {
                    String to = DateFormat.getDateInstance(2, messages.lang().locale()).format(fromDate);
                    result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.validFromTo", (Object[])new Object[]{from, to}));
                } else {
                    result.append(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.validFrom", (Object[])new Object[]{from}));
                }
            }
        }
        return result.toString();
    }

    public static Seq<Tuple2<String, String>> statementFormats(CMBank cmBank) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        for (CMBank.StatementFormat format : cmBank.getSupportedStatementFormats()) {
            if (CMBank.StatementFormat.CAMT053.equals((Object)format)) {
                toReturn.add(new Tuple2((Object)format.name(), (Object)"camt.053"));
                continue;
            }
            toReturn.add(new Tuple2((Object)format.name(), (Object)format.name()));
        }
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> adviceFormats(CMBank cmBank) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        for (CMBank.AdviceFormat format : cmBank.getSupportedAdviceFormats()) {
            if (CMBank.AdviceFormat.CAMT052.equals((Object)format)) {
                toReturn.add(new Tuple2((Object)format.name(), (Object)"camt.052"));
                continue;
            }
            toReturn.add(new Tuple2((Object)format.name(), (Object)format.name()));
        }
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> dtiFormats() {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)"CAMT054", (Object)"camt.054"));
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> protocolFormats(CustomerProtocolSettings settings, ProtocolVersion protocolVersion) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        for (ProtocolFormat format : settings.getSupportedProtocolFormats()) {
            if (ProtocolFormat.HAC.equals((Object)format)) {
                if (ProtocolVersion.H004.compareTo(protocolVersion) > 0) continue;
                toReturn.add(new Tuple2((Object)format.name(), (Object)format.name()));
                continue;
            }
            toReturn.add(new Tuple2((Object)format.name(), (Object)format.name()));
        }
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> fetchModes(Messages messages) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)CmBank.FetchMode.NEW.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.supply", (Object[])new Object[0])));
        toReturn.add(new Tuple2((Object)CmBank.FetchMode.DATE.name(), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.fromTo", (Object[])new Object[0])));
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> sepaCreditVersions() {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V30.name(), (Object)SepaApi.getCreditTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V30)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V27.name(), (Object)SepaApi.getCreditTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V27)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V25Iso.name(), (Object)SepaApi.getCreditTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V25Iso)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V24Iso.name(), (Object)SepaApi.getCreditTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V24Iso)));
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> sepaDebitVersions() {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V30.name(), (Object)SepaApi.getDebitTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V30)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V27.name(), (Object)SepaApi.getDebitTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V27)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V25Iso.name(), (Object)SepaApi.getDebitTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V25Iso)));
        toReturn.add(new Tuple2((Object)GeneralSEPAWriter.Version.V24Iso.name(), (Object)SepaApi.getDebitTextForSEPAVersion((GeneralSEPAWriter.Version)GeneralSEPAWriter.Version.V24Iso)));
        return Scala.toSeq(toReturn);
    }

    public static Seq<Tuple2<String, String>> sepaSchemaVersions(PaymentTransferType.PmtType pmtType) {
        ArrayList<Tuple2> toReturn = new ArrayList<Tuple2>();
        PaymentTransferType.Scheme[] schemesForPmtType = SepaSchemeHandler.getSchemes((PaymentTransferType.PmtType)pmtType);
        if (schemesForPmtType != null) {
            for (PaymentTransferType.Scheme scheme : schemesForPmtType) {
                toReturn.add(new Tuple2((Object)scheme.name(), (Object)SepaSchemeHandler.getSchemeName((PaymentTransferType.Scheme)scheme)));
            }
        }
        return Scala.toSeq(toReturn);
    }

    public static List<Tuple2<String, String>> getPmtTypes(User user, BankSettings bankSettings, Locale locale) {
        ArrayList<Tuple2<String, String>> result = new ArrayList<Tuple2<String, String>>();
        boolean includeCOR1 = PaymentUtils.isCOR1SupportedByBank(bankSettings);
        for (PaymentTransferType.PmtType pmtType : PaymentUtils.getSupportedPaymentTypes(includeCOR1, Util.displayOpenSalaries((User)user), true)) {
            String label = PaymentTypeUtil.getUniquePaymentName((Locale)locale, (PaymentTransferType.PmtType)pmtType);
            String pmtTypeName = pmtType.name();
            result.add((Tuple2<String, String>)new Tuple2((Object)label, (Object)pmtTypeName));
        }
        result.sort(Comparator.comparing(o -> (String)o._1));
        return result;
    }

    public static String loadJsParameters(User user, BankSettings bank, boolean inEditMode, Messages messages) {
        String[] countryCodes;
        CustomerProtocolSettings protocolHandler = CustomerProtocolSettings.byBank((BankSettings)bank);
        boolean isEbics30OrNewer = BankUtils.isProtocolH005OrNewer((String)bank.getProtocolVersion());
        ObjectNode resultJson = Json.newObject();
        resultJson.put("bankId", bank.getBankId().toString());
        for (String countryCode : countryCodes = new String[]{"DE", "FR", "CH", "AT"}) {
            ObjectNode countryNode = resultJson.putObject(countryCode);
            ObjectNode objectNode = countryNode.putObject("statementDefaultFetchType");
            for (CMBank.StatementFormat statementFormat : CMBank.StatementFormat.values()) {
                objectNode.put(statementFormat.name(), FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)CMBank.getStatementType((CMBank.StatementFormat)statementFormat), (boolean)isEbics30OrNewer, (String)countryCode));
            }
            ObjectNode adviceDefaultFetchTypeNode = countryNode.putObject("adviceDefaultFetchType");
            for (CMBank.AdviceFormat adviceFormat : CMBank.AdviceFormat.values()) {
                adviceDefaultFetchTypeNode.put(adviceFormat.name(), FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)CMBank.getStatementType((CMBank.AdviceFormat)adviceFormat), (boolean)isEbics30OrNewer, (String)countryCode));
            }
            ObjectNode creditAdvicesNode = countryNode.putObject("creditAdvicesForSepaInstantCreditTransfersDefaultFetchType");
            creditAdvicesNode.put("CAMT054", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt054CreditAdvice, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode batchedTransactionNode = countryNode.putObject("batchedTransactionFilesDefaultFetchType");
            batchedTransactionNode.put("CAMT054", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt054, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode bkaNode = countryNode.putObject("bkaDefaultFetchType");
            bkaNode.put("BKA", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pdfStatement, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode bkiNode = countryNode.putObject("bkiDefaultFetchType");
            bkiNode.put("BKI", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.otherPdfDocument, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode notificationsSepaTransferNode = countryNode.putObject("notificationsSepaTransferDefaultFetchType");
            notificationsSepaTransferNode.put("CRZ", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSCT, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode notificationsSepaInstantTransferNode = countryNode.putObject("notificationsSepaInstantTransferDefaultFetchType");
            notificationsSepaInstantTransferNode.put("CIZ", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSCI, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode notificationsSepaDebitNode = countryNode.putObject("notificationsSepaDebitDefaultFetchType");
            notificationsSepaDebitNode.put("CDZ", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.pain002ReportSDD, (boolean)isEbics30OrNewer, (String)countryCode));
            ObjectNode notificationsSepaCallbackNode = countryNode.putObject("notificationsSepaCallbackDefaultFetchType");
            notificationsSepaCallbackNode.put("C29", FetchParameterUtil.getDefaultFetchParameter((FetchParameterUtil.StatementType)FetchParameterUtil.StatementType.camt029Report, (boolean)isEbics30OrNewer, (String)countryCode));
        }
        ObjectNode daysInFutureMessageNode = resultJson.putObject("daysInFutureMessage");
        daysInFutureMessageNode.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.daysInFuture", (Object[])new Object[]{1}));
        daysInFutureMessageNode.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.daysInFuture", (Object[])new Object[]{0}));
        ObjectNode daysMessageNode = resultJson.putObject("daysMessage");
        String tooltip = "&nbsp; <span class=\"fa fa-circle-info\" title=\"" + BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.daysAddToSubmissionDeadlineTooltip", (Object[])new Object[0]) + "\"></span>";
        daysMessageNode.put("single", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.daysAddToSubmissionDeadline", (Object[])new Object[]{1}) + tooltip);
        daysMessageNode.put("multiple", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.daysAddToSubmissionDeadline", (Object[])new Object[]{0}) + tooltip);
        resultJson.put("inEditMode", inEditMode);
        resultJson.put("getEditModeUrl", routes.BankDetails.indexEditMode(bank.getBankId(), "TAB").toString());
        resultJson.put("getRefreshUrl", routes.BankDetails.runHTDUpdate(bank.getBankId(), "TAB").toString());
        resultJson.put("getIniUrl", routes.BankDetails.reIniGet(bank.getBankId(), "TAB").toString());
        resultJson.put("getRenewKeysUrl", routes.BankDetails.changeSignatureVersionGet(bank.getBankId(), "TAB").toString());
        resultJson.put("getShowIniUrl", routes.BankDetails.showIniLetter(bank.getBankId(), "TAB").toString());
        resultJson.put("getLockUrl", routes.BankDetails.lockBankGet(bank.getBankId(), "TAB").toString());
        resultJson.put("getUpdateProtocolUrl", routes.BankDetails.updateProtocolVersionGet(bank.getBankId(), "TAB").toString());
        resultJson.put("getDowngradeProtocolUrl", routes.BankDetails.changeProtocolVersionGet(bank.getBankId(), "H004", "TAB").toString());
        resultJson.put("getEditUrl", routes.BankDetails.index(bank.getBankId(), "TAB").toString());
        resultJson.put("getDefaultSendParamsUrl", routes.BtfUtils.getDefaultSendParams().toString());
        resultJson.put("changeDefaultSendParamsUrl", routes.BtfUtils.changeDefaultSendParams().toString());
        ArrayNode pmtTypesNode = resultJson.putArray("sendParameters");
        for (Tuple2 tuple2 : BankDetailsForm.getPmtTypes(user, bank, messages.lang().locale())) {
            String pmtTypeName = (String)tuple2._2;
            pmtTypesNode.addObject().put("pmtTypeName", pmtTypeName);
        }
        ArrayNode usersNode = resultJson.putArray("activeBankUsersWithKeys");
        for (BankUser bankUser : BankUser.findAllBankUsersForBank((BankSettings)bank)) {
            if (!bankUser.hasActiveEBICSKeys()) continue;
            usersNode.addObject().put("loginUserId", String.valueOf(bankUser.getUser().getId()));
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static String loadBtfModalJsParameters(String btfModalHtmlID, User user, BankSettings bank, Messages messages) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("createBtfStringUrl", routes.BtfUtils.mergeBtfString("SERVICE_NAME", "SERVICE_OPTION", "SCOPE", "CONTAINER", "MESSAGE", "VARIANT", "VERSION", "FORMAT", "EMPTY_ALLOWED").toString());
        resultJson.put("splitBtfStringUrl", routes.BtfUtils.splitBtfString("BTF_STRING", "PMT_TYPE_NAME", bank.getBankId()).toString());
        resultJson.put("modalHtmlID", btfModalHtmlID);
        ArrayNode pmtTypesNode = resultJson.putArray("btfElements");
        for (Tuple2<String, String> entry : BankDetailsForm.getPmtTypes(user, bank, messages.lang().locale())) {
            String pmtTypeName = (String)entry._2;
            ObjectNode btfElement = pmtTypesNode.addObject();
            btfElement.put("textFieldHtmlID", "sendParameters_" + pmtTypeName + "_btf");
            btfElement.put("buttonHtmlID", pmtTypeName + "_modify_button");
            btfElement.put("fetchTypeOrPmtTypeName", pmtTypeName);
            ObjectNode btfVopElement = pmtTypesNode.addObject();
            btfVopElement.put("textFieldHtmlID", "sendParametersVop_" + pmtTypeName + "_btf_vop");
            btfVopElement.put("buttonHtmlID", pmtTypeName + "_vop_modify_button");
            btfVopElement.put("fetchTypeOrPmtTypeName", pmtTypeName + "_VOP");
        }
        ObjectNode btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "statementFetchType");
        btfElement.put("buttonHtmlID", "statementFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "statements");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "adviceFetchType");
        btfElement.put("buttonHtmlID", "adviceFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "advices");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "creditAdvicesForSepaInstantCreditTransfersFetchType");
        btfElement.put("buttonHtmlID", "creditAdvicesForSepaInstantCreditTransfersFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "creditAdvicesForInstantTransfers");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "batchedTransactionFilesFetchType");
        btfElement.put("buttonHtmlID", "batchedTransactionFilesFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "batchedTransactions");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "bkaFetchType");
        btfElement.put("buttonHtmlID", "bkaFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "bka");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "bkiFetchType");
        btfElement.put("buttonHtmlID", "bkiFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "bki");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsSepaTransferFetchType");
        btfElement.put("buttonHtmlID", "notificationsSepaTransferFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsSepa");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsSepaInstantTransferFetchType");
        btfElement.put("buttonHtmlID", "notificationsSepaInstantTransferFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsSepaInstant");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsSepaDebitFetchType");
        btfElement.put("buttonHtmlID", "notificationsSepaDebitFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsSepaDEBIT");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsSepaCallbackFetchType");
        btfElement.put("buttonHtmlID", "notificationsSepaCallbackFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsSepaCallback");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsSepaForeignFetchType");
        btfElement.put("buttonHtmlID", "notificationsSepaForeignFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsSepaForeign");
        btfElement = pmtTypesNode.addObject();
        btfElement.put("textFieldHtmlID", "notificationsVopFetchType");
        btfElement.put("buttonHtmlID", "notificationsVopFetchType_modify_button");
        btfElement.put("fetchTypeOrPmtTypeName", "notificationsVop");
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public static boolean isFieldEnabled(String fieldName, BankSettings bank, User loggedInUser) {
        if (loggedInUser == null || !Banks.canUserModifyBank(loggedInUser, bank)) {
            return false;
        }
        if ("authHash".equals(fieldName) || "encHash".equals(fieldName)) {
            return BankUtils.hasExpectedHashValues((BankSettings)bank);
        }
        if ("transportOnly".equals(fieldName) || "users".equals(fieldName)) {
            return loggedInUser.isAdmin() || loggedInUser.getManagedTenants().contains(bank.getTenant());
        }
        return true;
    }

    public static BankDetailsForm fillForm(BankSettings bank, BankUser bankUser) {
        ProtocolVersion protocolVersion;
        BankDetailsForm result = new BankDetailsForm();
        result.tenant = bank.getTenant().getId();
        result.name = bank.getDisplayName();
        result.url = bank.getUrl();
        result.hostId = bank.getHostId();
        result.customerId = bank.getCustomerId();
        result.countryCode = bank.getCountryCode();
        result.oldCountryCode = bank.getCountryCode();
        result.icon = Banks.getBankIcon(bank);
        result.vopActivated = bank.isVopActivated();
        result.vopMandatory = bank.isVopMandatory();
        if (bank.getTransportOnly() != null) {
            result.transportOnly = bank.getTransportOnly();
        }
        if (bankUser != null) {
            result.orderNumber = bankUser.getOrderNumber();
            result.userId = bankUser.getDefaultUser();
        }
        if ((protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion())).compareTo(ProtocolVersion.H002) <= 0) {
            result.encHash = bank.getExpectedDigestE001();
            result.authHash = bank.getExpectedDigestX001();
        } else {
            result.encHash = bank.getExpectedDigestE002();
            result.authHash = bank.getExpectedDigestX002();
        }
        BankDetailsForm.fillUserMap(result.users, bank);
        CMBank cmBank = CMBank.get((BankSettings)bank);
        result.statementActive = cmBank.isStatementFetchActivated();
        if (cmBank.getStatementFormat() != null) {
            result.statementFormat = cmBank.getStatementFormat().name();
        }
        result.statementFetchType = cmBank.getStatementFetchType();
        result.statementLastFetch = cmBank.getLastStaFetchDate();
        if (cmBank.getStaFetchMode() != null) {
            result.statementFetchMode = cmBank.getStaFetchMode().name();
        }
        result.adviceActive = cmBank.isAdviceFetchActivated();
        if (cmBank.getAdviceFormat() != null) {
            result.adviceFormat = cmBank.getAdviceFormat().name();
        }
        result.adviceFetchType = cmBank.getAdviceFetchType();
        result.adviceLastFetch = cmBank.getLastVmkFetchDate();
        if (cmBank.getVmkFetchMode() != null) {
            result.adviceFetchMode = cmBank.getVmkFetchMode().name();
        }
        result.adviceCumulative = cmBank.getCumulativeAdviceProvision();
        result.adviceMultipleBooking = cmBank.getMultidaysAdviceRepeated();
        result.creditAdvicesForSepaInstantCreditTransfersActive = cmBank.isCreditAdviceFetchActivated();
        result.creditAdvicesForSepaInstantCreditTransfersFormat = "CAMT054";
        result.creditAdvicesForSepaInstantCreditTransfersFetchType = cmBank.getCreditAdviceFetchType();
        result.creditAdvicesForSepaInstantCreditTransfersLastFetch = cmBank.getLastCreditAdviceFetchDate();
        if (cmBank.getCreditAdviceFetchMode() != null) {
            result.creditAdvicesForSepaInstantCreditTransfersFetchMode = cmBank.getCreditAdviceFetchMode().name();
        }
        result.vbCalculationWithCreditAdvices = cmBank.vbCalculationWithCreditAdvices();
        result.batchedTransactionFilesActive = cmBank.isC54FetchActivated();
        result.batchedTransactionFilesFormat = "CAMT054";
        result.batchedTransactionFilesFetchType = cmBank.getC54FetchType();
        result.batchedTransactionFilesLastFetch = cmBank.getLastC54FetchDate();
        if (cmBank.getC54FetchMode() != null) {
            result.batchedTransactionFilesFetchMode = cmBank.getC54FetchMode().name();
        }
        result.bkaActive = cmBank.isBkaFetchActivated();
        result.bkaFetchType = cmBank.getBkaFetchType();
        result.bkaLastFetch = cmBank.getLastBkaFetchDate();
        if (cmBank.getBkaFetchMode() != null) {
            result.bkaFetchMode = cmBank.getBkaFetchMode().name();
        }
        result.bkiActive = cmBank.isBkiFetchActivated();
        result.bkiFetchType = cmBank.getBkiFetchType();
        result.bkiLastFetch = cmBank.getLastBkiFetchDate();
        if (cmBank.getBkiFetchMode() != null) {
            result.bkiFetchMode = cmBank.getBkiFetchMode().name();
        }
        CustomerProtocolSettings protocolHandler = CustomerProtocolSettings.byBank((BankSettings)bank);
        result.protocolActive = protocolHandler.isProtocolActivated();
        if (protocolHandler.getProtocolFormat() != null) {
            result.protocolFormat = protocolHandler.getProtocolFormat().name();
        }
        result.protocolLastFetch = protocolHandler.getLastProtocolFetchDate();
        if (protocolHandler.getProtocolFetchMode() != null) {
            result.protocolFetchMode = protocolHandler.getProtocolFetchMode().name();
        }
        NotificationSettings notificationsHandler = NotificationSettings.getForBank((BankSettings)bank);
        result.notificationsActive = notificationsHandler.isActivated();
        result.notificationsLastFetch = notificationsHandler.getLastFetchDate();
        result.notificationsFetchMode = notificationsHandler.getFetchMode().name();
        result.notificationsSepaTransferActive = notificationsHandler.fetchCreditNotifications();
        result.notificationsSepaTransferFetchType = notificationsHandler.getFetchTypeForCreditNotifications();
        result.notificationsSepaInstantTransferActive = notificationsHandler.fetchInstantNotifications();
        result.notificationsSepaInstantTransferFetchType = notificationsHandler.getFetchTypeForInstantNotifications();
        result.notificationsSepaDebitActive = notificationsHandler.fetchDebitNotifications();
        result.notificationsSepaDebitFetchType = notificationsHandler.getFetchTypeForDebitNotifications();
        result.notificationsSepaCallbackActive = notificationsHandler.fetchCallbackNotifications();
        result.notificationsSepaCallbackFetchType = notificationsHandler.getFetchTypeForCallbackNotifications();
        result.notificationsSepaForeignActive = notificationsHandler.fetchForeignNotifications();
        result.notificationsSepaForeignFetchType = notificationsHandler.getFetchTypeForForeignNotifications();
        result.notificationsVopActive = notificationsHandler.fetchVopNotifications();
        result.notificationsVopFetchType = notificationsHandler.getFetchTypeForVopNotifications();
        result.sendParameters = new HashMap<PaymentTransferType.PmtType, SendparameterInputs>();
        boolean includeCOR1 = PaymentUtils.isCOR1SupportedByBank(bank);
        boolean includeSalaryPmtType = bankUser == null || Util.displayOpenSalaries((User)bankUser.getUser());
        List<PaymentTransferType.PmtType> pmtTypes = PaymentUtils.getSupportedPaymentTypes(includeCOR1, includeSalaryPmtType, true);
        for (SendParameters s : SendParameters.getSendParametersForPmtTypes((BankSettings)bank, pmtTypes)) {
            String scheme = s.getScheme() == null ? "" : s.getScheme().name();
            result.sendParameters.put(s.getPmtType(), new SendparameterInputs(s.getOrderType(), s.getOrderTypeVop(), s.getBtf(), s.getBtfVop(), scheme));
        }
        PaymentProperties paymentProperties = PaymentProperties.findForBank((BankSettings)bank);
        result.dtazvOneLogicalFile = paymentProperties.getDtazvOneLogicalFilePerOrder() != null ? paymentProperties.getDtazvOneLogicalFilePerOrder() : true;
        result.mt101OneLogicalFile = paymentProperties.getMT101OneLogicalFilePerOrder() != null ? paymentProperties.getMT101OneLogicalFilePerOrder() : true;
        result.mt101SwiftHeader = paymentProperties.getMT101SwiftHeader() != null ? paymentProperties.getMT101SwiftHeader() : false;
        result.maxExecutionDate = paymentProperties.getSepaMaxExecDate();
        result.leadTimeForDebits = paymentProperties.getSepaLeadTimeForDebits();
        result.urgentPaymentNumberPerFile = paymentProperties.getSepaMaxUrgentPaymentsPerFile();
        if (result.maxExecutionDate == null) {
            result.maxExecutionDate = 15;
        }
        if (result.leadTimeForDebits == null) {
            result.leadTimeForDebits = 1;
        }
        if (result.urgentPaymentNumberPerFile == null) {
            result.urgentPaymentNumberPerFile = 0;
        }
        DsBank dsBank = DsBank.get((BankSettings)bank);
        result.desActive = dsBank.isActivated();
        result.desHvz = dsBank.isHvz();
        return result;
    }

    private static void fillUserMap(Map<Integer, String> userMap, BankSettings forBank) {
        List allUsers = User.getAllForTenants(Collections.singletonList(forBank.getTenant()), (boolean)true);
        for (User user : allUsers) {
            BankUser bankUser = BankUser.findBankUser((BankSettings)forBank, (User)user);
            BankDetails.USER_ACTIVATION_OPTION state = BankDetails.USER_ACTIVATION_OPTION.REMOVED;
            if (bankUser != null) {
                state = BankUtils.isDeactivated((BankUser)bankUser) ? BankDetails.USER_ACTIVATION_OPTION.DEACTIVATED : BankDetails.USER_ACTIVATION_OPTION.ACTIVATED;
            }
            userMap.put(user.getId(), state.name());
        }
    }

    public List<ValidationError> validate(Messages messages) {
        this.name = StringUtils.trim((String)this.name);
        this.url = StringUtils.trim((String)this.url);
        this.hostId = StringUtils.trim((String)this.hostId);
        this.customerId = StringUtils.trim((String)this.customerId);
        this.userId = StringUtils.trim((String)this.userId);
        this.encHash = StringUtils.trimAndUpperCase((String)this.encHash);
        this.encHash = StringUtils.removeAllWhitespace((String)this.encHash);
        this.authHash = StringUtils.trimAndUpperCase((String)this.authHash);
        this.authHash = StringUtils.removeAllWhitespace((String)this.authHash);
        this.orderNumber = StringUtils.trimAndUpperCase((String)this.orderNumber);
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        try {
            URL u = new URI(this.url).toURL();
            if (!u.getProtocol().equalsIgnoreCase("https")) {
                errors.add(new ValidationError("url", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.urlNoHttps", (Object[])new Object[0])));
            }
        }
        catch (Exception mal) {
            errors.add(new ValidationError("url", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidUrl", (Object[])new Object[0])));
        }
        if (this.hostId != null && !this.hostId.isEmpty() && !StringUtils.check((String)this.hostId, (RegularExpressions)RegularExpressions.EBICS_V24_HOST_ID)) {
            errors.add(new ValidationError("hostId", "bankdetails.hostid.invalid"));
        }
        if (this.customerId != null && !this.customerId.isEmpty() && !StringUtils.check((String)this.customerId, (RegularExpressions)RegularExpressions.EBICS_V24_PARTNER_ID)) {
            errors.add(new ValidationError("customerId", "general.error.invalidCharacters"));
        }
        if (this.userId != null && !this.userId.isEmpty() && !StringUtils.check((String)this.userId, (RegularExpressions)RegularExpressions.EBICS_V24_USER_ID)) {
            errors.add(new ValidationError("userId", "general.error.invalidCharacters"));
        }
        if (this.encHash != null && !this.encHash.isEmpty()) {
            if (!StringUtils.check((String)this.encHash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
                errors.add(new ValidationError("encHash", "bankdetails.hash.hexValue"));
            }
            if (this.encHash.length() > 64) {
                errors.add(new ValidationError("encHash", "bankdetails.hash.invalid"));
            }
        }
        if (this.authHash != null && !this.authHash.isEmpty()) {
            if (!StringUtils.check((String)this.authHash, (RegularExpressions)RegularExpressions.HEX_STRING)) {
                errors.add(new ValidationError("authHash", "bankdetails.hash.hexValue"));
            }
            if (this.authHash.length() > 64) {
                errors.add(new ValidationError("authHash", "bankdetails.hash.invalid"));
            }
        }
        if (!(this.statementFetchType == null || this.statementFetchType.isEmpty() || StringUtils.check((String)this.statementFetchType, (RegularExpressions)RegularExpressions.ORDER_TYPE) || StringUtils.check((String)this.statementFetchType, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN) || StringUtils.check((String)this.statementFetchType, (RegularExpressions)RegularExpressions.FRENCH_FILE_TYPE))) {
            errors.add(new ValidationError("statementFetchType", "bankdetails.fetchType.invalid"));
        }
        if (!(this.adviceFetchType == null || this.adviceFetchType.isEmpty() || StringUtils.check((String)this.adviceFetchType, (RegularExpressions)RegularExpressions.ORDER_TYPE) || StringUtils.check((String)this.adviceFetchType, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN) || StringUtils.check((String)this.adviceFetchType, (RegularExpressions)RegularExpressions.FRENCH_FILE_TYPE))) {
            errors.add(new ValidationError("adviceFetchType", "bankdetails.fetchType.invalid"));
        }
        if (!(this.creditAdvicesForSepaInstantCreditTransfersFetchType == null || this.creditAdvicesForSepaInstantCreditTransfersFetchType.isEmpty() || StringUtils.check((String)this.creditAdvicesForSepaInstantCreditTransfersFetchType, (RegularExpressions)RegularExpressions.ORDER_TYPE) || StringUtils.check((String)this.creditAdvicesForSepaInstantCreditTransfersFetchType, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN) || StringUtils.check((String)this.creditAdvicesForSepaInstantCreditTransfersFetchType, (RegularExpressions)RegularExpressions.FRENCH_FILE_TYPE))) {
            errors.add(new ValidationError("creditAdvicesForSepaInstantCreditTransfersFetchType", "bankdetails.fetchType.invalid"));
        }
        if (!(this.batchedTransactionFilesFetchType == null || this.batchedTransactionFilesFetchType.isEmpty() || StringUtils.check((String)this.batchedTransactionFilesFetchType, (RegularExpressions)RegularExpressions.ORDER_TYPE) || StringUtils.check((String)this.batchedTransactionFilesFetchType, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN) || StringUtils.check((String)this.batchedTransactionFilesFetchType, (RegularExpressions)RegularExpressions.FRENCH_FILE_TYPE))) {
            errors.add(new ValidationError("batchedTransactionFilesFetchType", "bankdetails.fetchType.invalid"));
        }
        if (!(this.bkaFetchType == null || this.bkaFetchType.isEmpty() || StringUtils.check((String)this.bkaFetchType, (RegularExpressions)RegularExpressions.ORDER_TYPE) || StringUtils.check((String)this.bkaFetchType, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN))) {
            errors.add(new ValidationError("bkaFetchType", "bankdetails.fetchType.invalid"));
        }
        for (Map.Entry<PaymentTransferType.PmtType, SendparameterInputs> entry : this.sendParameters.entrySet()) {
            String errorKey;
            String pmtTypeName = entry.getKey().name();
            SendparameterInputs sendParameter = entry.getValue();
            if (!StringUtils.check((String)sendParameter.orderType, (RegularExpressions)RegularExpressions.ORDER_TYPE)) {
                errorKey = String.format("sendParameters[%s].orderType", pmtTypeName);
                errors.add(new ValidationError(errorKey, "bankdetails.sendParameters.invalid.orderType"));
            }
            if (sendParameter.orderTypeVop != null && !StringUtils.check((String)sendParameter.orderTypeVop, (RegularExpressions)RegularExpressions.ORDER_TYPE)) {
                errorKey = String.format("sendParameters[%s].orderTypeVop", pmtTypeName);
                errors.add(new ValidationError(errorKey, "bankdetails.sendParameters.invalid.orderType"));
            }
            if (!StringUtils.check((String)sendParameter.btf, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN)) {
                errorKey = String.format("sendParameters[%s].btf", pmtTypeName);
                errors.add(new ValidationError(errorKey, "bankdetails.sendParameters.invalid.btf"));
            }
            if (sendParameter.btfVop == null || StringUtils.check((String)sendParameter.btfVop, (RegularExpressions)RegularExpressions.BTF_SERVICE_PATTERN)) continue;
            errorKey = String.format("sendParameters[%s].btfVop", pmtTypeName);
            errors.add(new ValidationError(errorKey, "bankdetails.sendParameters.invalid.btf"));
        }
        return errors.isEmpty() ? null : errors;
    }

    public void saveForm(User operatingUser, BankSettings bank, BankUser operatorBankUser) {
        AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
        boolean detailsLogged = false;
        String oldName = bank.getDisplayName();
        boolean nameChanged = false;
        if (BankDetailsForm.isFieldEnabled("name", bank, operatingUser)) {
            nameChanged = !Objects.equals(oldName, this.name);
            bank.setDisplayName(this.name);
        }
        String oldUrl = bank.getUrl();
        boolean urlChanged = false;
        if (BankDetailsForm.isFieldEnabled("url", bank, operatingUser)) {
            urlChanged = !Objects.equals(oldUrl, this.url);
            bank.setUrl(this.url);
        }
        String oldHostId = bank.getHostId();
        boolean hostIdChanged = false;
        if (BankDetailsForm.isFieldEnabled("hostId", bank, operatingUser)) {
            hostIdChanged = !Objects.equals(oldHostId, this.hostId);
            bank.setHostId(this.hostId);
        }
        String oldCustomerId = bank.getCustomerId();
        boolean customerIdChanged = false;
        if (BankDetailsForm.isFieldEnabled("customerId", bank, operatingUser)) {
            customerIdChanged = !Objects.equals(oldCustomerId, this.customerId);
            bank.setCustomerId(this.customerId);
        }
        String oldCountry = bank.getCountryCode();
        boolean countryChanged = false;
        if (BankDetailsForm.isFieldEnabled("countryCode", bank, operatingUser)) {
            countryChanged = !Objects.equals(this.countryCode, bank.getCountryCode());
            bank.setCountryCode(this.countryCode);
        }
        boolean transportOnlyChanged = false;
        if (BankDetailsForm.isFieldEnabled("transportOnly", bank, operatingUser)) {
            transportOnlyChanged = !Objects.equals(this.transportOnly, bank.getTransportOnly());
            bank.setTransportOnly(this.transportOnly);
        }
        boolean vopActivatedChanged = false;
        if (BankDetailsForm.isFieldEnabled("vopActivated", bank, operatingUser)) {
            vopActivatedChanged = !Objects.equals(this.vopActivated, bank.isVopActivated());
            bank.setVopActivated(this.vopActivated);
        }
        boolean vopMandatoryChanged = false;
        if (BankDetailsForm.isFieldEnabled("vopMandatory", bank, operatingUser)) {
            vopMandatoryChanged = !Objects.equals(this.vopMandatory, bank.isVopMandatory());
            bank.setVopMandatory(this.vopMandatory);
        }
        if (operatorBankUser != null) {
            boolean userIdChanged;
            String oldUserId = operatorBankUser.getDefaultUser();
            boolean bl = userIdChanged = this.userId != null && !this.userId.isEmpty() && !Objects.equals(oldUserId, this.userId);
            if (userIdChanged) {
                BankUtils.updateBankUser((BankUser)operatorBankUser, (String)this.userId, (BLLogger)BLLoggerPlay.getLogger());
            }
        }
        Banks.setBankIcon(bank, this.icon);
        HashSet<Object> addedBankUsers = new HashSet<Object>();
        HashSet<Object> removedBankUsers = new HashSet<Object>();
        if (BankDetailsForm.isFieldEnabled("users", bank, operatingUser)) {
            HashMap<Integer, String> oldUserStates = new HashMap<Integer, String>();
            BankDetailsForm.fillUserMap(oldUserStates, bank);
            for (Integer userId : oldUserStates.keySet()) {
                BankDetails.USER_ACTIVATION_OPTION newState;
                User user = (User)DB.find(User.class).where().eq("id", (Object)userId).findOne();
                if (user == null) {
                    BLLoggerPlay.warning("Could not find user with ID " + userId);
                    continue;
                }
                BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
                BankDetails.USER_ACTIVATION_OPTION oldState = BankDetails.USER_ACTIVATION_OPTION.valueOf((String)oldUserStates.get(userId));
                if (oldState == (newState = BankDetails.USER_ACTIVATION_OPTION.valueOf(this.users.get(userId)))) continue;
                switch (newState) {
                    case ACTIVATED: 
                    case DEACTIVATED: {
                        if (bankUser == null) {
                            bankUser = BankUser.createBankUser((BankSettings)bank, (User)user);
                            for (OrderType o : OrderType.findSendOrderTypesForBank((BankSettings)bank)) {
                                UserPermission userPermission = new UserPermission();
                                userPermission.setBankUser(bankUser);
                                userPermission.setOrderType(o);
                                userPermission.save();
                            }
                            addedBankUsers.add(user);
                        }
                        bankUser.setDeactivated(newState == BankDetails.USER_ACTIVATION_OPTION.DEACTIVATED);
                        bankUser.save();
                        break;
                    }
                    case REMOVED: {
                        if (bankUser == null) break;
                        bankUser.delete();
                        removedBankUsers.add(user);
                    }
                }
            }
        }
        String eHashChanged = null;
        String xHashChanged = null;
        ProtocolVersion protocolVersion = ProtocolVersion.getInstance((String)bank.getProtocolVersion());
        if (ProtocolVersion.H002.equals((Object)protocolVersion)) {
            if (BankDetailsForm.isFieldEnabled("encHash", bank, operatingUser) && this.encHash != null && !this.encHash.isEmpty()) {
                if (!Objects.equals(bank.getExpectedDigestE001(), this.encHash)) {
                    eHashChanged = "E001";
                }
                bank.setExpectedDigestE001(this.encHash);
            }
            if (BankDetailsForm.isFieldEnabled("authHash", bank, operatingUser) && this.authHash != null && !this.authHash.isEmpty()) {
                if (!Objects.equals(bank.getExpectedDigestX001(), this.authHash)) {
                    xHashChanged = "X001";
                }
                bank.setExpectedDigestX001(this.authHash);
            }
        } else {
            if (BankDetailsForm.isFieldEnabled("encHash", bank, operatingUser) && this.encHash != null && !this.encHash.isEmpty()) {
                if (!Objects.equals(bank.getExpectedDigestE002(), this.encHash)) {
                    eHashChanged = "E002";
                }
                bank.setExpectedDigestE002(this.encHash);
            }
            if (BankDetailsForm.isFieldEnabled("authHash", bank, operatingUser) && this.authHash != null && !this.authHash.isEmpty()) {
                if (!Objects.equals(bank.getExpectedDigestX002(), this.authHash)) {
                    xHashChanged = "X002";
                }
                bank.setExpectedDigestX002(this.authHash);
            }
        }
        bank.save();
        if (countryChanged) {
            SendParameters.updateDefaultTransferTypesInPaymentTables((BankSettings)bank, (String)oldCountry);
        }
        if (nameChanged) {
            logger.logBankRenamed(operatingUser, bank, oldName);
            detailsLogged = true;
        }
        if (urlChanged) {
            logger.logBankUrlChanged(operatingUser, bank, oldUrl);
            detailsLogged = true;
        }
        if (hostIdChanged) {
            logger.logBankHostIdChanged(operatingUser, bank, oldHostId);
            detailsLogged = true;
        }
        if (customerIdChanged) {
            logger.logBankCustomerIdChanged(operatingUser, bank, oldCustomerId);
            detailsLogged = true;
        }
        if (transportOnlyChanged) {
            logger.logBankTransportOnlyChanged(operatingUser, bank);
            detailsLogged = true;
        }
        if (vopActivatedChanged) {
            logger.logBankVopActivatedChanged(operatingUser, bank);
            detailsLogged = true;
        }
        if (vopMandatoryChanged) {
            logger.logBankVopMandatoryChanged(operatingUser, bank);
            detailsLogged = true;
        }
        if (countryChanged) {
            logger.logBankCountryChanged(operatingUser, bank, oldCountry);
            detailsLogged = true;
        }
        if (eHashChanged != null) {
            logger.logBankDigestModified(operatingUser, eHashChanged, bank, this.encHash);
            detailsLogged = true;
        }
        if (xHashChanged != null) {
            logger.logBankDigestModified(operatingUser, xHashChanged, bank, this.authHash);
            detailsLogged = true;
        }
        if (operatorBankUser != null) {
            operatorBankUser.setOrderNumber(this.orderNumber);
            operatorBankUser.save();
        }
        for (Object user : addedBankUsers) {
            logger.logBankAddedUser(operatingUser, (User)user, bank);
            detailsLogged = true;
        }
        for (Object user : removedBankUsers) {
            logger.logBankRemovedUser(operatingUser, (User)user, bank);
            detailsLogged = true;
        }
        CMBank cmBank = CMBank.get((BankSettings)bank);
        if (BankDetailsForm.isFieldEnabled("statementActive", bank, operatingUser)) {
            cmBank.setStatementFetchActivated(this.statementActive);
        }
        if (cmBank.isStatementFetchActivated()) {
            if (BankDetailsForm.isFieldEnabled("statementFormat", bank, operatingUser)) {
                switch (this.statementFormat) {
                    case "MT940": {
                        cmBank.setStatementFormat(CMBank.StatementFormat.MT940);
                        break;
                    }
                    case "CFONB120": {
                        cmBank.setStatementFormat(CMBank.StatementFormat.CFONB120);
                        break;
                    }
                    case "CAMT053": {
                        cmBank.setStatementFormat(CMBank.StatementFormat.CAMT053);
                        break;
                    }
                }
            }
            if (BankDetailsForm.isFieldEnabled("statementFetchType", bank, operatingUser)) {
                cmBank.setStatementFetchType(this.statementFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("statementLastFetch", bank, operatingUser) && this.statementLastFetch != null) {
                cmBank.setLastStaFetchDate(new YYMMDD(this.statementLastFetch.getTime()));
            }
            if (BankDetailsForm.isFieldEnabled("statementFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.statementFetchMode)) {
                    cmBank.setStaFetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setStaFetchMode(CmBank.FetchMode.DATE);
                }
            }
        }
        if (BankDetailsForm.isFieldEnabled("adviceActive", bank, operatingUser)) {
            cmBank.setAdviceFetchActivated(this.adviceActive);
        }
        boolean updateVB = false;
        if (cmBank.isAdviceFetchActivated()) {
            if (BankDetailsForm.isFieldEnabled("adviceFormat", bank, operatingUser)) {
                switch (this.adviceFormat) {
                    case "MT942": {
                        cmBank.setAdviceFormat(CMBank.AdviceFormat.MT942);
                        break;
                    }
                    case "CAMT052": {
                        cmBank.setAdviceFormat(CMBank.AdviceFormat.CAMT052);
                        break;
                    }
                }
            }
            if (BankDetailsForm.isFieldEnabled("adviceFetchType", bank, operatingUser)) {
                cmBank.setAdviceFetchType(this.adviceFetchType);
                if (this.adviceLastFetch != null) {
                    cmBank.setLastVmkFetchDate(new YYMMDD(this.adviceLastFetch.getTime()));
                }
            }
            if (BankDetailsForm.isFieldEnabled("adviceFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.adviceFetchMode)) {
                    cmBank.setVmkFetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setVmkFetchMode(CmBank.FetchMode.DATE);
                }
            }
            boolean oldValue = cmBank.getCumulativeAdviceProvision();
            boolean oldValue2 = cmBank.getMultidaysAdviceRepeated();
            if (BankDetailsForm.isFieldEnabled("adviceCumulative", bank, operatingUser)) {
                cmBank.setCumulativeAdviceProvision(this.adviceCumulative);
            }
            if (BankDetailsForm.isFieldEnabled("adviceMultipleBooking", bank, operatingUser)) {
                cmBank.setMultidaysAdviceRepeated(this.adviceMultipleBooking);
            }
            if (oldValue != this.adviceCumulative || oldValue2 != this.adviceMultipleBooking) {
                updateVB = true;
            }
        }
        if (BankDetailsForm.isFieldEnabled("creditAdvicesForSepaInstantCreditTransfersActive", bank, operatingUser)) {
            cmBank.setCreditAdviceFetchActivated(this.creditAdvicesForSepaInstantCreditTransfersActive);
        }
        if (cmBank.isCreditAdviceFetchActivated()) {
            if (BankDetailsForm.isFieldEnabled("creditAdvicesForSepaInstantCreditTransfersFetchType", bank, operatingUser)) {
                cmBank.setCreditAdviceFetchType(this.creditAdvicesForSepaInstantCreditTransfersFetchType);
                if (this.creditAdvicesForSepaInstantCreditTransfersLastFetch != null) {
                    cmBank.setLastCreditAdviceFetchDate(new YYMMDD(this.creditAdvicesForSepaInstantCreditTransfersLastFetch.getTime()));
                }
            }
            if (BankDetailsForm.isFieldEnabled("creditAdvicesForSepaInstantCreditTransfersFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.creditAdvicesForSepaInstantCreditTransfersFetchMode)) {
                    cmBank.setCreditAdviceFetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setCreditAdviceFetchMode(CmBank.FetchMode.DATE);
                }
            }
            boolean oldValue = cmBank.vbCalculationWithCreditAdvices();
            if (BankDetailsForm.isFieldEnabled("vbCalculationWithCreditAdvices", bank, operatingUser)) {
                cmBank.setVbCalculationWithCreditAdvices(this.vbCalculationWithCreditAdvices);
            }
            if (oldValue != this.vbCalculationWithCreditAdvices) {
                updateVB = true;
            }
        }
        if (BankDetailsForm.isFieldEnabled("batchedTransactionFilesActive", bank, operatingUser)) {
            cmBank.setC54FetchActivated(this.batchedTransactionFilesActive);
        }
        if (cmBank.isC54FetchActivated()) {
            if (BankDetailsForm.isFieldEnabled("batchedTransactionFilesFetchType", bank, operatingUser)) {
                cmBank.setC54FetchType(this.batchedTransactionFilesFetchType);
                if (this.batchedTransactionFilesLastFetch != null) {
                    cmBank.setLastC54FetchDate(new YYMMDD(this.batchedTransactionFilesLastFetch.getTime()));
                }
            }
            if (BankDetailsForm.isFieldEnabled("batchedTransactionFilesFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.batchedTransactionFilesFetchMode)) {
                    cmBank.setC54FetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setC54FetchMode(CmBank.FetchMode.DATE);
                }
            }
        }
        boolean bkaActiveNew = cmBank.isBkaFetchActivated();
        if (BankDetailsForm.isFieldEnabled("bkaActive", bank, operatingUser)) {
            bkaActiveNew = this.bkaActive;
            cmBank.setBkaFetchActivated(this.bkaActive);
        }
        if (bkaActiveNew) {
            if (BankDetailsForm.isFieldEnabled("bkaLastFetch", bank, operatingUser) && this.bkaLastFetch != null) {
                cmBank.setLastBkaFetchDate(new YYMMDD(this.bkaLastFetch.getTime()));
            }
            if (BankDetailsForm.isFieldEnabled("bkaFetchType", bank, operatingUser)) {
                String fetchType = this.bkaFetchType.trim();
                if (!fetchType.isEmpty() && !cmBank.getDefaultBkaFetchType().equals(fetchType)) {
                    cmBank.setBkaFetchType(fetchType);
                } else {
                    cmBank.setBkaFetchType(null);
                }
            }
            if (BankDetailsForm.isFieldEnabled("bkaFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.bkaFetchMode)) {
                    cmBank.setBkaFetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setBkaFetchMode(CmBank.FetchMode.DATE);
                }
            }
        }
        boolean bkiActiveNew = cmBank.isBkiFetchActivated();
        if (BankDetailsForm.isFieldEnabled("bkiActive", bank, operatingUser)) {
            bkiActiveNew = this.bkiActive;
            cmBank.setBkiFetchActivated(this.bkiActive);
        }
        if (bkiActiveNew) {
            if (BankDetailsForm.isFieldEnabled("bkiLastFetch", bank, operatingUser) && this.bkiLastFetch != null) {
                cmBank.setLastBkiFetchDate(new YYMMDD(this.bkaLastFetch.getTime()));
            }
            if (BankDetailsForm.isFieldEnabled("bkiFetchType", bank, operatingUser)) {
                String fetchType = this.bkiFetchType.trim();
                if (!fetchType.isEmpty() && !cmBank.getDefaultBkiFetchType().equals(fetchType)) {
                    cmBank.setBkiFetchType(fetchType);
                } else {
                    cmBank.setBkiFetchType(null);
                }
            }
            if (BankDetailsForm.isFieldEnabled("bkiFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.bkiFetchMode)) {
                    cmBank.setBkiFetchMode(CmBank.FetchMode.NEW);
                } else {
                    cmBank.setBkiFetchMode(CmBank.FetchMode.DATE);
                }
            }
        }
        cmBank.save();
        if (updateVB) {
            ValueBalanceCalculator.updateVBwithAdvicesForBank((BankSettings)cmBank.getBank());
        }
        CustomerProtocolSettings protocolHandler = CustomerProtocolSettings.byBank((BankSettings)bank);
        ProtocolFormat newProtocolFormat = protocolHandler.getProtocolFormat();
        if (BankDetailsForm.isFieldEnabled("protocolFormat", bank, operatingUser)) {
            newProtocolFormat = ProtocolFormat.valueOf((String)this.protocolFormat);
        }
        boolean newProtocolActive = protocolHandler.isProtocolActivated();
        if (BankDetailsForm.isFieldEnabled("protocolActive", bank, operatingUser)) {
            newProtocolActive = this.protocolActive;
        }
        protocolHandler.set(newProtocolActive, newProtocolFormat);
        if (BankDetailsForm.isFieldEnabled("protocolFetchMode", bank, operatingUser)) {
            if ("NEW".equals(this.protocolFetchMode)) {
                protocolHandler.setProtocolFetchMode(CmBank.FetchMode.NEW);
            } else {
                protocolHandler.setProtocolFetchMode(CmBank.FetchMode.DATE);
            }
        }
        if (BankDetailsForm.isFieldEnabled("protocolLastFetch", bank, operatingUser)) {
            protocolHandler.setLastProtocolFetchDate((Date)(this.protocolLastFetch != null ? new YYMMDD(this.protocolLastFetch.getTime()) : null));
        }
        NotificationSettings notificationsHandler = NotificationSettings.getForBank((BankSettings)bank);
        boolean notificationsActiveNew = notificationsHandler.isActivated();
        if (BankDetailsForm.isFieldEnabled("notificationsActive", bank, operatingUser)) {
            notificationsActiveNew = this.notificationsActive;
            notificationsHandler.setIsActivated(this.notificationsActive);
        }
        if (notificationsActiveNew) {
            if (BankDetailsForm.isFieldEnabled("notificationsLastFetch", bank, operatingUser) && this.notificationsLastFetch != null) {
                notificationsHandler.setLastFetchDate(new YYMMDD(this.notificationsLastFetch.getTime()));
            }
            if (BankDetailsForm.isFieldEnabled("notificationsFetchMode", bank, operatingUser)) {
                if ("NEW".equals(this.notificationsFetchMode)) {
                    notificationsHandler.setFetchMode(CmBank.FetchMode.NEW);
                } else {
                    notificationsHandler.setFetchMode(CmBank.FetchMode.DATE);
                }
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaTransferActive", bank, operatingUser)) {
                notificationsHandler.setFetchCreditNotifications(this.notificationsSepaTransferActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaTransferFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForCreditNotifications(this.notificationsSepaTransferFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaInstantTransferActive", bank, operatingUser)) {
                notificationsHandler.setFetchInstantNotifications(this.notificationsSepaInstantTransferActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaInstantTransferFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForInstantNotifications(this.notificationsSepaInstantTransferFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaDebitActive", bank, operatingUser)) {
                notificationsHandler.setFetchDebitNotifications(this.notificationsSepaDebitActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaDebitFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForDebitNotifications(this.notificationsSepaDebitFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaCallbackActive", bank, operatingUser)) {
                notificationsHandler.setFetchCallbackNotifications(this.notificationsSepaCallbackActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaCallbackFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForCallbackNotifications(this.notificationsSepaCallbackFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaForeignAcive", bank, operatingUser)) {
                notificationsHandler.setFetchForeignNotifications(this.notificationsSepaForeignActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsSepaForeignFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForForeignNotifications(this.notificationsSepaForeignFetchType);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsVopActive", bank, operatingUser)) {
                notificationsHandler.setFetchVopNotifications(this.notificationsVopActive);
            }
            if (BankDetailsForm.isFieldEnabled("notificationsVopFetchType", bank, operatingUser)) {
                notificationsHandler.setFetchTypeForVopNotifications(this.notificationsVopFetchType);
            }
        }
        notificationsHandler.save();
        if (BankDetailsForm.isFieldEnabled("sendParameters", bank, operatingUser)) {
            ArrayList<PaymentTransferType.PmtType> pmtTypes = new ArrayList<PaymentTransferType.PmtType>(this.sendParameters.keySet());
            for (SendParameters s : SendParameters.getSendParametersForPmtTypes((BankSettings)bank, pmtTypes)) {
                SendparameterInputs value = this.sendParameters.get(s.getPmtType());
                s.setOrderType(value.orderType);
                s.setOrderTypeVop(value.orderTypeVop);
                s.setBtf(value.btf);
                s.setBtfVop(value.btfVop);
                PaymentTransferType.Scheme scheme = value.scheme == null ? null : PaymentTransferType.Scheme.valueOf((String)value.scheme);
                s.setScheme(scheme);
                s.save(bank);
            }
        }
        PaymentProperties paymentProperties = PaymentProperties.findForBank((BankSettings)bank);
        if (BankDetailsForm.isFieldEnabled("dtazvOneLogicalFile", bank, operatingUser)) {
            paymentProperties.setDtazvOneLogicalFilePerOrder(Boolean.valueOf(this.dtazvOneLogicalFile));
        }
        if (BankDetailsForm.isFieldEnabled("mt101OneLogicalFile", bank, operatingUser)) {
            paymentProperties.setMT101OneLogicalFilePerOrder(Boolean.valueOf(this.mt101OneLogicalFile));
        }
        if (BankDetailsForm.isFieldEnabled("mt101SwiftHeader", bank, operatingUser)) {
            paymentProperties.setMT101SwiftHeader(Boolean.valueOf(this.mt101SwiftHeader));
        }
        if (BankDetailsForm.isFieldEnabled("maxExecutionDate", bank, operatingUser)) {
            if (this.maxExecutionDate == null) {
                this.maxExecutionDate = 15;
            }
            paymentProperties.setSepaMaxExecDate(this.maxExecutionDate.intValue());
        }
        if (BankDetailsForm.isFieldEnabled("leadTimeForDebits", bank, operatingUser)) {
            if (this.leadTimeForDebits == null) {
                this.leadTimeForDebits = 1;
            }
            paymentProperties.setSepaLeadTimeForDebits(this.leadTimeForDebits);
        }
        if (BankDetailsForm.isFieldEnabled("urgentPaymentNumberPerFile", bank, operatingUser)) {
            if (this.urgentPaymentNumberPerFile == null) {
                this.urgentPaymentNumberPerFile = 0;
            }
            paymentProperties.setSepaMaxUrgentPaymentsPerFile(this.urgentPaymentNumberPerFile);
        }
        paymentProperties.save();
        DsBank dsBank = DsBank.get((BankSettings)bank);
        if (BankDetailsForm.isFieldEnabled("desActive", bank, operatingUser)) {
            dsBank.setActivated(this.desActive);
        }
        if (BankDetailsForm.isFieldEnabled("desHvz", bank, operatingUser)) {
            dsBank.setHvz(this.desHvz);
        }
        dsBank.save();
        if (!detailsLogged) {
            logger.logBankModified(operatingUser, bank);
        }
    }

    public static class SendparameterInputs {
        private static final char LIMITER = ' ';
        public String orderType;
        public String orderTypeVop;
        public String btf;
        public String btfVop;
        public String scheme;

        public SendparameterInputs() {
        }

        public SendparameterInputs(String orderType, String orderTypeVop, String btf, String btfVop, String scheme) {
            this.orderType = orderType;
            this.orderTypeVop = orderTypeVop;
            this.btf = btf;
            this.btfVop = btfVop;
            this.scheme = scheme;
        }

        public static SendparameterInputs fromString(String str) {
            if (str != null && !str.isEmpty()) {
                int posLimiter1 = str.indexOf(32);
                int posLimiter2 = str.indexOf(32, posLimiter1 + 1);
                int posLimiter3 = str.indexOf(32, posLimiter2 + 1);
                int posLimiter4 = str.indexOf(32, posLimiter3 + 1);
                String orderType = str.substring(0, posLimiter1);
                String orderTypeVop = str.substring(posLimiter1 + 1, posLimiter2);
                String btf = str.substring(posLimiter2 + 1, posLimiter3);
                String btfVop = str.substring(posLimiter3 + 1, posLimiter4);
                String scheme = str.substring(posLimiter4 + 1);
                return new SendparameterInputs(orderType, orderTypeVop, btf, btfVop, scheme);
            }
            return null;
        }

        public String toString() {
            String orderTypeNonNull = this.orderType == null ? "" : this.orderType.replace(" ", "");
            String orderTypeVopNonNull = this.orderTypeVop == null ? "" : this.orderTypeVop.replace(" ", "");
            String btfNonNull = this.btf == null ? "" : this.btf.replace(" ", "");
            String btfVopNonNull = this.btfVop == null ? "" : this.btfVop.replace(" ", "");
            String schemeNonNull = this.scheme == null ? "" : this.scheme;
            return orderTypeNonNull.trim() + " " + orderTypeVopNonNull.trim() + " " + btfNonNull.trim() + " " + btfVopNonNull.trim() + " " + schemeNonNull.trim();
        }
    }

    public static enum Tab {
        BANK("bank"),
        PROTOCOL("protocol"),
        STATEMENTS("statements"),
        BKA("bka"),
        SEND_PARAMETERS("send-parameters"),
        PAYMENTS("payments"),
        DES("des"),
        GENERAL("general"),
        ORDERS("orders"),
        ACCOUNTS("accounts"),
        PERMISSIONS("permissions"),
        USERS("users"),
        NOTIFICATIONS("notifications");

        public final String label;

        private Tab(String label) {
            this.label = label;
        }
    }
}

