/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.awzel.api.CountryProvider;
import de.businesslogics.banking.awzel.api.WareCodeProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelTransitEntry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.AwvNotificationForm;
import play.data.Form;

public final class AwvTransitNotificationForm
extends AwvNotificationForm {
    public Map<Integer, Entry> entries;

    public static List<Integer> getTransitEntryIds(Form<AwvTransitNotificationForm> form) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        form.value().ifPresent(transit -> {
            if (transit.entries != null) {
                result.addAll(transit.entries.keySet());
            }
        });
        result.sort(Comparator.naturalOrder());
        return result;
    }

    public AwvTransitNotificationForm() {
    }

    public AwvTransitNotificationForm(AwzelEntry entry) {
        super(entry);
        List entryVOs = entry.getTransitEntries();
        if (entryVOs != null && !entryVOs.isEmpty()) {
            this.entries = new HashMap<Integer, Entry>();
            int counter = 0;
            for (AwzelTransitEntry vo : entryVOs) {
                this.entries.put(counter++, new Entry(vo));
            }
        }
    }

    @Override
    protected AwzelEntry.EntryType getEntryType() {
        return AwzelEntry.EntryType.TRANSIT;
    }

    @Override
    protected Form<? extends AwvNotificationForm> internalValidate(Form<? extends AwvNotificationForm> form, Locale locale) {
        WareCodeProvider wareCodeProvider = new WareCodeProvider(locale);
        CountryProvider countryProvider = new CountryProvider(locale);
        List<String> settlementKeys = AwvTransitNotificationForm.getSettlementKeys();
        Form result = form;
        if (this.entries != null && !this.entries.isEmpty()) {
            for (Integer id : this.entries.keySet()) {
                Entry entry;
                block13: {
                    entry = this.entries.get(id);
                    if (entry.id != null) {
                        try {
                            if (DB.find(AwzelTransitEntry.class, (Object)entry.id) == null) {
                                BLLoggerPlay.warning("Received unknown database ID for AWV transit entry!");
                                result = result.withError("entries[" + id + "].id", "error.invalid");
                            }
                            break block13;
                        }
                        catch (NumberFormatException e) {
                            BLLoggerPlay.warning("Failed to read database entry from AWV transit form!", e);
                            result = result.withError("entries[" + id + "].id", "error.invalid");
                        }
                        continue;
                    }
                }
                if (entry.wareCode == null || entry.wareCode.isEmpty()) {
                    result = result.withError("entries[" + id + "].wareCode", "error.required");
                } else {
                    entry.wareName = wareCodeProvider.getWareDescription(entry.wareCode);
                    if (entry.wareName.length() > 140) {
                        entry.wareName = entry.wareName.substring(0, 140);
                    }
                }
                if (entry.amount == null) {
                    result = result.withError("entries[" + id + "].amount", "error.required");
                }
                if (entry.settlementKey != null && !settlementKeys.contains(entry.settlementKey)) {
                    result = result.withError("entries[" + id + "].settlementKey", "error.invalid");
                }
                if (entry.country == null || entry.country.isEmpty()) {
                    result = result.withError("entries[" + id + "].country", "error.required");
                    continue;
                }
                if (countryProvider.getCountryNameByISOCode(entry.country) != null) continue;
                result = result.withError("entries[" + id + "].country", "error.invalid");
            }
        } else {
            result = result.withGlobalError(BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.awv.transit.missingEntries", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    protected void internalStore(AwzelEntry entryVO) {
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        if (entryVO.getTransitEntries() == null) {
            entryVO.setTransitEntries(new ArrayList());
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Integer id : this.entries.keySet()) {
            AwzelTransitEntry transit;
            Entry entry = this.entries.get(id);
            if (entry.id == null) {
                transit = new AwzelTransitEntry();
                entryVO.getTransitEntries().add(transit);
            } else {
                ids.add(entry.id);
                transit = null;
                for (AwzelTransitEntry vo2 : entryVO.getTransitEntries()) {
                    if (!vo2.getId().equals(entry.id)) continue;
                    transit = vo2;
                    break;
                }
                if (transit == null) continue;
            }
            transit.setAbstractEntry(entryVO);
            entry.store(transit);
        }
        if (entryVO.getTransitEntries() != null && !entryVO.getTransitEntries().isEmpty()) {
            entryVO.getTransitEntries().forEach(vo -> {
                if (vo.getId() != null && !ids.contains(vo.getId())) {
                    DB.delete((Object)vo);
                }
            });
        }
    }

    public static class Entry {
        public Integer id;
        public String wareCode;
        public String wareName;
        public BigDecimal amount;
        public String amountReference;
        public String settlementKey;
        public String country;

        public Entry() {
        }

        private Entry(AwzelTransitEntry vo) {
            this.id = vo.getId();
            this.wareCode = vo.getWareCode();
            this.wareName = vo.getWareName();
            if (vo.getAmountInEurDouble() != null) {
                this.amount = BigDecimal.valueOf(vo.getAmountInEurDouble());
            }
            this.amountReference = vo.getReferenceAmount();
            if (vo.getSettlementKey() != null) {
                this.settlementKey = String.valueOf(vo.getSettlementKey());
            }
            this.country = vo.getCountryCode();
        }

        private void store(AwzelTransitEntry vo) {
            vo.setWareCode(this.wareCode);
            vo.setWareName(this.wareName);
            if (this.amount != null) {
                vo.setAmountInEur(this.amount.doubleValue());
            } else {
                vo.setAmountInEur(null);
            }
            vo.setReferenceAmount(this.amountReference);
            if (this.settlementKey != null && !this.settlementKey.isEmpty()) {
                vo.setSettlementKey(Character.valueOf(this.settlementKey.charAt(0)));
            } else {
                vo.setSettlementKey(null);
            }
            vo.setCountryCode(this.country);
        }
    }
}

