/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import controllers.util.TenantUtils;
import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.awzel.api.CountryProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelParticipantCompany;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.User;
import io.ebean.Query;
import io.ebean.Update;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class AwvParticipantForm {
    public Integer companyId;
    public String companyNumber;
    public String companyName;
    public String companyStreet;
    public String companyPostbox;
    public String companyPostcode;
    public String companyTown;
    public String companyCountry;
    public Integer companyTenantId;
    public String contactTitle;
    public String contactFirstname;
    public String contactLastname;
    public String contactDepartment;
    public String contactPhone;
    public String contactFax;
    public String contactEmail;
    public String contactExtranetId;
    public String companiesToDelete;

    public static Seq<Tuple2<String, String>> getCompanies(User user, boolean addEmptyField, String emptyFieldText) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        StringBuilder builder = new StringBuilder();
        for (AwzelParticipantCompany company : AwvParticipantForm.getCompanyVos(user)) {
            builder.setLength(0);
            if (company.getName() != null && company.getName().length() > 0) {
                builder.append(company.getName());
            }
            if (company.getInstituteId() != null && company.getInstituteId().length() > 0) {
                if (builder.length() > 0) {
                    builder.append(" - ");
                }
                builder.append(company.getInstituteId());
            }
            result.add(Scala.Tuple((Object)String.valueOf(company.getCompanyId()), (Object)Utils.addZWNJ(builder.toString())));
        }
        if (addEmptyField) {
            result.add(0, Scala.Tuple((Object)"-1", (Object)emptyFieldText));
        }
        return Scala.toSeq(result);
    }

    public static String loadJsParameters(User user, Form<AwvParticipantForm> form) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("hasFormCompanyErrors", AwvParticipantForm.hasFormCompanyErrors(form));
        ArrayNode companiesNode = resultJson.putArray("companies");
        for (AwzelParticipantCompany company : AwvParticipantForm.getCompanyVos(user)) {
            ObjectNode companyNode = companiesNode.addObject();
            companyNode.put("id", company.getCompanyId());
            if (company.getTenant() != null) {
                companyNode.put("tenantId", company.getTenant().getId());
            }
            companyNode.put("number", company.getInstituteId());
            companyNode.put("name", company.getName());
            companyNode.put("street", company.getStreet());
            companyNode.put("postbox", company.getPostOfficeBox());
            companyNode.put("postcode", company.getZipCode());
            companyNode.put("town", company.getTown());
            companyNode.put("country", company.getCountry());
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    private static List<AwzelParticipantCompany> getCompanyVos(User user) {
        ArrayList<AwzelParticipantCompany> result = new ArrayList<AwzelParticipantCompany>();
        Query query = AwzelParticipantCompany.findAll((Collection)user.getTenants());
        query.findEach(result::add);
        return result;
    }

    public static boolean isNoCompany(User user) {
        List<AwzelParticipantCompany> list = AwvParticipantForm.getCompanyVos(user);
        return list == null || list.isEmpty();
    }

    private static boolean hasFormCompanyErrors(Form<AwvParticipantForm> form) {
        if (!form.hasErrors()) {
            return false;
        }
        List<String> companyFieldKeys = Arrays.asList("companyId", "companyNumber", "companyName", "companyStreet", "companyPostbox", "companyPostcode", "companyTown", "companyCountry", "companyTenantId");
        for (ValidationError error : form.errors()) {
            if (!companyFieldKeys.contains(error.key())) continue;
            return true;
        }
        return false;
    }

    public AwvParticipantForm() {
    }

    public AwvParticipantForm(User user) {
        Query query = AwzelParticipantCompany.findAll((Collection)user.getTenants());
        query.setMaxRows(1);
        AwzelParticipantCompany company = (AwzelParticipantCompany)query.findOne();
        if (company != null) {
            this.companyId = company.getCompanyId();
            this.companyNumber = company.getInstituteId();
            this.companyName = company.getName();
            this.companyStreet = company.getStreet();
            this.companyPostbox = company.getPostOfficeBox();
            this.companyPostcode = company.getZipCode();
            this.companyTown = company.getTown();
            this.companyCountry = company.getCountry();
            this.companyTenantId = company.getTenant().getId();
        }
    }

    public AwvParticipantForm(AwzelParticipantContactPerson participant) {
        if (participant.getCompany() != null) {
            this.companyId = participant.getCompany().getCompanyId();
            this.companyNumber = participant.getCompany().getInstituteId();
            this.companyName = participant.getCompany().getName();
            this.companyStreet = participant.getCompany().getStreet();
            this.companyPostbox = participant.getCompany().getPostOfficeBox();
            this.companyPostcode = participant.getCompany().getZipCode();
            this.companyTown = participant.getCompany().getTown();
            this.companyCountry = participant.getCompany().getCountry();
            if (participant.getCompany() != null && participant.getCompany().getTenant() != null) {
                this.companyTenantId = participant.getCompany().getTenant().getId();
            }
        }
        this.contactTitle = participant.getTitle();
        this.contactFirstname = participant.getFirstName();
        this.contactLastname = participant.getSurname();
        this.contactDepartment = participant.getDepartment();
        this.contactPhone = participant.getPhone();
        this.contactFax = participant.getFax();
        this.contactEmail = participant.getEmail();
        this.contactExtranetId = participant.getExtranetId();
    }

    public Form<AwvParticipantForm> validate(Form<AwvParticipantForm> form, User user, AwzelParticipantContactPerson participant, Messages messages) {
        String error;
        Form resultForm = form;
        if (this.companyId == null) {
            resultForm = resultForm.withError("company", "error.required");
        } else if (this.companyId >= 0 && AwzelParticipantCompany.getById((Integer)this.companyId, (User)user) == null) {
            resultForm = resultForm.withError("company", "error.invalid");
        }
        if (this.companyNumber == null || this.companyNumber.isEmpty()) {
            resultForm = resultForm.withError("companyNumber", "error.required");
        } else if (!this.companyNumber.matches("[0-9]{8}")) {
            resultForm = resultForm.withError("companyNumber", "error.invalid");
        }
        if (this.companyName == null || this.companyName.isEmpty()) {
            resultForm = resultForm.withError("companyName", "error.required");
        }
        if (this.companyCountry == null || this.companyCountry.isEmpty()) {
            resultForm = resultForm.withError("companyCountry", "error.required");
        } else if (!this.companyCountry.equals(Locale.GERMANY.getCountry()) && new CountryProvider(Locale.getDefault()).getCountryNameByISOCode(this.companyCountry) == null) {
            resultForm = resultForm.withError("companyCountry", "error.invalid");
        }
        if (this.companyTenantId != null && (error = TenantUtils.checkTenantId(this.companyTenantId, user)) != null) {
            resultForm = resultForm.withError("companyTenantId", error);
        }
        if (resultForm.hasErrors()) {
            resultForm = resultForm.withError("company", "awv.participants.error.invalidcompany");
        }
        if (this.contactLastname == null || this.contactLastname.length() == 0) {
            resultForm = resultForm.withError("contactLastname", "error.required");
        }
        if (this.contactPhone == null || this.contactPhone.length() == 0) {
            resultForm = resultForm.withError("contactPhone", "error.required");
        } else if (!AwzelApi.PHONE_PATTERN.matcher(this.contactPhone).matches()) {
            resultForm = resultForm.withError("contactPhone", "error.invalid");
        }
        if (this.contactFax != null && this.contactFax.length() > 0 && !AwzelApi.PHONE_PATTERN.matcher(this.contactFax).matches()) {
            resultForm = resultForm.withError("contactFax", "error.invalid");
        }
        if (this.contactEmail == null || this.contactEmail.length() == 0) {
            resultForm = resultForm.withError("contactEmail", "error.required");
        } else if (!AwzelApi.SIMPLE_MAIL_PATTERN.matcher(this.contactEmail).matches()) {
            resultForm = resultForm.withError("contactEmail", "error.invalid");
        }
        if (this.contactExtranetId != null && this.contactExtranetId.length() > 0 && !AwzelApi.EXTRANET_ID_PATTERN.matcher(this.contactExtranetId).matches()) {
            resultForm = resultForm.withError("contactExtranetId", "error.invalid");
        }
        if (participant == null) {
            participant = new AwzelParticipantContactPerson();
        }
        AwzelParticipantCompany companyVO = this.companyId != null && this.companyId >= 0 ? AwzelParticipantCompany.getById((Integer)this.companyId, (User)user) : new AwzelParticipantCompany();
        companyVO.setInstituteId(this.companyNumber);
        companyVO.setName(this.companyName);
        companyVO.setStreet(this.companyStreet);
        companyVO.setPostOfficeBox(this.companyPostbox);
        companyVO.setZipCode(this.companyPostcode);
        companyVO.setTown(this.companyTown);
        companyVO.setCountry(this.companyCountry);
        companyVO.setTenant(TenantUtils.getTenantByIdAndUser(this.companyTenantId, user));
        participant.setCompany(companyVO);
        participant.setTitle(this.contactTitle);
        participant.setFirstName(this.contactFirstname);
        participant.setSurname(this.contactLastname);
        participant.setDepartment(this.contactDepartment);
        participant.setPhone(this.contactPhone);
        participant.setFax(this.contactFax);
        participant.setEmail(this.contactEmail);
        participant.setExtranetId(this.contactExtranetId);
        if (!participant.isUnique()) {
            return resultForm.withGlobalError(messages.at("awv.participants.alreadyexists", new Object[0]));
        }
        return resultForm;
    }

    public void store(User user) {
        this.store(new AwzelParticipantContactPerson(), user);
    }

    public void store(AwzelParticipantContactPerson participant, User user) {
        AwzelParticipantCompany companyVO = this.companyId != null && this.companyId >= 0 ? AwzelParticipantCompany.getById((Integer)this.companyId, (User)user) : new AwzelParticipantCompany();
        companyVO.setInstituteId(this.companyNumber);
        companyVO.setName(this.companyName);
        companyVO.setStreet(this.companyStreet);
        companyVO.setPostOfficeBox(this.companyPostbox);
        companyVO.setZipCode(this.companyPostcode);
        companyVO.setTown(this.companyTown);
        companyVO.setCountry(this.companyCountry);
        companyVO.setTenant(TenantUtils.getTenantByIdAndUser(this.companyTenantId, user));
        companyVO.save();
        participant.setCompany(companyVO);
        participant.setTitle(this.contactTitle);
        participant.setFirstName(this.contactFirstname);
        participant.setSurname(this.contactLastname);
        participant.setDepartment(this.contactDepartment);
        participant.setPhone(this.contactPhone);
        participant.setFax(this.contactFax);
        participant.setEmail(this.contactEmail);
        participant.setExtranetId(this.contactExtranetId);
        participant.save();
    }

    public int deleteCompanies() {
        List<Integer> ids;
        if (this.companiesToDelete != null && !this.companiesToDelete.isEmpty() && !(ids = GeneralUtils.getSelectionIds(this.companiesToDelete)).isEmpty()) {
            Update delete;
            if (ids.size() == 1) {
                delete = DB.createUpdate(AwzelParticipantCompany.class, (String)"DELETE FROM AwzelParticipantCompany WHERE companyId = :id");
                delete.set("id", (Object)ids.get(0));
            } else {
                delete = DB.createUpdate(AwzelParticipantCompany.class, (String)"DELETE FROM AwzelParticipantCompany WHERE companyId IN (:ids)");
                delete.set("ids", ids);
            }
            try {
                return delete.execute();
            }
            catch (Exception e) {
                BLLoggerPlay.warning("Failed to delete company!", e);
                return -1;
            }
        }
        return 0;
    }
}

