/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.routes;
import controllers.util.TenantUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.awzel.api.WareCodeProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.User;
import java.nio.charset.StandardCharsets;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public abstract class AwvNotificationForm {
    @Constraints.Required
    public Integer reportMonth;
    @Constraints.Required
    public Integer reportYear;
    @Constraints.Required
    public Integer entryReporter;
    @Constraints.Required
    public Integer category;
    @Constraints.Required
    public String serviceCode;
    public String reportReference;
    public boolean cancellation;
    public String comment;
    public Integer tenantId;

    public static Seq<Tuple2<String, String>> getCategories(AwzelEntry.EntryType entryType, Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (int category : AwvNotificationForm.getCategories(entryType)) {
            result.add(Scala.Tuple((Object)String.valueOf(category), (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.awvNotificationCategory." + category), (Object[])new Object[0])));
        }
        return Scala.toSeq(result);
    }

    private static int[] getCategories(AwzelEntry.EntryType entryType) {
        if (entryType == AwzelEntry.EntryType.DIKA) {
            return new int[]{1, 2, 3, 4};
        }
        if (entryType == AwzelEntry.EntryType.TRANSIT) {
            return new int[]{1, 2, 5, 6};
        }
        if (entryType == AwzelEntry.EntryType.DIRINV) {
            return new int[]{3, 4};
        }
        return new int[0];
    }

    public static Seq<Tuple2<String, String>> getWareCodes(Locale locale) {
        WareCodeProvider wcp = new WareCodeProvider(locale);
        Map list = wcp.getProposals("");
        ArrayList<Tuple2> result = new ArrayList<Tuple2>(3);
        for (String key : list.keySet()) {
            result.add(Scala.Tuple((Object)key, (Object)(key + " - " + wcp.getWareDescription(key))));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                return o2 == null || o2._2 == null ? 0 : 1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSettlementKeys(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>(3);
        for (String key : AwvNotificationForm.getSettlementKeys()) {
            result.add(Scala.Tuple((Object)key, (Object)BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.awv.settlementKey." + key), (Object[])new Object[0])));
        }
        result.sort((o1, o2) -> {
            if (o1 == null || o1._2 == null) {
                return o2 == null || o2._2 == null ? 0 : 1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result);
    }

    protected static List<String> getSettlementKeys() {
        ArrayList<String> result = new ArrayList<String>(2);
        result.add("E");
        result.add("V");
        return result;
    }

    public static Seq<Tuple2<String, String>> getMonths(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (String month : new DateFormatSymbols(locale).getMonths()) {
            if (month == null || month.isEmpty()) continue;
            result.add(Scala.Tuple((Object)String.valueOf(result.size() + 1), (Object)month));
        }
        return Scala.toSeq(result);
    }

    public static String loadJsParameters(Messages messages, AwzelEntry.EntryType entryType) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("fetchingMessage", messages.at("awv.notifications.servicecode.fetching", new Object[0]));
        resultJson.put("unknownServiceCode", messages.at("awv.notifications.unknownservicecode", new Object[]{BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.awv.notifications.type." + entryType.name()), (Object[])new Object[0]), "CATEGORY"}));
        ObjectNode node = resultJson.putObject("categories");
        for (int c : AwvNotificationForm.getCategories(entryType)) {
            node.put("category" + c, BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.awvNotificationCategory." + c), (Object[])new Object[0]));
        }
        node.put("unknown", messages.at("awv.notifications.unknownservicecodenocategory", new Object[]{BankingApiMessages.getString((Locale)messages.lang().locale(), (String)("GeneralMessages.awv.notifications.type." + entryType.name()), (Object[])new Object[0])}));
        resultJson.put("serviceCodesLink", routes.Awv.serviceCodes(entryType.name(), 999, "SEARCH").toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    protected AwvNotificationForm() {
        Calendar cal = Calendar.getInstance();
        this.reportMonth = cal.get(2) + 1;
        this.reportYear = cal.get(1);
    }

    protected AwvNotificationForm(AwzelEntry entry) {
        Matcher m;
        if (entry == null) {
            return;
        }
        if (entry.getReportMonth() != null && (m = Pattern.compile("(\\d{4})(\\d{2})").matcher(entry.getReportMonth())).matches()) {
            this.reportYear = Integer.valueOf(m.group(1));
            this.reportMonth = Integer.valueOf(m.group(2));
        }
        if (entry.getEntryReporter() != null) {
            this.entryReporter = entry.getEntryReporter().getPersonId();
        }
        this.category = entry.getCategory();
        this.serviceCode = entry.getServiceCode();
        this.reportReference = entry.getReportReference();
        this.cancellation = entry.isCancellation();
        this.comment = entry.getComment();
        this.tenantId = entry.getTenant().getId();
    }

    public final Form<? extends AwvNotificationForm> validate(Form<? extends AwvNotificationForm> form, Locale locale, User user) {
        String error;
        Form result = form;
        if (this.reportYear == null || this.reportMonth == null) {
            result = result.withError("reportMonth", "error.required");
        } else if (this.reportMonth < 1 || this.reportMonth > 12) {
            result = result.withError("reportMonth", "error.invalid");
        }
        if (this.entryReporter == null) {
            result = result.withError("entryReporter", "error.required");
        } else if (DB.find(AwzelParticipantContactPerson.class, (Object)this.entryReporter) == null) {
            result = result.withError("entryReporter", "error.invalid");
        }
        if (this.category == null) {
            result = result.withError("category", "error.required");
        } else {
            boolean found = false;
            for (int c : AwvNotificationForm.getCategories(this.getEntryType())) {
                if (this.category != c) continue;
                found = true;
                break;
            }
            if (!found) {
                result = result.withError("category", "error.invalid");
            }
        }
        if (this.serviceCode == null) {
            result = result.withError("serviceCode", "error.required");
        } else if (!this.serviceCode.matches("\\d{3}")) {
            result = result.withError("serviceCode", "error.invalid");
        }
        if (this.reportReference != null) {
            if (this.reportReference.isEmpty()) {
                this.reportReference = null;
            } else if (this.reportReference.length() > 35) {
                this.reportReference = this.reportReference.substring(0, 35);
            }
        }
        if (this.comment != null) {
            if (this.comment.isEmpty()) {
                this.comment = null;
            } else if (this.comment.length() > 80) {
                this.comment = this.comment.substring(0, 80);
            }
        }
        if ((error = TenantUtils.checkTenantId(this.tenantId, user)) != null) {
            result = result.withError("tenantId", error);
        }
        return this.internalValidate((Form<? extends AwvNotificationForm>)result, locale);
    }

    public final void store(User user) {
        AwzelEntry entry = new AwzelEntry();
        entry.setType(this.getEntryType());
        this.store(entry, user);
    }

    public final void store(AwzelEntry entry, User user) {
        entry.setReportMonth(String.format("%1$04d%2$02d", this.reportYear, this.reportMonth));
        entry.setEntryReporter((AwzelParticipantContactPerson)DB.find(AwzelParticipantContactPerson.class, (Object)this.entryReporter));
        entry.setCategory(this.category);
        entry.setServiceCode(this.serviceCode);
        entry.setReportReference(this.reportReference);
        entry.setCancellation(Boolean.valueOf(this.cancellation));
        entry.setComment(this.comment);
        entry.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        this.internalStore(entry);
        entry.save();
    }

    protected abstract AwzelEntry.EntryType getEntryType();

    protected abstract Form<? extends AwvNotificationForm> internalValidate(Form<? extends AwvNotificationForm> var1, Locale var2);

    protected abstract void internalStore(AwzelEntry var1);
}

