/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.awzel.api.AwzelApi;
import de.businesslogics.banking.awzel.api.CountryProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import models.AwvNotificationForm;
import play.data.Form;

public final class AwvDirinvNotificationForm
extends AwvNotificationForm {
    public Map<Integer, Entry> entries;

    public static List<Integer> getDirinvEntryIds(Form<AwvDirinvNotificationForm> form) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        form.value().ifPresent(dirinv -> {
            if (dirinv.entries != null) {
                result.addAll(dirinv.entries.keySet());
            }
        });
        result.sort(Comparator.naturalOrder());
        return result;
    }

    public AwvDirinvNotificationForm() {
    }

    public AwvDirinvNotificationForm(AwzelEntry entry) {
        super(entry);
        List entryVOs = entry.getDirInvEntries();
        if (entryVOs != null && !entryVOs.isEmpty()) {
            this.entries = new HashMap<Integer, Entry>();
            int counter = 0;
            for (AwzelDirInvEntry e : entryVOs) {
                this.entries.put(counter++, new Entry(e));
            }
        }
    }

    @Override
    protected AwzelEntry.EntryType getEntryType() {
        return AwzelEntry.EntryType.DIRINV;
    }

    @Override
    protected Form<? extends AwvNotificationForm> internalValidate(Form<? extends AwvNotificationForm> form, Locale locale) {
        CountryProvider countryProvider = new CountryProvider(locale);
        List<String> settlementKeys = AwvDirinvNotificationForm.getSettlementKeys();
        Form result = form;
        if (this.entries != null && !this.entries.isEmpty()) {
            for (Integer id : this.entries.keySet()) {
                Entry entry = this.entries.get(id);
                if (entry == null) continue;
                if (entry.id != null && DB.find(AwzelDirInvEntry.class, (Object)entry.id) == null) {
                    BLLoggerPlay.warning("Received unknown database ID for AWV dirinv entry!");
                    result = result.withError("entries[" + id + "].id", "error.invalid");
                    continue;
                }
                if (entry.isin == null || entry.isin.isEmpty()) {
                    result = result.withError("entries[" + id + "].isin", "error.required");
                } else if (!AwzelApi.ISIN_PATTERN.matcher(entry.isin).matches()) {
                    result = result.withError("entries[" + id + "].isin", "error.invalid");
                }
                if (entry.label == null || entry.label.isEmpty()) {
                    result = result.withError("entries[" + id + "].label", "error.required");
                }
                if (entry.stockNumber == null) {
                    result = result.withError("entries[" + id + "].stockNumber", "error.required");
                }
                if (entry.amount == null) {
                    result = result.withError("entries[" + id + "].amount", "error.required");
                }
                if (entry.settlementKey != null && !entry.settlementKey.isEmpty() && !settlementKeys.contains(entry.settlementKey)) {
                    result = result.withError("entries[" + id + "].settlementKey", "error.invalid");
                }
                if (entry.country == null || entry.country.isEmpty()) {
                    result = result.withError("entries[" + id + "].country", "error.required");
                    continue;
                }
                if (countryProvider.getCountryNameByISOCode(entry.country) != null) continue;
                result = result.withError("entries[" + id + "].country", "error.invalid");
            }
        } else {
            result = result.withGlobalError(BankingApiMessages.getString((Locale)locale, (String)"GeneralMessages.awv.dirInv.missingBond", (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    protected void internalStore(AwzelEntry entryVO) {
        if (this.entries == null || this.entries.isEmpty()) {
            return;
        }
        if (entryVO.getDirInvEntries() == null) {
            entryVO.setDirInvEntries(new ArrayList());
        }
        HashSet<Integer> ids = new HashSet<Integer>();
        for (Integer id : this.entries.keySet()) {
            AwzelDirInvEntry dirinv;
            Entry entry = this.entries.get(id);
            if (entry.id == null) {
                dirinv = new AwzelDirInvEntry();
                entryVO.getDirInvEntries().add(dirinv);
            } else {
                ids.add(entry.id);
                dirinv = null;
                for (AwzelDirInvEntry vo2 : entryVO.getDirInvEntries()) {
                    if (!vo2.getId().equals(entry.id)) continue;
                    dirinv = vo2;
                    break;
                }
                if (dirinv == null) continue;
            }
            dirinv.setAbstractEntry(entryVO);
            entry.store(dirinv);
        }
        if (entryVO.getDirInvEntries() != null && !entryVO.getDirInvEntries().isEmpty()) {
            entryVO.getDirInvEntries().forEach(vo -> {
                if (vo.getId() != null && !ids.contains(vo.getId())) {
                    DB.delete((Object)vo);
                }
            });
        }
    }

    public static final class Entry {
        public Integer id;
        public String isin;
        public String label;
        public Integer stockNumber;
        public BigDecimal amount;
        public String amountReference;
        public String settlementKey;
        public String country;

        public Entry() {
        }

        private Entry(AwzelDirInvEntry vo) {
            this.id = vo.getId();
            this.isin = vo.getIsin();
            this.label = vo.getLabel();
            this.stockNumber = vo.getStockNumber();
            if (vo.getAmountInEurDouble() != null) {
                this.amount = BigDecimal.valueOf(vo.getAmountInEurDouble());
            }
            this.amountReference = vo.getReferenceAmount();
            if (vo.getSettlementKey() != null) {
                this.settlementKey = vo.getSettlementKey().toString();
            }
            this.country = vo.getCountryCode();
        }

        private void store(AwzelDirInvEntry vo) {
            vo.setIsin(this.isin);
            vo.setLabel(this.label);
            vo.setStockNumber(this.stockNumber);
            if (this.amount != null) {
                vo.setAmountInEur(this.amount.doubleValue());
            } else {
                vo.setAmountInEur(null);
            }
            vo.setReferenceAmount(this.amountReference);
            if (this.settlementKey != null && !this.settlementKey.isEmpty()) {
                vo.setSettlementKey(Character.valueOf(this.settlementKey.charAt(0)));
            } else {
                vo.setSettlementKey(null);
            }
            vo.setCountryCode(this.country);
        }
    }
}

