/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.awzel.api.CountryProvider;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import java.math.BigDecimal;
import java.util.Locale;
import models.AwvNotificationForm;
import play.data.Form;
import play.data.validation.Constraints;

public final class AwvDikaNotificationForm
extends AwvNotificationForm {
    @Constraints.Required
    public BigDecimal amount;
    public String amountReference;
    public Character settlementKey;
    @Constraints.Required
    public String country;
    public String purpose;

    public AwvDikaNotificationForm() {
    }

    public AwvDikaNotificationForm(AwzelEntry entry) {
        super(entry);
        if (entry == null || entry.getType() != AwzelEntry.EntryType.DIKA || entry.getDikaEntry() == null) {
            return;
        }
        if (entry.getDikaEntry().getAmountInEur() != null) {
            this.amount = BigDecimal.valueOf(entry.getDikaEntry().getAmountInEurDouble());
        }
        this.amountReference = entry.getDikaEntry().getReferenceAmount();
        this.settlementKey = entry.getDikaEntry().getSettlementKey();
        this.country = entry.getDikaEntry().getCountryCode();
        this.purpose = entry.getDikaEntry().getPurpose();
    }

    @Override
    protected AwzelEntry.EntryType getEntryType() {
        return AwzelEntry.EntryType.DIKA;
    }

    @Override
    protected Form<? extends AwvNotificationForm> internalValidate(Form<? extends AwvNotificationForm> form, Locale locale) {
        Form resultForm = form;
        if (this.amount == null) {
            resultForm = resultForm.withError("amount", "error.required");
        }
        if (this.amountReference != null && this.amountReference.length() > 35) {
            this.amountReference = this.amountReference.substring(0, 35);
        }
        if (this.country == null || this.country.length() == 0) {
            resultForm = resultForm.withError("country", "error.required");
        } else {
            String countryLabel = new CountryProvider(locale).getCountryLabel(this.country);
            if (countryLabel.length() == 0) {
                resultForm = resultForm.withError("country", "error.invalid");
            }
        }
        if (this.purpose == null || this.purpose.length() == 0) {
            resultForm = resultForm.withError("purpose", "error.required");
        } else if (this.purpose.length() > 140) {
            this.purpose = this.purpose.substring(0, 140);
        }
        return resultForm;
    }

    @Override
    protected void internalStore(AwzelEntry entry) {
        AwzelDikaEntry dika = entry.getDikaEntry();
        if (dika == null) {
            dika = new AwzelDikaEntry();
            dika.setAbstractEntry(entry);
            entry.setDikaEntry(dika);
        }
        dika.setPurpose(this.purpose);
        dika.setAmountInEur(this.amount.doubleValue());
        dika.setCountryCode(this.country);
        dika.setReferenceAmount(this.amountReference);
        dika.setSettlementKey(this.settlementKey);
    }
}

