/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.awzel.data.ReportCreationInfo;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import java.text.MessageFormat;
import java.util.Locale;
import play.data.Form;
import play.i18n.Messages;

public final class AwvCreateReportForm {
    public String monthString;
    public Integer sender;
    public Integer originator;
    public String comment;
    private ReportCreationInfo reportCreationInfo;

    public Form<AwvCreateReportForm> validate(Messages messages, Form<AwvCreateReportForm> form, int month, int year) {
        Form result = form;
        if (month < 1 || month > 12 || year < 0) {
            result = result.withGlobalError(MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.invalidMonth", (Object[])new Object[0]), month));
        }
        AwzelParticipantContactPerson senderContactPerson = null;
        AwzelParticipantContactPerson originatorContactPerson = null;
        if (this.sender == null) {
            result = result.withError("sender", "error.required");
        } else {
            senderContactPerson = (AwzelParticipantContactPerson)DB.find(AwzelParticipantContactPerson.class, (Object)this.sender);
            if (senderContactPerson == null) {
                result = result.withError("sender", "error.invalid");
            }
        }
        if (this.originator != null && (originatorContactPerson = (AwzelParticipantContactPerson)DB.find(AwzelParticipantContactPerson.class, (Object)this.originator)) == null) {
            result = result.withError("originator", "error.invalid");
        }
        if (this.comment != null && this.comment.isEmpty()) {
            this.comment = null;
        }
        if (senderContactPerson != null && !form.hasErrors()) {
            this.reportCreationInfo = new ReportCreationInfo(senderContactPerson.getCompany().getTenant(), senderContactPerson, originatorContactPerson, null, null, this.comment, month, year);
        }
        return result;
    }

    public ReportCreationInfo getReportCreationInfo() {
        return this.reportCreationInfo;
    }
}

