/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.Setup;
import controllers.util.GeneralUtils;
import controllers.util.TenantUtils;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.User;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import play.data.Form;
import play.data.validation.Constraints;

public class AutExportForm {
    public static final String DATE_PATTERN = "$(EXPORTNAME)-$(DATE yyyyMMdd)";
    public static final String BANK_PATTERN = "$(EXPORTNAME)-$(BANK)";
    public static final String BANK_DATE_PATTERN = "$(EXPORTNAME)-$(BANK)-$(DATE yyyyMMdd)";
    public static final String ACCOUNT_DATE_PATTERN = "$(EXPORTNAME)-$(ACCOUNT)-$(DATE yyyyMMdd)";
    public static final String NO_PATTERN = "noPattern";
    public static final String INCORRECT_PATTERN = "incorrectPattern";
    @Constraints.Required
    public String name;
    public boolean active;
    public String conversion;
    public String directory;
    @Constraints.Required
    public String pattern;
    public boolean selectAccounts;
    public String accounts;
    public String folders;
    public AutomaticExport.Type type;
    public Integer tenantId;

    public static AutExportForm fill(AutomaticExport export) {
        AutExportForm toReturn = new AutExportForm();
        toReturn.name = export.getName();
        toReturn.active = export.isActivated();
        toReturn.conversion = export.getConversion() != null ? export.getConversion().getId().toString() : (export.isConvertToPdf() ? "pdfConversion" : "noConversion");
        toReturn.directory = export.getDirectory();
        toReturn.pattern = export.getPattern();
        toReturn.accounts = AutExportForm.getAccountsString(export.getAccounts());
        if (!toReturn.accounts.isEmpty()) {
            toReturn.selectAccounts = true;
        }
        toReturn.folders = AutExportForm.getFolderString(export.getFolders());
        if (!toReturn.selectAccounts && !toReturn.folders.isEmpty()) {
            toReturn.selectAccounts = true;
        }
        toReturn.tenantId = export.getTenant().getId();
        toReturn.type = export.getType();
        return toReturn;
    }

    private static String getFolderString(List<CmFolder> folders2) {
        StringBuilder sb = new StringBuilder();
        Iterator<CmFolder> iterator = folders2.iterator();
        while (iterator.hasNext()) {
            CmFolder folder = iterator.next();
            sb.append(folder.getId());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    private static String getAccountsString(List<Account> accounts2) {
        StringBuilder sb = new StringBuilder();
        Iterator<Account> iterator = accounts2.iterator();
        while (iterator.hasNext()) {
            Account account = iterator.next();
            sb.append(account.getId());
            if (!iterator.hasNext()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static boolean isFieldEnabled(String fieldName, Integer exportId) {
        boolean isNewAutExport;
        boolean bl = isNewAutExport = exportId == null;
        if ("tenantId".equals(fieldName)) {
            return isNewAutExport;
        }
        return true;
    }

    public final Form<AutExportForm> validate(Form<AutExportForm> form, User user) {
        String error = TenantUtils.checkTenantId(this.tenantId, user);
        if (error != null) {
            return form.withError("tenantId", error);
        }
        try {
            Conversion c = Conversion.findById((int)Integer.parseInt(this.conversion), (User)user);
            if (this.tenantId != null && !this.tenantId.equals(c.getTenant().getId())) {
                return form.withError("conversion", "error.required");
            }
        }
        catch (NumberFormatException c) {
            // empty catch block
        }
        if (this.selectAccounts && user.getVisibleTenants().size() > 1) {
            ArrayList<String> visibleSelectedFolders = new ArrayList<String>();
            if (this.folders != null && this.folders.trim().length() > 0) {
                for (Integer i : GeneralUtils.getSelectionIds(this.folders)) {
                    CmFolder f = CmFolder.findById((Integer)i, (User)user);
                    if (f == null || !Objects.equals(this.tenantId, f.getTenant().getId())) continue;
                    visibleSelectedFolders.add(String.valueOf(f.getId()));
                }
            }
            if (!visibleSelectedFolders.isEmpty()) {
                this.folders = String.join((CharSequence)",", visibleSelectedFolders);
            }
            ArrayList<String> visibleSelectedAccounts = new ArrayList<String>();
            if (this.accounts != null && this.accounts.trim().length() > 0) {
                for (Integer i : GeneralUtils.getSelectionIds(this.accounts)) {
                    Account a = Account.findById((int)i);
                    if (!Account.isAccountAllowed((Account)a, (User)user, (boolean)false) || Objects.equals(this.tenantId, a.getBank().getTenant().getId())) continue;
                    visibleSelectedAccounts.add(String.valueOf(a.getId()));
                }
            }
            if (!visibleSelectedAccounts.isEmpty()) {
                this.accounts = String.join((CharSequence)",", visibleSelectedAccounts);
            }
        }
        if (!(this.directory != null && this.directory.length() != 0 || Setup.AUTOMATIC_EXPORT_PATH != null && Setup.AUTOMATIC_EXPORT_PATH.length() != 0)) {
            return form.withError("directory", "error.required");
        }
        return form;
    }

    public AutomaticExport getAutExport(AutomaticExport export, User user) {
        if (AutExportForm.isFieldEnabled("name", export.getId())) {
            export.setName(this.name);
        }
        if (AutExportForm.isFieldEnabled("tenantId", export.getId())) {
            export.setTenant(TenantUtils.getTenantByIdAndUser(this.tenantId, user));
        }
        if (AutExportForm.isFieldEnabled("active", export.getId())) {
            export.setActivated(this.active);
        }
        if (AutExportForm.isFieldEnabled("conversion", export.getId())) {
            try {
                export.setConversion(Conversion.findById((int)Integer.parseInt(this.conversion), (User)user));
                export.setConvertToPdf(false);
            }
            catch (NumberFormatException e) {
                export.setConvertToPdf("pdfConversion".equals(this.conversion));
                export.setConversion(null);
            }
        }
        if (AutExportForm.isFieldEnabled("directory", export.getId())) {
            if (Setup.AUTOMATIC_EXPORT_PATH != null && Setup.AUTOMATIC_EXPORT_PATH.length() != 0) {
                this.directory = new File(Setup.AUTOMATIC_EXPORT_PATH, export.getTenant().getId().toString()).getAbsolutePath();
            }
            export.setDirectory(this.directory);
        }
        if (AutExportForm.isFieldEnabled("type", export.getId())) {
            export.setType(this.type);
        }
        if (AutExportForm.isFieldEnabled("pattern", export.getId())) {
            export.setPattern(this.pattern);
        }
        if (AutExportForm.isFieldEnabled("selectAccounts", export.getId())) {
            if (CmFolder.hasFolders((User)user)) {
                export.setFolders(new ArrayList());
                if (this.selectAccounts && this.folders != null && this.folders.trim().length() > 0) {
                    for (Integer i : GeneralUtils.getSelectionIds(this.folders)) {
                        CmFolder f = CmFolder.findById((Integer)i, (User)user);
                        if (f == null) continue;
                        export.getFolders().add(f);
                    }
                }
            }
            export.setAccounts(new ArrayList());
            if (this.selectAccounts && this.accounts != null && this.accounts.trim().length() > 0) {
                for (Integer i : GeneralUtils.getSelectionIds(this.accounts)) {
                    Account a = Account.findById((int)i);
                    if (!user.isAdmin() && !Account.isAccountAllowed((Account)a, (User)user, (boolean)true) || !export.getTenant().equals(a.getBank().getTenant())) continue;
                    export.getAccounts().add(a);
                }
            }
        }
        return export;
    }
}

