/*
 * Decompiled with CFR 0.152.
 */
package models;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PreferenceUtil;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.sepa.api.SepaForeignRecipientData;
import de.businesslogics.format.sepa.SEPAFeeType;
import de.businesslogics.format.sepa.SEPAPaymentCategory;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.SEPAPurposeCode;
import de.businesslogics.format.sepa.SEPAServiceLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import models.PaymentForm;
import models.SepaPaymentForm;
import models.payments.PaymentContextType;
import models.payments.PaymentException;
import play.data.Form;
import play.data.FormFactory;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public class AustrianForeignPaymentForm
extends SepaPaymentForm {
    private static final List<String> REMOVE_CATEGORIES = Arrays.asList("COMP", "INTP", "IPAY", "IPCA", "IPDO", "IPEA", "IPEC", "IPEW", "IPPS", "IPRT", "IPU2", "IPUW", "MAFC", "MARF", "MP2B", "MP2P", "PEFC", "RELG", "REOD", "RRCT", "RRTP", "SERV", "UNIT");
    private static final List<String> REMOVE_PURP_CATEGORIES = Arrays.asList("COMP", "INTP", "IPAY", "IPCA", "IPDO", "IPEA", "IPEC", "IPEW", "IPPS", "IPRT", "IPU2", "IPUW", "MAFC", "MARF", "MP2B", "MP2P", "PEFC", "RELG", "REOD", "RRCT", "RRTP", "SERV", "UNIT", "HLST", "SPSP");

    public static Seq<Tuple2<String, String>> getCategories(User user, Locale locale) {
        String[] categories;
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (String category : categories = SEPAPaymentCategory.getPaymentCategories((boolean)Util.displayOpenSalaries((User)user))) {
            if (REMOVE_CATEGORIES.contains(category)) continue;
            result.add(Scala.Tuple((Object)category, (Object)SEPAPaymentCategory.getDescription((String)category, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getPurposeCodes(User user, Locale locale) {
        String[] purposeCodes;
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (String purposeCode : purposeCodes = SEPAPurposeCode.getPurposeCodes((boolean)Util.displayOpenSalaries((User)user))) {
            if (REMOVE_PURP_CATEGORIES.contains(purposeCode)) continue;
            result.add(Scala.Tuple((Object)purposeCode, (Object)SEPAPurposeCode.getDescription((String)purposeCode, (Locale)locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> loadATXFeeTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        for (SEPAFeeType fee : SEPAFeeType.values()) {
            if (fee == SEPAFeeType.SLEV) continue;
            result.add(Scala.Tuple((Object)fee.name(), (Object)fee.getDescription(locale)));
        }
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> loadATXInternationalServiceLevel(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)SEPAServiceLevel.NURG.name(), (Object)messages.at("sepapayment.atxNURG", new Object[0])));
        result.add(Scala.Tuple((Object)SEPAServiceLevel.SDVA.name(), (Object)messages.at("sepapayment.atxSDVA", new Object[0])));
        return Scala.toSeq(result);
    }

    public static PaymentTransferType.PmtType[] getPmtTypes() {
        return new PaymentTransferType.PmtType[]{PaymentTransferType.PmtType.AUSTRIAN_FOREIGN, PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE};
    }

    public static boolean isATXPmtType(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN.equals((Object)pmtType) || PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)pmtType);
    }

    public static int getRecipientsCount(User user) {
        return PaymentRecipient.countRecipientsForPaymentTypes(Collections.singletonList(PaymentType.SEPA_FOREIGN), (List)user.getTenants());
    }

    public static List<SepaForeignRecipientData> loadRecipients(User user) {
        ArrayList<SepaForeignRecipientData> result = new ArrayList<SepaForeignRecipientData>();
        for (PaymentRecipient paymentRecipient : PaymentRecipient.findRecipientsForPaymentType((PaymentType)PaymentType.SEPA_FOREIGN, (List)user.getTenants())) {
            SepaForeignRecipientData sepaRecipientData = new SepaForeignRecipientData();
            try {
                sepaRecipientData.setPaymentRecipient(paymentRecipient);
                result.add(sepaRecipientData);
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load recipient with ID " + paymentRecipient.getId(), e);
            }
        }
        result.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        });
        return result;
    }

    public static boolean isFieldEnabled(String fieldName, User user) {
        if ("originatorCountry".equals(fieldName) || "originatorDept".equals(fieldName) || "originatorSubdept".equals(fieldName) || "originatorStreet".equals(fieldName) || "originatorBuildingnumber".equals(fieldName) || "originatorTown".equals(fieldName) || "originatorPostcode".equals(fieldName) || "originatorSubcountry".equals(fieldName)) {
            return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_ORIGINATOR_RECORDING);
        }
        if ("recipientAccount".equals(fieldName) || "recipientDept".equals(fieldName) || "recipientSubdept".equals(fieldName) || "recipientStreet".equals(fieldName) || "recipientBuildingnumber".equals(fieldName) || "recipientPostcode".equals(fieldName) || "recipientTown".equals(fieldName) || "recipientSubcountry".equals(fieldName) || "recipientCountry".equals(fieldName) || "recipientBankCode".equals(fieldName) || "recipientBank".equals(fieldName) || "rememberRecipient".equals(fieldName)) {
            return PreferenceUtil.allowUnrestrictedRecipientRecording((User)user);
        }
        return true;
    }

    public AustrianForeignPaymentForm() {
    }

    public AustrianForeignPaymentForm(PaymentContextType paymentContextType, PaymentTransferType.PmtType pmtType, User user, PaymentFolder folder, boolean singleBooking, boolean saveRecipient) throws PaymentException {
        super(paymentContextType, pmtType, user, folder, singleBooking, saveRecipient);
    }

    public AustrianForeignPaymentForm(Object databaseVO, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(databaseVO, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    public AustrianForeignPaymentForm(Object dsOrder, SEPAPaymentData sepaPaymentData, boolean displaySalaries, boolean allowRecipientRecording, boolean saveRecipient) throws PaymentException {
        super(dsOrder, sepaPaymentData, displaySalaries, allowRecipientRecording, false, saveRecipient);
    }

    @Override
    protected PaymentType getPaymentType(User user) {
        if (this.isCheque) {
            return PaymentType.CHEQUE;
        }
        return PaymentType.SEPA_FOREIGN;
    }

    @Override
    protected Form<? extends PaymentForm> loadSelectedRecipient(Form<? extends PaymentForm> form, User user, Tenant tenant) {
        List paymentRecipients;
        if (this.recipientName == null || this.recipientName.isEmpty()) {
            return form.withError("recipientName", "error.required");
        }
        PaymentRecipient paymentRecipient = PaymentRecipient.findRecipientByDisplayName((PaymentType)PaymentType.SEPA_FOREIGN, (String)this.recipientName, (Tenant)tenant);
        if (paymentRecipient == null && (paymentRecipients = PaymentRecipient.findRecipientByName((PaymentType)PaymentType.SEPA_FOREIGN, (String)this.recipientName, (Tenant)tenant)).size() == 1) {
            paymentRecipient = (PaymentRecipient)paymentRecipients.get(0);
        }
        if (paymentRecipient == null) {
            return form.withError("recipientName", "error.recipientNotFound");
        }
        this.recipientName = paymentRecipient.getName();
        this.recipientAccount = paymentRecipient.getAccountNumber();
        this.recipientBankCode = paymentRecipient.getBankCode();
        return form;
    }

    @Override
    protected PaymentTransferType.PmtType getInternalPmtType() {
        if (this.isCheque) {
            return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE;
        }
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN;
    }

    @Override
    protected Form<? extends PaymentForm> reloadFormInternal(FormFactory formFactory) {
        return formFactory.form(AustrianForeignPaymentForm.class).fill((Object)this);
    }

    @Override
    public boolean isChequePayment(PaymentTransferType.PmtType pmtType) {
        return PaymentTransferType.PmtType.AUSTRIAN_FOREIGN_SEPA_CHEQUE.equals((Object)pmtType);
    }

    @Override
    public boolean isTownMandatoryInStructuredAddress() {
        return true;
    }

    @Override
    protected Form<? extends PaymentForm> validateSEPASpecialisation(Form<? extends PaymentForm> form, FormFactory formFactory, Messages messages) {
        if (this.isCheque) {
            if (this.purposeCode != null) {
                this.purposeCode = null;
                form = form.withError("purposeCode", messages.at("sepapayment.error.resetpurposecode", new Object[0]));
            }
            if (this.feeType != null && !"SHAR".equals(this.feeType)) {
                this.feeType = "SHAR";
                form = form.withGlobalError(messages.at("sepapayment.error.chk.feetype", new Object[0]));
            } else {
                this.feeType = "SHAR";
            }
        }
        return form;
    }
}

