/*
 * Decompiled with CFR 0.152.
 */
package models;

import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.User;
import java.util.ArrayList;
import java.util.List;
import models.PasswordForm;
import play.data.Form;
import play.i18n.Messages;

public final class AppSyncForm
extends PasswordForm {
    public static List<BankUser> getSelectedBankUsers(Form<AppSyncForm> form, User user) {
        ArrayList<BankUser> bankUsers = new ArrayList<BankUser>();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            if (!Boolean.parseBoolean((String)form.rawData().get("bank_" + bankUser.getBank().getBankId())) || bankUser.getState() != BankUser.UserState.READY) continue;
            bankUsers.add(bankUser);
        }
        return bankUsers;
    }

    public Form<AppSyncForm> validate(Form<AppSyncForm> form, User user, List<BankUser> bankUsers, Messages messages) {
        if ((form = this.checkPassword(form, user, PasswordForm.PasswordType.EBICS_PASSWORD, messages.lang().locale())).hasErrors()) {
            return form;
        }
        if (bankUsers.isEmpty()) {
            return form.withGlobalError("syncwithapp.nobanks");
        }
        return form;
    }
}

