/*
 * Decompiled with CFR 0.152.
 */
package models;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Accounts;
import controllers.branding.Branding;
import controllers.routes;
import de.businesslogics.account.Result;
import de.businesslogics.banking.api.BLZCache;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AccountPermission;
import de.businesslogics.banking.database.vo.ApOverwrite;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmStatement;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentType;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.mt940.api.CMBank;
import de.businesslogics.banking.mt940.api.EclipseFreeHelper;
import de.businesslogics.banking.mt940.api.ValueBalanceCalculator;
import de.businesslogics.banking.payments.api.BicLoader;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import io.ebean.Transaction;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import play.data.Form;
import play.data.validation.Constraints;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class AccountForm {
    @Constraints.Required
    public Integer bank;
    public String name;
    public String defaultName;
    public String description;
    public String accountHolder;
    public String accountHolderHTD;
    public String accountNumber;
    public String bankCode;
    public String iban;
    public String bic;
    public String currency;
    public BigDecimal creditLimit;
    public BigDecimal investmentAmount;
    public String infoText;
    public BigDecimal balance;
    public java.util.Date balanceDate;
    public String statementFormat;
    public String adviceFormat;
    public Integer folderId;
    public boolean useVirtualBalances;
    public BigDecimal virtualBalance;
    public java.util.Date virtualStartDate;
    public boolean ignoreAccountInfo;
    public boolean allowPaymentRecording;
    public PaymentOriginator sepaOriginator;
    public PaymentOriginator dtazvOriginator;
    public PaymentOriginator mt101Originator;
    public Integer sepaOriginatorId;
    public Integer dtazvOriginatorId;
    public Integer mt101OriginatorId;
    private BankSettings bankSettings;
    private List<BankUser> permittedBankUsers;
    private List<BankUser> bannedBankUsers;
    public Map<Integer, String> bankUsers = new HashMap<Integer, String>();
    private HashMap<BankUser, AccountPermission> addAccountPermissionOverwrite;
    private Set<ApOverwrite> removeAccountPermissionOverwrite;

    public static boolean isFieldEnabled(String fieldName, User operator, Account account) {
        boolean newAccount = account == null || account.getId() == null;
        boolean isCMAccount = account != null && account.isCMAccount();
        boolean canAccountInfoBeModified = AccountForm.isEditable(account);
        if ("bank".equals(fieldName)) {
            return newAccount;
        }
        if ("name".equals(fieldName)) {
            Tenant tenant = account != null && account.getBank() != null ? account.getBank().getTenant() : null;
            DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.CM, operator, tenant);
            return operator.isAdminOrTenantAdmin() || pref.getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.ALLOW_ACCOUNT_RENAMING_FOR_NONADMINS);
        }
        if ("accountHolder".equals(fieldName) || "creditLimit".equals(fieldName) || "investmentAmount".equals(fieldName) || "infoText".equals(fieldName) || "folderId".equals(fieldName) || "useVirtualBalances".equals(fieldName) || "virtualBalance".equals(fieldName) || "virtualStartDate".equals(fieldName) || "ignoreAccountInfo".equals(fieldName)) {
            return operator.isAdminOrTenantAdmin();
        }
        if ("currency".equals(fieldName) || "description".equals(fieldName) || "accountNumber".equals(fieldName) || "bankCode".equals(fieldName) || "iban".equals(fieldName) || "bic".equals(fieldName)) {
            return canAccountInfoBeModified && !isCMAccount;
        }
        if ("bankUsers".equals(fieldName)) {
            return true;
        }
        return canAccountInfoBeModified;
    }

    public static boolean isEditable(Account account) {
        boolean newAccount = account == null || account.getId() == null;
        boolean isHTDAccount = account != null && account.isHTDAccount();
        return newAccount || !isHTDAccount;
    }

    public static boolean showUserPermissionsTab(User forOperator) {
        return forOperator.isAdmin() || forOperator.isTenantAdmin();
    }

    public static String getTabNameForEditContext(Accounts.EditContext editContext) {
        switch (editContext) {
            case CM: 
            case CM_DETAILS: {
                return "tabcm";
            }
        }
        return "tabgeneral";
    }

    public static AccountForm getEmptyForm() {
        AccountForm account = new AccountForm();
        account.currency = "EUR";
        account.virtualStartDate = new java.util.Date();
        account.allowPaymentRecording = true;
        return account;
    }

    public static String loadJsParameters(User user, int accountID, Accounts.EditContext context, Accounts.AccountType accountType, boolean showUsers) {
        ObjectNode resultJson = Json.newObject();
        resultJson.put("accountType", accountType.name());
        if (showUsers) {
            ArrayNode banksNode = resultJson.putArray("banks");
            Map<Integer, List<Integer>> bankUsers = Accounts.getBankUsers(user);
            StringBuilder builder = new StringBuilder();
            for (Integer bankId : bankUsers.keySet()) {
                ObjectNode node = banksNode.addObject();
                node.put("id", bankId);
                builder.setLength(0);
                for (Integer userId : bankUsers.get(bankId)) {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(userId);
                }
                node.put("users", builder.toString());
            }
            builder.setLength(0);
            for (User userToAdd : User.getAllForTenants((Collection)user.getTenants(), (boolean)true)) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(userToAdd.getId());
                resultJson.put("allUsers", builder.toString());
            }
        }
        resultJson.put("findBlzsLink", routes.Payments.findGermanBankcodes("SEARCH").toString());
        resultJson.put("findBicsLink", routes.Payments.findBics("SEARCH", BicLoader.Service.Sct.name()).toString());
        if (Branding.getBranding().autofillBICFromIBAN()) {
            resultJson.put("bicFromIbanUrl", routes.OpenPayments.getBicFromIban("SEARCH").toString());
        }
        resultJson.put("getEditButtonUrl", routes.Accounts.edit(accountID, context.name(), "TAB").toString());
        resultJson.put("getCancelEditButtonUrl", routes.Accounts.view(accountID, context.name(), "TAB").toString());
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public AccountForm() {
    }

    public AccountForm(Account account, Accounts.AccountType accountType) {
        this.bank = account.getBank().getBankId();
        this.name = account.getName();
        this.defaultName = Account.getCmDisplayName((Account)account);
        this.description = account.getDescription();
        this.accountHolder = account.getAccountHolder();
        this.accountHolderHTD = account.getAccountHolderHTD();
        if (accountType == Accounts.AccountType.DOMESTIC) {
            this.accountNumber = account.getGermanAccountNumber();
            this.bankCode = account.getGermanBankCode();
        } else {
            this.accountNumber = account.getNationalAccountNumber();
            this.bankCode = account.getNationalBankCode();
        }
        this.iban = IbanUtil.formatIBAN((String)account.getIban());
        this.bic = account.getBic();
        this.currency = account.getCurrency();
        CMBank cmBank = CMBank.get((BankSettings)account.getBank());
        this.creditLimit = account.getCreditLimit();
        this.investmentAmount = account.getInvestmentAmount();
        this.infoText = account.getInfoText();
        CmStatement stmt = CmStatement.findNewestStatement((Account)account, (Date)null);
        this.balance = EclipseFreeHelper.getClosingBalance((CmStatement)stmt);
        if (stmt != null) {
            this.balanceDate = stmt.getClosingDate();
        }
        this.statementFormat = cmBank.getStatementFormat().equals((Object)CMBank.StatementFormat.CAMT053) ? "camt.053" : cmBank.getStatementFormat().name();
        this.adviceFormat = cmBank.getAdviceFormat().equals((Object)CMBank.AdviceFormat.CAMT052) ? "camt.052" : cmBank.getAdviceFormat().name();
        if (account.getFolder() != null) {
            this.folderId = account.getFolder().getId();
        }
        this.useVirtualBalances = account.getUseVirtualBalances();
        this.virtualBalance = account.getVirtualStartBalance();
        this.virtualStartDate = account.getVirtualStartDate() != null ? account.getVirtualStartDate() : new java.util.Date();
        this.ignoreAccountInfo = account.getIgnoreAccountInformation();
        this.allowPaymentRecording = !account.isCMAccount();
        for (BankUser bankUser : BankUser.findAllBankUsersForBank((BankSettings)account.getBank())) {
            ApOverwrite apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bankUser, (Account)account);
            if (apOverwrite == null && account.getType() == Account.Type.HTD && !bankUser.getUser().isLocalUser()) {
                this.bankUsers.put(bankUser.getId(), "default");
                continue;
            }
            AccountPermission accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
            this.bankUsers.put(bankUser.getId(), String.valueOf(accountPermission != null));
        }
        if (account.getSepaOriginator() != null) {
            this.sepaOriginator = account.getSepaOriginator();
            this.sepaOriginatorId = account.getSepaOriginator().getId();
        }
        if (account.getDtazvOriginator() != null) {
            this.dtazvOriginator = account.getDtazvOriginator();
            this.dtazvOriginatorId = account.getDtazvOriginator().getId();
        }
        if (account.getMt101Originator() != null) {
            this.mt101Originator = account.getMt101Originator();
            this.mt101OriginatorId = account.getMt101Originator().getId();
        }
    }

    public Form<AccountForm> validate(Form<AccountForm> form, Account account, Accounts.AccountType accountType, User user, Messages messages, boolean newAccount) {
        CmFolder folder;
        this.name = this.checkString(this.name, 50, false);
        this.bankSettings = BankSettings.getById((Integer)this.bank);
        BankUser bankUser = null;
        if (account == null || account.getType() == Account.Type.MANUAL) {
            String href;
            Integer id;
            Account existingAccount;
            if (!newAccount && this.bankSettings != null && account != null && !this.bankSettings.equals(account.getBank())) {
                return form.withError("bank", messages.at("accounts.error.bankchange", new Object[0]));
            }
            if (this.bankSettings != null) {
                bankUser = BankUser.findBankUser((BankSettings)this.bankSettings, (User)user);
            }
            if (bankUser == null) {
                form = form.withError("bank", messages.at("error.required", new Object[0]));
            }
            this.description = this.checkString(this.description, 256, false);
            this.accountHolder = this.checkString(this.accountHolder, 256, false);
            if (this.currency != null && this.currency.length() != 3) {
                form = form.withError("currency", messages.at("error.invalid", new Object[0]));
            }
            boolean allowInvalidBankConnection = new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.ALLOW_INVALID_BANK_CONNECTION);
            this.accountNumber = StringUtils.removeLeadingChars((String)this.checkString(this.accountNumber, -1, true), (char)'0');
            this.bankCode = this.checkString(this.bankCode, -1, true);
            this.iban = this.checkString(this.iban, -1, true);
            this.bic = this.checkString(this.bic, -1, true);
            if (!(this.accountNumber != null && this.accountNumber.length() != 0 && (accountType != Accounts.AccountType.DOMESTIC || this.bankCode != null && this.bankCode.length() != 0) || this.iban != null && this.iban.length() != 0)) {
                form = form.withError("accountNumber", messages.at("accounts.insufficientparameters." + accountType.name().toLowerCase(), new Object[0]));
            }
            if (accountType == Accounts.AccountType.DOMESTIC) {
                if (this.accountNumber != null && this.accountNumber.length() > 0 && !RegularExpressions.GERMAN_ACCOUNT_NUMBER.matches(this.accountNumber)) {
                    form = form.withError("accountNumber", messages.at("error.invalid", new Object[0]));
                }
                if (this.bankCode != null && this.bankCode.length() > 0 && !RegularExpressions.GERMAN_BANK_CODE.matches(this.bankCode)) {
                    form = form.withError("bankCode", messages.at("error.invalid", new Object[0]));
                }
                if (!(form.hasErrors() || allowInvalidBankConnection || this.accountNumber == null || this.accountNumber.length() <= 0 || this.bankCode != null && this.bankCode.length() != 0 && BLZCache.checkAccountNumber((String)this.bankCode, (String)this.accountNumber) != Result.INVALID)) {
                    form = form.withError("accountNumber", messages.at("payment.error.invalidbankconnection", new Object[0]));
                }
                existingAccount = !form.hasErrors() && this.bankCode != null && this.bankCode.length() > 0 && this.accountNumber != null && this.accountNumber.length() > 0 ? Account.findGermanAccount((BankSettings)this.bankSettings, (String)this.bankCode, (String)this.accountNumber, (String)this.currency) : null;
            } else {
                if (this.accountNumber == null || this.accountNumber.isEmpty()) {
                    form = form.withError("accountNumber", messages.at("error.required", new Object[0]));
                } else if (this.accountNumber.length() > 40) {
                    form = form.withError("accountNumber", messages.at("error.invalid", new Object[0]));
                }
                if (this.bankCode != null && this.bankCode.length() > 30) {
                    form = form.withError("bankCode", messages.at("error.invalid", new Object[0]));
                }
                existingAccount = !form.hasErrors() ? Account.findNationalAccount((BankSettings)this.bankSettings, (String)this.bankCode, (String)this.accountNumber, (String)this.currency) : null;
            }
            if (account == null && existingAccount != null || account != null && existingAccount != null && !account.getId().equals(existingAccount.getId())) {
                form = form.withError("accountNumber", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.duplicatedAccountNumber", (Object[])new Object[0]));
                if (existingAccount.isCMAccount() && (id = existingAccount.getId()) != null) {
                    href = routes.Accounts.edit(id, Accounts.EditContext.ACCOUNT_LIST.name(), "tabcm").toString();
                    form = form.withError("flashwarning", messages.at("payment.error.cmaccountexists", new Object[]{href}));
                }
            }
            if (this.iban != null && this.iban.length() > 0 && !IbanUtil.checkIban((String)this.iban)) {
                form = form.withError("iban", messages.at("error.invalid", new Object[0]));
            }
            if (this.iban != null && this.iban.length() > 0) {
                existingAccount = Account.findAccountByIban((BankSettings)this.bankSettings, (String)this.iban, (String)this.currency);
                if (account == null && existingAccount != null || account != null && existingAccount != null && !account.getId().equals(existingAccount.getId())) {
                    form = form.withError("iban", BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.duplicatedIBAN", (Object[])new Object[0]));
                    if (existingAccount.isCMAccount() && !form.error("flashwarning").isPresent() && (id = existingAccount.getId()) != null) {
                        href = routes.Accounts.edit(id, Accounts.EditContext.ACCOUNT_LIST.name(), "tabcm").toString();
                        form = form.withError("flashwarning", messages.at("payment.error.cmaccountexists", new Object[]{href}));
                    }
                }
            }
            if (this.bic != null && this.bic.length() > 0 && (!RegularExpressions.BIC.matches(this.bic) || !allowInvalidBankConnection && BicLoader.getInstance().getBankName(this.bic) == null)) {
                form = form.withError("bic", messages.at("error.invalid", new Object[0]));
            }
        }
        if (this.creditLimit != null && this.creditLimit.compareTo(BigDecimal.ZERO) < 0) {
            form = form.withError("creditLimit", messages.at("error.invalid", new Object[0]));
        }
        if (this.investmentAmount != null && this.investmentAmount.compareTo(BigDecimal.ZERO) < 0) {
            form = form.withError("investmentAmount", messages.at("error.invalid", new Object[0]));
        }
        if (this.folderId != null && (folder = CmFolder.findById((Integer)this.folderId, (User)user)) == null) {
            form = form.withError("folderId", messages.at("error.invalid", new Object[0]));
        }
        if (this.useVirtualBalances) {
            if (this.virtualBalance == null) {
                form = form.withError("virtualBalance", messages.at("error.required", new Object[0]));
            }
            if (this.virtualStartDate == null) {
                form = form.withError("virtualStartDate", messages.at("error.required", new Object[0]));
            }
        }
        this.permittedBankUsers = new ArrayList<BankUser>();
        this.bannedBankUsers = new ArrayList<BankUser>();
        this.addAccountPermissionOverwrite = new HashMap();
        this.removeAccountPermissionOverwrite = new HashSet<ApOverwrite>();
        if (!form.hasErrors() && user.isAdmin() && account != null) {
            for (BankUser bUser : BankUser.findAllBankUsersForBank((BankSettings)this.bankSettings)) {
                boolean defaultSettingPossible;
                String accountPermissionOption = ((AccountForm)form.get()).bankUsers.get(bUser.getId());
                ApOverwrite apOverwrite = ApOverwrite.findByBankAndAccount((BankUser)bUser, (Account)account);
                AccountPermission accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bUser, (Account)account);
                boolean bl = defaultSettingPossible = account.isHTDAccount() && (bUser.getUser() == null && !user.isLocalUser() || bUser.getUser() != null && !bUser.getUser().isLocalUser());
                if (!defaultSettingPossible && "default".equals(accountPermissionOption)) {
                    accountPermissionOption = "true";
                }
                if ("default".equals(accountPermissionOption)) {
                    if (apOverwrite == null) continue;
                    if (apOverwrite.isPreviousEnabled() && accountPermission == null) {
                        this.permittedBankUsers.add(bUser);
                    } else if (!apOverwrite.isPreviousEnabled() && accountPermission != null) {
                        this.bannedBankUsers.add(bUser);
                    }
                    this.removeAccountPermissionOverwrite.add(apOverwrite);
                    continue;
                }
                if (Boolean.TRUE.equals(Boolean.valueOf(accountPermissionOption))) {
                    if (account.getType() == Account.Type.HTD && apOverwrite == null) {
                        this.addAccountPermissionOverwrite.put(bUser, accountPermission);
                    }
                    if (accountPermission != null) continue;
                    this.permittedBankUsers.add(bUser);
                    continue;
                }
                if (account.getType() == Account.Type.HTD) {
                    if (apOverwrite == null) {
                        this.addAccountPermissionOverwrite.put(bUser, accountPermission);
                    }
                    if (accountPermission == null) continue;
                    this.bannedBankUsers.add(bUser);
                    continue;
                }
                if (accountPermission == null) continue;
                this.bannedBankUsers.add(bUser);
            }
        }
        if (!form.hasErrors() && account != null) {
            if (this.sepaOriginatorId != null && this.sepaOriginatorId > 0) {
                this.sepaOriginator = PaymentOriginator.findById((int)this.sepaOriginatorId, (User)user);
            }
            if (this.dtazvOriginatorId != null && this.dtazvOriginatorId > 0) {
                this.dtazvOriginator = PaymentOriginator.findById((int)this.dtazvOriginatorId, (User)user);
            }
            if (this.mt101OriginatorId != null && this.mt101OriginatorId > 0) {
                this.mt101Originator = PaymentOriginator.findById((int)this.mt101OriginatorId, (User)user);
            }
        }
        return form;
    }

    public void save(Account account, Accounts.AccountType accountType, boolean newAccount, User user) {
        try (Transaction t = DB.beginTransaction();){
            HashMap<Logger.AccountField, String[]> modifiedFields = new HashMap<Logger.AccountField, String[]>();
            if (AccountForm.isFieldEnabled("name", user, account)) {
                if (!newAccount && !Objects.equals(account.getName(), this.name)) {
                    modifiedFields.put(Logger.AccountField.NAME, new String[]{account.getName(), this.name});
                }
                if (this.name != null && this.name.trim().length() > 0) {
                    account.setName(this.name);
                } else {
                    account.setName(null);
                }
            }
            if (account.getType() == Account.Type.MANUAL) {
                if (newAccount) {
                    account.setBank(this.bankSettings);
                }
                if (AccountForm.isFieldEnabled("description", user, account)) {
                    account.setDescription(this.description);
                }
                if (accountType == Accounts.AccountType.DOMESTIC) {
                    if (AccountForm.isFieldEnabled("accountNumber", user, account)) {
                        if (!newAccount && !Objects.equals(account.getGermanAccountNumber(), this.accountNumber)) {
                            modifiedFields.put(Logger.AccountField.ACCOUNT_NUMBER, new String[]{account.getGermanAccountNumber(), this.accountNumber});
                        }
                        account.setGermanAccountNumber(this.accountNumber);
                    }
                    if (AccountForm.isFieldEnabled("bankCode", user, account)) {
                        if (!newAccount && !Objects.equals(account.getGermanBankCode(), this.bankCode)) {
                            modifiedFields.put(Logger.AccountField.BANK_CODE, new String[]{account.getGermanBankCode(), this.bankCode});
                        }
                        account.setGermanBankCode(this.bankCode);
                    }
                } else {
                    if (AccountForm.isFieldEnabled("accountNumber", user, account)) {
                        if (!newAccount && !Objects.equals(account.getNationalAccountNumber(), this.accountNumber)) {
                            modifiedFields.put(Logger.AccountField.ACCOUNT_NUMBER, new String[]{account.getNationalAccountNumber(), this.accountNumber});
                        }
                        account.setNationalAccountNumber(this.accountNumber);
                    }
                    if (AccountForm.isFieldEnabled("bankCode", user, account)) {
                        if (!newAccount && !Objects.equals(account.getNationalBankCode(), this.bankCode)) {
                            modifiedFields.put(Logger.AccountField.BANK_CODE, new String[]{account.getNationalBankCode(), this.bankCode});
                        }
                        account.setNationalBankCode(this.bankCode);
                    }
                }
                if (AccountForm.isFieldEnabled("iban", user, account)) {
                    if (!newAccount && !Objects.equals(account.getIban(), this.iban)) {
                        modifiedFields.put(Logger.AccountField.IBAN, new String[]{account.getIban(), this.iban});
                    }
                    account.setIban(this.iban);
                }
                if (AccountForm.isFieldEnabled("bic", user, account)) {
                    if (!newAccount && !Objects.equals(account.getBic(), this.bic)) {
                        modifiedFields.put(Logger.AccountField.BIC, new String[]{account.getBic(), this.bic});
                    }
                    account.setBic(this.bic);
                }
                if (AccountForm.isFieldEnabled("currency", user, account)) {
                    if (!newAccount && !Objects.equals(account.getCurrency(), this.currency)) {
                        modifiedFields.put(Logger.AccountField.CURRENCY, new String[]{account.getCurrency(), this.currency});
                    }
                    account.setCurrency(this.currency);
                }
            }
            if (AccountForm.isFieldEnabled("accountHolder", user, account)) {
                if (!newAccount && !Objects.equals(account.getAccountHolder(), this.accountHolder)) {
                    modifiedFields.put(Logger.AccountField.ACCOUNT_HOLDER, new String[]{account.getAccountHolder(), this.accountHolder});
                }
                account.setAccountHolder(this.accountHolder);
            }
            if (AccountForm.isFieldEnabled("creditLimit", user, account)) {
                if (!newAccount && !Objects.equals(account.getCreditLimit(), this.creditLimit)) {
                    modifiedFields.put(Logger.AccountField.CREDIT_LIMIT, new String[]{String.valueOf(account.getCreditLimit()), String.valueOf(this.creditLimit)});
                }
                account.setCreditLimit(this.creditLimit);
            }
            if (AccountForm.isFieldEnabled("investmentAmount", user, account)) {
                if (!newAccount && !Objects.equals(account.getInvestmentAmount(), this.investmentAmount)) {
                    modifiedFields.put(Logger.AccountField.INVESTMENT_AMOUNT, new String[]{String.valueOf(account.getInvestmentAmount()), String.valueOf(this.investmentAmount)});
                }
                account.setInvestmentAmount(this.investmentAmount);
            }
            if (AccountForm.isFieldEnabled("infoText", user, account)) {
                account.setInfoText(this.infoText);
            }
            boolean vbRecalculate = account.setVirtualBalance(this.useVirtualBalances, this.virtualBalance, this.virtualStartDate == null ? null : new Date(this.virtualStartDate.getTime()));
            if (AccountForm.isFieldEnabled("ignoreAccountInfo", user, account)) {
                account.setIgnoreAccountInformation(Boolean.valueOf(this.ignoreAccountInfo));
            }
            if (AccountForm.isFieldEnabled("allowPaymentRecording", user, account)) {
                if (this.allowPaymentRecording && account.isCMAccount()) {
                    account.setType(Account.Type.MANUAL);
                } else if (!this.allowPaymentRecording && !account.isHTDAccount()) {
                    account.setType(Account.Type.CASH_MANAGEMENT);
                }
            }
            if (AccountForm.isFieldEnabled("folderId", user, account)) {
                if (this.folderId != null) {
                    CmFolder cmFolder = CmFolder.findById((Integer)this.folderId, (User)user);
                    account.setFolder(cmFolder);
                } else {
                    account.setFolder(null);
                }
            }
            if (!newAccount) {
                this.sepaOriginator = this.sepaOriginatorId != null && this.sepaOriginatorId > 0 ? PaymentOriginator.findById((int)this.sepaOriginatorId, (User)user) : null;
                this.dtazvOriginator = this.dtazvOriginatorId != null && this.dtazvOriginatorId > 0 ? PaymentOriginator.findById((int)this.dtazvOriginatorId, (User)user) : null;
                this.mt101Originator = this.mt101OriginatorId != null && this.mt101OriginatorId > 0 ? PaymentOriginator.findById((int)this.mt101OriginatorId, (User)user) : null;
                account.setSepaOriginator(this.sepaOriginator);
                account.setDtazvOriginator(this.dtazvOriginator);
                account.setMt101Originator(this.mt101Originator);
            }
            account.save();
            if (newAccount) {
                Logger.logAccountCreated((User)user, (Account)account);
            } else {
                for (Map.Entry entry : modifiedFields.entrySet()) {
                    Logger.logAccountModified((User)user, (Account)account, (Logger.AccountField)((Logger.AccountField)entry.getKey()), (String)((String[])entry.getValue())[0], (String)((String[])entry.getValue())[1]);
                }
            }
            if (vbRecalculate) {
                ValueBalanceCalculator.recalculate((Account)account);
            }
            if (newAccount) {
                accountPermission = new AccountPermission();
                accountPermission.setAccount(account);
                accountPermission.setBankUser(BankUser.findBankUser((BankSettings)account.getBank(), (User)user));
                accountPermission.save();
            } else {
                if (this.removeAccountPermissionOverwrite != null) {
                    for (ApOverwrite apOverwrite : this.removeAccountPermissionOverwrite) {
                        apOverwrite.delete();
                    }
                }
                if (this.addAccountPermissionOverwrite != null) {
                    for (Map.Entry entry : this.addAccountPermissionOverwrite.entrySet()) {
                        ApOverwrite apOverwrite = new ApOverwrite();
                        apOverwrite.setBankUser((BankUser)entry.getKey());
                        apOverwrite.setAccount(account);
                        apOverwrite.setPreviousEnabled(entry.getValue() != null);
                        if (apOverwrite.getBankUser() == null || apOverwrite.getBankUser().getId() == null) {
                            apOverwrite.setBankUser(BankUser.findBankUser((BankSettings)this.bankSettings, (User)user));
                        }
                        apOverwrite.save();
                    }
                }
                if (this.bannedBankUsers != null) {
                    for (BankUser bankUser : this.bannedBankUsers) {
                        accountPermission = AccountPermission.findAccountPermissionForBank((BankUser)bankUser, (Account)account);
                        if (accountPermission == null) continue;
                        accountPermission.delete();
                    }
                }
                if (this.permittedBankUsers != null) {
                    for (BankUser bankUser : this.permittedBankUsers) {
                        accountPermission = new AccountPermission();
                        accountPermission.setAccount(account);
                        accountPermission.setBankUser(bankUser);
                        accountPermission.save();
                    }
                }
            }
            t.commit();
        }
    }

    private String checkString(String s, int maxLength, boolean removeSpaces) {
        if (s == null) {
            return null;
        }
        if (removeSpaces) {
            s = s.replaceAll(" ", "");
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if (maxLength > 0 && s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    private static Seq<Tuple2<String, String>> loadOriginators(Tenant tenant, PaymentType type) {
        ArrayList<Tuple2> result2 = new ArrayList<Tuple2>();
        result2.add(Scala.Tuple((Object)"-1", (Object)""));
        for (PaymentOriginator paymentOriginator : PaymentOriginator.findOriginatorsForPaymentType((PaymentType)type, Collections.singletonList(tenant))) {
            result2.add(Scala.Tuple((Object)paymentOriginator.getId().toString(), (Object)paymentOriginator.getName()));
        }
        result2.sort((o1, o2) -> {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            return ((String)o1._2).compareTo((String)o2._2);
        });
        return Scala.toSeq(result2);
    }

    public static Seq<Tuple2<String, String>> loadSEPAOriginators(Tenant tenant) {
        return AccountForm.loadOriginators(tenant, PaymentType.SEPA);
    }

    public static Seq<Tuple2<String, String>> loadDTAZVOriginators(Tenant tenant) {
        return AccountForm.loadOriginators(tenant, PaymentType.DTAZV);
    }

    public static Seq<Tuple2<String, String>> loadMT101Originators(Tenant tenant) {
        return AccountForm.loadOriginators(tenant, PaymentType.MT101);
    }
}

