/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import com.typesafe.config.Config;
import controllers.util.BLLoggerPlay;
import controllers.util.BlBankingWebPreferenceConstants;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.UserNotification;
import de.businesslogics.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import play.i18n.Lang;

public final class UserNotificationHandler {
    private static UserNotificationHandler instance;
    private static String[] pushCommand;
    private static String pushPublicKey;
    private static String pushPrivateKey;
    private static String pushSubject;
    private Boolean supportWebPush;

    private UserNotificationHandler() {
    }

    public static UserNotificationHandler getInstance() {
        if (instance == null) {
            instance = new UserNotificationHandler();
        }
        return instance;
    }

    public static void setupPushNotificationFromConfig(Config config) {
        if (config.hasPath("command")) {
            pushCommand = config.getString("command").split(" ");
        }
        if (config.hasPath("vapid.publickey")) {
            pushPublicKey = config.getString("vapid.publickey");
        }
        if (config.hasPath("vapid.privatekey")) {
            pushPrivateKey = config.getString("vapid.privatekey");
        }
        if (config.hasPath("subject")) {
            pushSubject = config.getString("subject");
        }
    }

    public String getPublicKey() {
        return pushPublicKey;
    }

    public boolean isPushNotificationActive(User user) {
        if (this.supportWebPush == null) {
            try {
                Process process = Runtime.getRuntime().exec(pushCommand);
                int processResult = process.waitFor();
                this.supportWebPush = processResult == 1 && new String(Streams.readAll((InputStream)process.getInputStream())).trim().startsWith("Usage:");
            }
            catch (IOException | InterruptedException e) {
                BLLoggerPlay.error("Failed to check for web-push!");
                this.supportWebPush = false;
            }
        }
        return this.supportWebPush != false && new DatabasePreferenceStore(Preference.ApplicationId.BL_BANKING_WEB, user).getBoolean((DatabasePreferenceConstant)BlBankingWebPreferenceConstants.PUSH_NOTIFICATIONS_ACTIVE);
    }

    public boolean isMailNotificationActive(User user) {
        return new DatabasePreferenceStore(Preference.ApplicationId.BL_BANKING_WEB, user).getBoolean((DatabasePreferenceConstant)BlBankingWebPreferenceConstants.MAIL_NOTIFICATIONS_ACTIVE);
    }

    public void sendMessage(User user, Function<Lang, String> messageResolver) {
        new Thread(() -> {
            for (UserNotification userNotification : UserNotification.findForUser((User)user)) {
                try {
                    Properties props = new Properties();
                    props.load(new ByteArrayInputStream(userNotification.getInfo()));
                    String message = (String)messageResolver.apply(Lang.forCode((String)props.getProperty("lang")));
                    if (userNotification.getType() == UserNotification.NotificationType.WEB_PUSH && this.isPushNotificationActive(user) && !this.sendWebPushNotification(props, message)) {
                        DB.delete((Object)userNotification);
                        continue;
                    }
                    if (userNotification.getType() != UserNotification.NotificationType.MAIL || !this.isMailNotificationActive(user)) continue;
                    this.sendMailNotification(props, message);
                }
                catch (IOException | InterruptedException e) {
                    BLLoggerPlay.error("Failed to send web push notification!", e);
                }
            }
        }).start();
    }

    public void registerPushNotification(User user, String lang, String url, String key, String auth) throws IOException {
        Properties props;
        for (UserNotification notification : UserNotification.findForUser((User)user)) {
            if (notification.getType() != UserNotification.NotificationType.WEB_PUSH) continue;
            props = new Properties();
            props.load(new ByteArrayInputStream(notification.getInfo()));
            if (!lang.equals(props.getProperty("lang")) || !url.equals(props.getProperty("url")) || !key.equals(props.getProperty("key")) || !auth.equals(props.getProperty("auth"))) continue;
            return;
        }
        props = new Properties();
        props.setProperty("url", url);
        props.setProperty("key", key);
        props.setProperty("auth", auth);
        props.setProperty("lang", lang);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        props.store(baos, null);
        baos.close();
        UserNotification userNotification = new UserNotification();
        userNotification.setUser(user);
        userNotification.setType(UserNotification.NotificationType.WEB_PUSH);
        userNotification.setInfo(baos.toByteArray());
        userNotification.save();
    }

    private boolean sendWebPushNotification(Properties properties, String message) throws IOException, InterruptedException {
        String[] command = (String[])Stream.concat(Arrays.stream(pushCommand), Stream.of("send-notification", "--endpoint=" + properties.getProperty("url"), " --key=" + properties.getProperty("key"), "--auth=" + properties.getProperty("auth"), "--payload=" + message, "--ttl", "3600", "--vapid-subject=" + pushSubject, "--vapid-pubkey=" + this.getPublicKey(), "--vapid-pvtkey=" + pushPrivateKey)).toArray(String[]::new);
        Process process = Runtime.getRuntime().exec(command);
        if (process.waitFor(1L, TimeUnit.MINUTES)) {
            return true;
        }
        InputStream is = process.getErrorStream();
        BLLoggerPlay.error("Failed to execute web-push!\n" + new String(Streams.readAll((InputStream)is)));
        is.close();
        return false;
    }

    private void sendMailNotification(Properties properties, String message) {
    }

    static {
        pushCommand = new String[]{"npm", "exec", "--", "web-push"};
        pushPublicKey = "BLUUo5D-ZrJulczTDOItvSpUISu0Jqt1iFaj7rfaLRucH4BISGznQQ-yR7YUF-QhsW4y2qukKt39AI2Bx-ZXMtc";
        pushPrivateKey = "OVLi_ZVIC_OK2_1mkKZYLZgsChpq965bVRSUxHJQn94";
        pushSubject = "mailto:info@business-logics.de";
    }
}

