/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.DatabaseConnection;
import controllers.Setup;
import controllers.util.BLLoggerPlay;
import controllers.util.SchedulerThrowableHandler;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.ClusterNode;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.ebics.client.EbicsHttpEngineImpl;
import de.businesslogics.io.Streams;
import de.businesslogics.persistence.DBType;
import de.businesslogics.util.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class UpdateCheck
extends DefaultHandler
implements Runnable {
    private final SchedulerThrowableHandler catcher;

    public UpdateCheck(SchedulerThrowableHandler catcher) {
        this.catcher = catcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            String orderClause = DBType.PSQL.equals((Object)DatabaseConnection.getInstance().getDbType()) ? "lastLogin DESC NULLS LAST" : "lastLogin DESC";
            User user = (User)DB.find(User.class).where().isNotNull("webLicense").order(orderClause).setMaxRows(1).findOne();
            if (user != null) {
                String licenseCheckUrl = "https://www.blbanking.de/license/migrate/" + user.getWebLicense().getId() + "/" + this.urlEncode(System.getProperty("os.name") + "|" + System.getProperty("os.arch") + "|" + System.getProperty("os.version") + "|" + Locale.getDefault().toString() + "|" + System.getProperty("java.version") + "|" + de.businesslogics.banking.database.api.DatabaseConnection.getDatabaseType()) + "/" + Setup.VERSION;
                HttpsURLConnection con = (HttpsURLConnection)new URI(licenseCheckUrl).toURL().openConnection();
                EbicsHttpEngineImpl.setSSLSocketFactory((HttpsURLConnection)con);
                con.setDoOutput(true);
                String s = new String(Streams.readAllAndClose((InputStream)con.getInputStream()), StandardCharsets.UTF_8);
                String[] ids = s.split(";");
                if (!Boolean.parseBoolean(ids[0])) {
                    BLLoggerPlay.warning("I'm not checking for updates, as the update-check is not allowed for license " + user.getWebLicense().getId());
                    SystemUtils.close((AutoCloseable)inputStream);
                    return;
                }
                String version = ids[1];
                if (version != null && this.compareVersions(Setup.VERSION, version) > 0) {
                    Setup.NEW_VERSION = version.trim();
                    ClusterNode thisNode = ClusterNode.getThisNode();
                    if (thisNode != null) {
                        for (ClusterNode node : DB.find(ClusterNode.class).findList()) {
                            if (node.getId().equals(thisNode.getId())) continue;
                            String nodeBaseURL = node.getBaseURL();
                            URLConnection connection = new URI(nodeBaseURL + "/cluster/updateCheck/" + Setup.NEW_VERSION).toURL().openConnection();
                            connection.addRequestProperty("secret", node.getSecret());
                            connection.getInputStream().close();
                        }
                    }
                }
                SystemUtils.close((AutoCloseable)inputStream);
                return;
            }
            URL url = new URI(System.getProperty("de.businesslogics.banking.updateUrl", "https://www.blbanking.de/web_updates.xml")).toURL();
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            EbicsHttpEngineImpl.setSSLSocketFactory((HttpsURLConnection)con);
            con.setDoOutput(true);
            inputStream = con.getInputStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputStream, (DefaultHandler)this);
            SystemUtils.close((AutoCloseable)inputStream);
            return;
        }
        catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
            BLLoggerPlay.error("Error during update check", e);
            this.catcher.handleThrowable(e);
            return;
        }
        finally {
            SystemUtils.close(inputStream);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!"entry".equals(localName)) {
            return;
        }
        String version = attributes.getValue("newVersion");
        if (version != null && this.compareVersions(Setup.VERSION, version) > 0) {
            Setup.NEW_VERSION = version.trim();
        }
    }

    private int compareVersions(String version1, String version2) {
        try {
            String[] version1Parts = version1.trim().split("\\.");
            String[] version2Parts = version2.trim().split("\\.");
            for (int i = 0; i < version1Parts.length || i < version2Parts.length; ++i) {
                int version2PartInt;
                int version1PartInt = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0;
                if (version1PartInt == (version2PartInt = i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0)) continue;
                return version2PartInt - version1PartInt;
            }
        }
        catch (NumberFormatException nfe) {
            BLLoggerPlay.warning("Non-numerical version found, cannot check for update! Local version: " + version1 + ", update version: " + version2);
        }
        return 0;
    }

    private String urlEncode(String value) {
        return URLEncoder.encode(value.replaceAll(" ", ""), StandardCharsets.UTF_8);
    }
}

