/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.Setup;
import controllers.util.BLLoggerAdmin;
import de.businesslogics.banking.api.AdminLogger;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.AutomaticExport;
import de.businesslogics.banking.database.vo.AwzelDikaEntry;
import de.businesslogics.banking.database.vo.AwzelDirInvEntry;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.AwzelExport;
import de.businesslogics.banking.database.vo.AwzelParticipantCompany;
import de.businesslogics.banking.database.vo.AwzelParticipantContactPerson;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.CmFolder;
import de.businesslogics.banking.database.vo.CmValueGroup;
import de.businesslogics.banking.database.vo.Conversion;
import de.businesslogics.banking.database.vo.ConverterFormat;
import de.businesslogics.banking.database.vo.ExportFile;
import de.businesslogics.banking.database.vo.LoginSession;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentFolder;
import de.businesslogics.banking.database.vo.PaymentOriginator;
import de.businesslogics.banking.database.vo.PaymentRecipient;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Tenant;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.Yubikey;
import de.businesslogics.banking.mt940.api.CmCleanUp;
import de.businesslogics.util.BLLogger;
import io.ebean.Transaction;
import io.ebean.Update;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import models.banks.BankDeleteHandler;
import models.payments.PaymentHandler;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public class TenantUtils {
    public static final String USE_ALL_TENANTS = "-1";
    public static final String KEEP_CURRENT_TENANT = "0";

    public static String checkTenantId(Integer tenantId, User user) {
        return TenantUtils.checkTenantId(tenantId, user, false);
    }

    public static String checkTenantId(Integer tenantId, User user, boolean managedTenants) {
        if (tenantId != null) {
            Tenant tenant = Tenant.findById((int)tenantId, (User)user, (boolean)managedTenants);
            if (tenant == null) {
                return "tenants.noPermission";
            }
        } else {
            int listSize;
            int n = listSize = managedTenants ? user.getManageableTenants().size() : user.getTenants().size();
            if (listSize > 1) {
                return "error.required";
            }
        }
        return null;
    }

    public static Tenant getTenantByIdAndUser(Integer tenantId, User user) {
        return TenantUtils.getTenantByIdAndUser(tenantId, user, false);
    }

    public static Tenant getTenantByIdAndUser(Integer tenantId, User user, boolean managedTenants) {
        if (tenantId != null) {
            return Tenant.findById((int)tenantId, (User)user, (boolean)managedTenants);
        }
        if (managedTenants && user.getManageableTenants().size() == 1) {
            return (Tenant)user.getManageableTenants().get(0);
        }
        if (!managedTenants && user.getTenants().size() == 1) {
            return (Tenant)user.getTenants().get(0);
        }
        return null;
    }

    public static Seq<Tuple2<String, String>> getTenantOptions(User user, boolean managedTenants, List<Tenant> tenants2, boolean includeDefaultOption, Messages messages) {
        return Scala.toSeq(TenantUtils.getInteralTenantOptions(user, managedTenants, tenants2, includeDefaultOption, messages));
    }

    private static List<Tuple2<String, String>> getInteralTenantOptions(User user, boolean managedTenants, List<Tenant> tenants2, boolean includeDefaultOption, Messages messages) {
        ArrayList<Tuple2<String, String>> options = new ArrayList<Tuple2<String, String>>();
        if (includeDefaultOption) {
            options.add((Tuple2<String, String>)new Tuple2((Object)KEEP_CURRENT_TENANT, (Object)messages.at("tenants.select.keepCurrent", new Object[0])));
        }
        if (tenants2 == null) {
            tenants2 = managedTenants ? user.getManageableTenants() : user.getTenants();
        }
        for (Tenant t : tenants2) {
            options.add((Tuple2<String, String>)new Tuple2((Object)t.getId().toString(), (Object)Utils.addZWNJ(t.getName())));
        }
        return options;
    }

    public static Seq<Tuple2<String, String>> getManagedTenantOptionsIncludingAllTenants(User user, boolean managedTenants, List<Tenant> tenants2, Messages messages) {
        return TenantUtils.getManagedTenantOptionsIncludingAllTenants(user, managedTenants, tenants2, false, messages);
    }

    public static Seq<Tuple2<String, String>> getManagedTenantOptionsIncludingAllTenants(User user, boolean managedTenants, List<Tenant> tenants2, boolean includeDefaultOption, Messages messages) {
        List<Tuple2<String, String>> options = TenantUtils.getInteralTenantOptions(user, managedTenants, tenants2, includeDefaultOption, messages);
        options.add(0, (Tuple2<String, String>)new Tuple2((Object)USE_ALL_TENANTS, (Object)messages.at("general.allTenants", new Object[0])));
        return Scala.toSeq(options);
    }

    public static Tenant findTenantForConverterFormat(BankSettings bank, List<PaymentHandler<?>> payments, User user) {
        if (bank != null) {
            return bank.getTenant();
        }
        for (PaymentHandler<?> payment : payments) {
            for (BankSettings b : BankSettings.findBanksForUser((User)user)) {
                Account originatorAccount = payment.getOriginatorAccount(b);
                if (originatorAccount == null) continue;
                return originatorAccount.getBank().getTenant();
            }
        }
        return (Tenant)user.getTenants().get(0);
    }

    public static List<User> prepareDeleteCheckForEmptyUsers(Tenant tenant) {
        ArrayList<User> result = new ArrayList<User>();
        for (User user : tenant.getUsers()) {
            if (user.getTenants().size() != 1) continue;
            result.add(user);
        }
        return result;
    }

    public static List<String> prepareDeleteQuestion(Tenant tenant, Messages messages) {
        List companies;
        ArrayList<String> result = new ArrayList<String>();
        int number2 = DB.find(BankSettings.class).where().eq("tenant", (Object)tenant).findCount();
        if (number2 > 0) {
            result.add(messages.at("tenants.delete.dependencies.banks", new Object[]{number2}));
        }
        if ((number2 = TenantUtils.prepareDeleteCheckForEmptyUsers(tenant).size()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.users", new Object[]{number2}));
        }
        if ((number2 = DB.find(PaymentRecipient.class).where().eq("tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.recipients", new Object[]{number2}));
        }
        if ((number2 = DB.find(PaymentOriginator.class).where().eq("tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.originators", new Object[]{number2}));
        }
        if ((number2 = DB.find(AutomaticExport.class).where().eq("tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.automaticexports", new Object[]{number2}));
        }
        if ((number2 = DB.find(ExportFile.class).where().eq("accounts.bank.tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.exportedFiles", new Object[]{number2}));
        }
        if ((number2 = DB.find(Conversion.class).where().eq("tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.conversions", new Object[]{number2}));
        }
        if ((number2 = DB.find(AwzelEntry.class).where().eq("tenant", (Object)tenant).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.awv", new Object[]{number2}));
        }
        if (!(companies = DB.find(AwzelParticipantCompany.class).where().eq("tenant", (Object)tenant).findList()).isEmpty() && (number2 = DB.find(AwzelParticipantContactPerson.class).where().in("company", (Collection)companies).findCount()) > 0) {
            result.add(messages.at("tenants.delete.dependencies.awvparticipants", new Object[]{number2}));
        }
        return result;
    }

    public static void deleteTenant(Tenant tenant, User user) {
        try (Transaction t = DB.beginTransaction();){
            AdminLogger logger = new AdminLogger((BLLogger)BLLoggerAdmin.getLogger());
            List banksToDelete = BankSettings.findBanksForTenants(Collections.singletonList(tenant));
            BankDeleteHandler.deleteBanks(banksToDelete, user);
            banksToDelete.forEach(b -> logger.logBankDeleted(user, b));
            Update delete = DB.createUpdate(ConverterFormat.class, (String)"DELETE FROM ConverterFormat WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(PaymentFolder.class, (String)"DELETE FROM PaymentFolder WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(PaymentRecipient.class, (String)"DELETE FROM PaymentRecipient WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(PaymentOriginator.class, (String)"DELETE FROM PaymentOriginator WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(CmValueGroup.class, (String)"DELETE FROM CmValueGroup WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(CmFolder.class, (String)"DELETE FROM CmFolder WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            HashSet<Integer> ids = new HashSet<Integer>();
            for (ExportFile ef : DB.find(ExportFile.class).where().eq("exports.tenant", (Object)tenant).findList()) {
                ids.add(ef.getId());
            }
            for (Integer i : ids) {
                CmCleanUp.delete((ExportFile)((ExportFile)DB.find(ExportFile.class, (Object)i)));
            }
            delete = DB.createUpdate(AutomaticExport.class, (String)"DELETE FROM AutomaticExport WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(Conversion.class, (String)"DELETE FROM Conversion WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelExport.class, (String)"DELETE FROM AwzelExport WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelParticipantContactPerson.class, (String)"DELETE FROM AwzelParticipantContactPerson WHERE company in (SELECT id FROM awv_company WHERE tenant_id=:tenant)");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelParticipantCompany.class, (String)"DELETE FROM AwzelParticipantCompany WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelDikaEntry.class, (String)"DELETE FROM AwzelDikaEntry WHERE abstractEntry in (SELECT id from awv_entry WHERE tenant_id=:tenant)");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelDirInvEntry.class, (String)"DELETE FROM AwzelDirInvEntry WHERE abstractEntry in (SELECT id from awv_entry WHERE tenant_id=:tenant)");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            delete = DB.createUpdate(AwzelEntry.class, (String)"DELETE FROM AwzelEntry WHERE tenant=:tenant");
            delete.set("tenant", (Object)tenant.getId());
            delete.execute();
            Preference.deleteByTenant((Tenant)tenant);
            for (User u : DB.find(User.class).where().in("managedTenants", new Object[]{tenant}).findList()) {
                u.getManagedTenants().remove(tenant);
                u.save();
            }
            for (User u : DB.find(User.class).setIncludeSoftDeletes().where().in("tenants", new Object[]{tenant}).findList()) {
                if (u.getTenants().size() == 1) {
                    LoginSession.deleteByUser((User)u);
                    u.delete(Setup.DELETE_USER_NAME);
                    int nDeleted = Yubikey.deleteByUser((User)u);
                    if (nDeleted > 0) {
                        logger.logDeletedAllYubikeysForUser(user, u);
                    }
                    logger.logUserDeleted(user, u);
                    continue;
                }
                u.getTenants().remove(tenant);
                u.save();
                logger.logTenantDroppedUser(user, u, tenant);
            }
            DB.delete((Object)tenant);
            t.commit();
            logger.logTenantDeleted(user, tenant);
        }
    }

    public static void moveBankToTenant(BankSettings bank, Tenant tenant, User user) {
        HashMap<String, PaymentFolder> tenantPaymentFolders = new HashMap<String, PaymentFolder>();
        for (OpenPayment openPayment : DB.find(OpenPayment.class).where().isNotNull("folder").eq("bank", (Object)bank).ne("folder.tenant", (Object)tenant).findList()) {
            openPayment.setFolder(TenantUtils.getFolder(tenantPaymentFolders, tenant, openPayment.getFolder().getName()));
            DB.update((Object)openPayment);
        }
        for (PeriodicPayment periodicPayment : DB.find(PeriodicPayment.class).where().isNotNull("folder").eq("bank", (Object)bank).ne("folder.tenant", (Object)tenant).findList()) {
            periodicPayment.setFolder(TenantUtils.getFolder(tenantPaymentFolders, tenant, periodicPayment.getFolder().getName()));
            DB.update((Object)periodicPayment);
        }
        HashMap<String, CmFolder> tenantCmFolders = new HashMap<String, CmFolder>();
        HashMap<String, CmValueGroup> tenantCmValueGroups = new HashMap<String, CmValueGroup>();
        for (Account account : Account.findAccountsForBank((BankSettings)bank)) {
            if (account.getFolder() != null && account.getFolder().getTenant().equals(tenant)) {
                CmFolder cmFolder = (CmFolder)tenantCmFolders.get(account.getFolder().getName());
                if (cmFolder == null) {
                    cmFolder = CmFolder.findByName((String)account.getFolder().getName(), (Tenant)tenant);
                    if (cmFolder == null) {
                        cmFolder = new CmFolder();
                        cmFolder.setTenant(tenant);
                        cmFolder.setName(account.getFolder().getName());
                        DB.save((Object)cmFolder);
                    }
                    tenantCmFolders.put(account.getFolder().getName(), cmFolder);
                }
                account.setFolder(cmFolder);
            }
            Iterator iterator = account.getValueGroups().iterator();
            while (iterator.hasNext()) {
                CmValueGroup sourceCmValueGroup = (CmValueGroup)iterator.next();
                if (sourceCmValueGroup.getTenant().equals(tenant)) continue;
                CmValueGroup targetCmValueGroup = (CmValueGroup)tenantCmValueGroups.get(sourceCmValueGroup.getName());
                if (targetCmValueGroup == null) {
                    targetCmValueGroup = CmValueGroup.findByName((String)sourceCmValueGroup.getName(), (Tenant)tenant);
                    if (targetCmValueGroup == null) {
                        targetCmValueGroup = new CmValueGroup();
                        targetCmValueGroup.setTenant(tenant);
                        targetCmValueGroup.setName(sourceCmValueGroup.getName());
                        DB.save((Object)targetCmValueGroup);
                    }
                    tenantCmValueGroups.put(sourceCmValueGroup.getName(), targetCmValueGroup);
                }
                account.getValueGroups().add(targetCmValueGroup);
                iterator.remove();
            }
            account.save();
        }
        for (AutomaticExport automaticExport : DB.find(AutomaticExport.class).where().eq("tenant", (Object)bank.getTenant()).findList()) {
            boolean copyExport = false;
            for (Account account : automaticExport.getAccounts()) {
                if (!account.getBank().equals(bank)) continue;
                copyExport = true;
                break;
            }
            if (!copyExport) continue;
            AutomaticExport newAutomaticExport = new AutomaticExport();
            newAutomaticExport.setTenant(tenant);
            newAutomaticExport.setType(automaticExport.getType());
            newAutomaticExport.setName(automaticExport.getName());
            newAutomaticExport.setActivated(automaticExport.isActivated());
            newAutomaticExport.setConvertToPdf(automaticExport.isConvertToPdf());
            String directory = Setup.AUTOMATIC_EXPORT_PATH != null && Setup.AUTOMATIC_EXPORT_PATH.length() != 0 ? new File(Setup.AUTOMATIC_EXPORT_PATH, tenant.getId().toString()).getAbsolutePath() : automaticExport.getDirectory();
            newAutomaticExport.setDirectory(directory);
            newAutomaticExport.setPattern(automaticExport.getPattern());
            newAutomaticExport.setAccounts(new ArrayList());
            for (Account account : automaticExport.getAccounts()) {
                if (!account.getBank().equals(bank)) continue;
                newAutomaticExport.getAccounts().add(account);
            }
            if (automaticExport.getConversion() != null) {
                Conversion conversion = Conversion.byName((String)automaticExport.getConversion().getName(), (Tenant)tenant);
                if (conversion == null) {
                    conversion = new Conversion();
                    conversion.setTenant(tenant);
                    conversion.setName(automaticExport.getConversion().getName());
                    conversion.setType(automaticExport.getConversion().getType());
                    conversion.setIncludeHeader(automaticExport.getConversion().isIncludeHeader());
                    conversion.setFieldSeparator(automaticExport.getConversion().getFieldSeparator());
                    conversion.setTextSeparator(automaticExport.getConversion().getTextSeparator());
                    conversion.setDateFormat(automaticExport.getConversion().getDateFormat());
                    conversion.setNumberFormat(automaticExport.getConversion().getNumberFormat());
                    conversion.setFields(automaticExport.getConversion().getFields());
                    conversion.save();
                }
                newAutomaticExport.setConversion(conversion);
            }
            newAutomaticExport.save();
        }
        for (BankUser bankUser : DB.find(BankUser.class).where().eq("bank", (Object)bank).findList()) {
            if (bankUser.getUser().getTenants().contains(tenant)) continue;
            bankUser.getUser().getTenants().add(tenant);
            if (bankUser.getUser().getManagedTenants().contains(bank.getTenant())) {
                bankUser.getUser().getManagedTenants().add(tenant);
            }
            bankUser.getUser().save();
        }
        Tenant oldTenant = bank.getTenant();
        bank.setTenant(tenant);
        bank.save();
        new AdminLogger((BLLogger)BLLoggerAdmin.getLogger()).logBankMovedToTenant(user, bank, oldTenant);
    }

    private static PaymentFolder getFolder(Map<String, PaymentFolder> tenantFolders, Tenant tenant, String folderName) {
        PaymentFolder result = tenantFolders.get(folderName);
        if (result == null) {
            result = PaymentFolder.findByName((String)folderName, (Tenant)tenant);
            if (result == null) {
                result = new PaymentFolder();
                result.setTenant(tenant);
                result.setName(folderName);
                DB.save((Object)result);
            }
            tenantFolders.put(result.getName(), result);
        }
        return result;
    }

    private TenantUtils() {
    }
}

