/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.GeneralUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.SendUtil;
import io.ebean.Query;
import io.ebeaninternal.api.SpiQuery;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import play.api.mvc.Call;
import play.i18n.Messages;
import play.libs.Json;
import views.Utils;

public final class SortingHandler {
    public static final String PROPS_TENANT = "TENANT";
    private static final String PROPS_PAGENUMBER = "pageNumber";
    private final Sorting sorting;
    private Properties properties;
    private int totalCount = -1;
    private int pageSize = -1;
    private int pageCount = -1;
    private int pageNumber = -1;

    public SortingHandler(User user, Sorting.Table table) {
        this.sorting = Sorting.getSorting((User)user, (Sorting.Table)table);
    }

    public void updateSort(int column, boolean ascending) {
        this.sorting.setSortingColumn(Integer.valueOf(column));
        this.sorting.setSortAscending(ascending);
        this.sorting.save();
    }

    public void updatePage(int pageNumber, int pageSize) {
        this.pageNumber = Math.max(0, pageNumber);
        this.pageSize = Math.max(pageSize, 1);
        this.sorting.setPageSize(Integer.valueOf(this.pageSize));
        this.setProperty(PROPS_PAGENUMBER, String.valueOf(this.pageNumber));
    }

    public Sorting getSorting() {
        return this.sorting;
    }

    public int getSortingColumn() {
        return this.getSortingColumn(0);
    }

    public int getSortingColumn(int defaultValue) {
        return this.sorting.getSortingColumn() == null ? defaultValue : this.sorting.getSortingColumn();
    }

    public boolean isSortingAscending() {
        return this.isSortingAscending(true);
    }

    public boolean isSortingAscending(boolean defaultValue) {
        return this.sorting.getSortingColumn() == null ? defaultValue : this.sorting.isSortAscending();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    private void loadSettings() {
        this.pageSize = this.sorting.getPageSize() != null ? this.sorting.getPageSize() : 200;
        try {
            this.pageNumber = Integer.parseInt(this.getProperties().getProperty(PROPS_PAGENUMBER, "0"));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to read parameters from sorting properties for table " + String.valueOf(this.sorting.getTable()) + "!", e);
            this.pageNumber = 0;
        }
        this.pageCount = this.totalCount / this.pageSize;
        if (this.pageCount == 0 || this.totalCount % this.pageSize != 0) {
            ++this.pageCount;
        }
    }

    public void computeForQuery(Query<?> query) {
        SpiQuery copy = (SpiQuery)query.copy();
        copy.setSelectId();
        copy.setOrderBy(null);
        copy.setFirstRow(0);
        copy.setMaxRows(Sorting.MAX_RESULT_SIZE);
        this.totalCount = copy.findIds().size();
        this.loadSettings();
        if (this.pageNumber >= this.pageCount) {
            this.pageNumber = this.pageCount - 1;
        }
        if (this.pageCount > 1) {
            query.setFirstRow(this.pageNumber * this.pageSize);
            query.setMaxRows(this.pageSize);
        }
    }

    public <T> List<T> computeForList(List<T> list) {
        this.totalCount = list.size();
        this.loadSettings();
        if (this.pageNumber >= this.pageCount) {
            this.pageNumber = this.pageCount - 1;
        }
        int fromIndex = this.pageNumber * this.pageSize;
        int toIndex = Math.min(list.size(), fromIndex + this.pageSize);
        return list.subList(fromIndex, toIndex);
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProperties().getProperty(key, defaultValue);
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.getProperties().remove(key);
        } else {
            this.getProperties().setProperty(key, value);
        }
        GeneralUtils.storeSortingProperties(this.getProperties(), this.sorting);
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = GeneralUtils.getSortingProperties(this.sorting);
        }
        return this.properties;
    }

    private int[] getDefaultColumOrder() {
        TableHandler handler = TableHandler.getHandler(this.sorting.getTable());
        if (handler != null) {
            return handler.getDefaultColumnOrder();
        }
        return new int[0];
    }

    public int[] getColumnOrder() {
        int[] defaultOrder = this.getDefaultColumOrder();
        int[] result = (int[])defaultOrder.clone();
        int[] ordering = this.sorting.getColumnOrder();
        if (ordering != null) {
            System.arraycopy(ordering, 0, result, 0, Math.min(ordering.length, defaultOrder.length));
        }
        return result;
    }

    public void setColumnOrder(String columnOrderString) {
        String[] parts = columnOrderString.split(",");
        int[] columnOrder = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            columnOrder[i] = Integer.parseInt(parts[i]);
        }
        this.setColumnOrder(columnOrder);
    }

    public void setColumnOrder(int[] columnOrder) {
        this.sorting.setColumnOrder(columnOrder);
        this.sorting.save();
    }

    public String getColumnOrderString() {
        return Arrays.stream(this.getColumnOrder()).mapToObj(String::valueOf).collect(Collectors.joining(","));
    }

    public String getDefaultColumnOrderString() {
        return Arrays.stream(this.getDefaultColumOrder()).mapToObj(String::valueOf).collect(Collectors.joining(","));
    }

    public int getPositionForColumn(int columnId) {
        int[] ordering = this.getColumnOrder();
        if (ordering != null) {
            for (int index2 = 0; index2 < ordering.length; ++index2) {
                if (ordering[index2] != columnId) continue;
                return index2;
            }
        }
        return columnId;
    }

    public String getDefaultColumnVisibilityString() {
        return Arrays.stream(this.getDefaultColumnVisibility()).mapToObj(String::valueOf).collect(Collectors.joining(","));
    }

    public String getColumnVisibilityString() {
        return Arrays.stream(this.getColumnVisibility()).mapToObj(String::valueOf).collect(Collectors.joining(","));
    }

    public int[] getDefaultColumnVisibility() {
        int[] defaultVisibility = new int[this.getDefaultColumOrder().length];
        Arrays.fill(defaultVisibility, 1);
        TableHandler handler = TableHandler.getHandler(this.sorting.getTable());
        if (handler != null) {
            for (ColumnHandler columnHandler : handler.getColumns()) {
                if (columnHandler.isVisibleByDefault(this)) continue;
                defaultVisibility[columnHandler.getColumnId()] = 0;
            }
        }
        return defaultVisibility;
    }

    public int[] getColumnVisibility() {
        int[] defaultVisibility = this.getDefaultColumnVisibility();
        int[] sizes = (int[])defaultVisibility.clone();
        String sizesString = this.sorting.getColumnSizes();
        if (sizesString != null && !sizesString.isEmpty()) {
            String[] sizesStringSplit = sizesString.split(",");
            for (int i = 0; i < Math.min(sizesStringSplit.length, sizes.length); ++i) {
                String s = sizesStringSplit[i];
                sizes[i] = "P0".equals(s) || "W0".equals(s) ? 0 : 1;
            }
        }
        return sizes;
    }

    public boolean isColumnDisplayed(int columnId) {
        int[] sizes = this.getColumnVisibility();
        if (sizes.length > columnId) {
            return sizes[columnId] == 1;
        }
        return true;
    }

    public void setColumnVisibilities(String columnVisibilityString) {
        String columnSizes = columnVisibilityString == null || columnVisibilityString.isEmpty() ? null : Arrays.stream(columnVisibilityString.split(",")).map(s -> "0".equals(s) ? "W0" : ("1".equals(s) ? "W1" : s)).collect(Collectors.joining(","));
        this.sorting.setColumnSizes(columnSizes);
        this.sorting.save();
    }

    public String getTableName(Messages messages) {
        TableHandler handler = TableHandler.getHandler(this.sorting.getTable());
        if (handler != null) {
            String l10nKey = handler.getTableNameLocalizationKey();
            if (l10nKey.startsWith("GeneralMessages.")) {
                return BankingApiMessages.getString((String)l10nKey, (Object[])new Object[]{messages.lang().locale()});
            }
            return messages.at(l10nKey, new Object[0]);
        }
        return "";
    }

    public String getLockedColumnsJson(SortingHandler sortingHandler) {
        ObjectNode resultJson = Json.newObject();
        TableHandler handler = TableHandler.getHandler(this.sorting.getTable());
        if (handler != null) {
            for (ColumnHandler column : handler.getColumns()) {
                resultJson.put(String.valueOf(column.getColumnId()), column.isLocked(sortingHandler) ? 1 : 0);
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    public String getLocalizedColumnNamesJson(Messages messages) {
        ObjectNode resultJson = Json.newObject();
        TableHandler handler = TableHandler.getHandler(this.sorting.getTable());
        if (handler != null) {
            for (ColumnHandler column : handler.getColumns()) {
                resultJson.put(String.valueOf(column.getColumnId()), column.getLocalizedColumnHeader(messages));
            }
        }
        return Base64.getEncoder().encodeToString(Json.asciiStringify((JsonNode)resultJson).getBytes(StandardCharsets.US_ASCII));
    }

    static {
        TableHandler.registerTable(Sorting.Table.PMT_OPEN, "GeneralMessages.openPayments", routes.OpenPayments.index(false), new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(7, "GeneralMessages.iban"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)PreferenceConstants.PAYMENTS_SHOW_IBAN_COLUMN);
            }
        }, new ApiColumnHandler(3, "GeneralMessages.paymentType"), new ApiColumnHandler(9, "GeneralMessages.originator", false), new ApiColumnHandler(1, "GeneralMessages.recipient"), new ApiColumnHandler(2, "GeneralMessages.amount"), new ApiColumnHandler(4, "GeneralMessages.purpose"), new WebColumnHandler(8, "payment.creator"), new ApiColumnHandler(5, "GeneralMessages.executionDate"), new ApiColumnHandler(6, "GeneralMessages.folder", true, true));
        TableHandler.registerTable(Sorting.Table.PMT_SIGNED, "GeneralMessages.signedPayments", routes.SignedPayments.index(false), new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(8, "GeneralMessages.iban"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)PreferenceConstants.PAYMENTS_SHOW_IBAN_COLUMN);
            }
        }, new ApiColumnHandler(1, Utils.getBranding().getSignedPaymentStateLabel()), new ApiColumnHandler(2, "GeneralMessages.paymentTypeOrder"), new ApiColumnHandler(3, "GeneralMessages.refNumberPayment"), new ApiColumnHandler(10, "GeneralMessages.originator", false), new ApiColumnHandler(4, "GeneralMessages.recipient"), new ApiColumnHandler(5, "GeneralMessages.amount"), new ApiColumnHandler(6, "GeneralMessages.purpose"), new ApiColumnHandler(7, "GeneralMessages.executionDate"), new ApiColumnHandler(9, "GeneralMessages.folder", true, true));
        TableHandler.registerTable(Sorting.Table.PMT_TEMPLATE, "paymenttemplates", routes.PaymentTemplates.index(false), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.account"), new ApiColumnHandler(5, "GeneralMessages.iban"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)PreferenceConstants.PAYMENTS_SHOW_IBAN_COLUMN);
            }
        }, new ApiColumnHandler(2, "GeneralMessages.paymentType"), new ApiColumnHandler(7, "GeneralMessages.originator", false), new ApiColumnHandler(3, "GeneralMessages.recipient"), new ApiColumnHandler(4, "GeneralMessages.amount"), new ApiColumnHandler(6, "GeneralMessages.folder", true, true));
        TableHandler.registerTable(Sorting.Table.PMT_PERIODIC, "GeneralMessages.periodicPayments", routes.PeriodicPayments.index(false), new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(7, "GeneralMessages.iban"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)PreferenceConstants.PAYMENTS_SHOW_IBAN_COLUMN);
            }
        }, new ApiColumnHandler(1, "GeneralMessages.paymentType"), new ApiColumnHandler(11, "GeneralMessages.originator", false), new ApiColumnHandler(2, "GeneralMessages.recipient"), new ApiColumnHandler(3, "GeneralMessages.amount"), new ApiColumnHandler(4, "GeneralMessages.purpose"), new WebColumnHandler(9, "payment.creator"), new ApiColumnHandler(10, "GeneralMessages.executionInterval"), new ApiColumnHandler(5, "GeneralMessages.previousExecutionDate"), new ApiColumnHandler(6, "GeneralMessages.nextExecutionDate"), new ApiColumnHandler(8, "GeneralMessages.folder", true, true));
        TableHandler.registerTable(Sorting.Table.PMT_RECIPIENT, "recipients", routes.Recipients.index(false), new ApiColumnHandler(7, "GeneralMessages.state", true, true), new ApiColumnHandler(0, "GeneralMessages.displayName"), new ApiColumnHandler(1, "GeneralMessages.name"), new ApiColumnHandler(2, "GeneralMessages.paymentType"), new ApiColumnHandler(3, "GeneralMessages.accountNumberIban"), new ApiColumnHandler(4, "GeneralMessages.blzBic"), new ApiColumnHandler(5, "GeneralMessages.bank"), new ApiColumnHandler(8, "GeneralMessages.vopResult"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return !SendUtil.isBeforeVopDate() && SendUtil.userHasAnyVopBanks((User)sortingHandler.getSorting().getUser(), (boolean)false);
            }
        }, new ApiColumnHandler(6, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.PMT_MANDATES, "mandates", routes.Recipients.index(true), new ApiColumnHandler(7, "GeneralMessages.status", true, true), new ApiColumnHandler(0, "GeneralMessages.displayName"), new ApiColumnHandler(1, "GeneralMessages.payer"), new ApiColumnHandler(2, "GeneralMessages.mandateReference"), new ApiColumnHandler(3, "GeneralMessages.iban"), new ApiColumnHandler(4, "GeneralMessages.bic"), new ApiColumnHandler(5, "GeneralMessages.bank"), new ApiColumnHandler(6, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_STATEMENT, "GeneralMessages.accountOverview", routes.CmAccountOverview.index(), new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(1, "GeneralMessages.standardName"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_STANDARD_ACCOUNT_NAME);
            }
        }, new ApiColumnHandler(2, "GeneralMessages.nameInBankProfile"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_BANK_ACCOUNT_NAME);
            }
        }, new ApiColumnHandler(3, "GeneralMessages.accountOwner"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_ACCOUNT_OWNER);
            }
        }, new ApiColumnHandler(4, "GeneralMessages.statementDate"), new ApiColumnHandler(5, "GeneralMessages.bookingBalance"), new ApiColumnHandler(6, "GeneralMessages.creditLimit"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_LIMIT);
            }
        }, new ApiColumnHandler(7, "GeneralMessages.freeLiquidity"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_LIMIT);
            }
        }, new ApiColumnHandler(8, "GeneralMessages.valueBalance.today"), new ApiColumnHandler(9, "GeneralMessages.valueBalance.tomorrow"), new ApiColumnHandler(10, "GeneralMessages.valueBalance.dayAfterTomorrow"), new ApiColumnHandler(11, "GeneralMessages.openingBalance"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_DEBIT_SUMS);
            }
        }, new ApiColumnHandler(12, "GeneralMessages.sumDebits"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_DEBIT_SUMS);
            }
        }, new ApiColumnHandler(13, "GeneralMessages.sumCredits"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMNS_WITH_CREDIT_DEBIT_SUMS);
            }
        });
        TableHandler.registerTable(Sorting.Table.CM_BOOKING_TREE, "GeneralMessages.bookings", routes.Bookings.bookings(-1, null, null, null, null, null), new ApiColumnHandler(8, "GeneralMessages.account", true, true), new ApiColumnHandler(6, "GeneralMessages.booking"), new ApiColumnHandler(1, "GeneralMessages.value"), new ApiColumnHandler(7, "GeneralMessages.accountOwner"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_ACCOUNT_OWNER);
            }
        }, new ApiColumnHandler(2, "GeneralMessages.counterParty"), new ApiColumnHandler(0, "GeneralMessages.accountNumberIban", false), new ApiColumnHandler(3, "GeneralMessages.purpose"), new ApiColumnHandler(4, "GeneralMessages.amount"), new ApiColumnHandler(9, "GeneralMessages.furtherInformation", false), new ApiColumnHandler(5, "GeneralMessages.currentBalance", true, true));
        TableHandler.registerTable(Sorting.Table.DS_OPEN, "desoverview", routes.DesOverview.index(), new ApiColumnHandler(0, "GeneralMessages.status"), new ApiColumnHandler(1, "GeneralMessages.paymentTypeOrder"), new ApiColumnHandler(2, "GeneralMessages.submissionTime"), new ApiColumnHandler(3, "GeneralMessages.customerID"), new ApiColumnHandler(4, "GeneralMessages.submitter"), new ApiColumnHandler(5, "GeneralMessages.signatures"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.BANKING, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_SIGNATURES);
            }
        }, new ApiColumnHandler(6, "GeneralMessages.amount"), new ApiColumnHandler(7, "GeneralMessages.fileSize"), new ApiColumnHandler(8, "GeneralMessages.originator"), new ApiColumnHandler(9, "GeneralMessages.executionDate"), new ApiColumnHandler(10, "GeneralMessages.bankName", false));
        TableHandler.registerTable(Sorting.Table.DS_SIGNED, "deshistory.signed", routes.DesHistory.index(true), new ApiColumnHandler(0, "GeneralMessages.paymentTypeOrder"), new ApiColumnHandler(1, "SendUtil.state.origfilename"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, sortingHandler.getSorting().getUser());
                return store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_FILENAME);
            }

            @Override
            public boolean isLocked(SortingHandler sortingHandler) {
                boolean useAXWAYBranding = false;
                return !useAXWAYBranding;
            }
        }, new ApiColumnHandler(2, "GeneralMessages.submissionTime"), new ApiColumnHandler(3, "GeneralMessages.customerID"), new ApiColumnHandler(4, "GeneralMessages.submitter"), new ApiColumnHandler(5, "GeneralMessages.signatures"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, sortingHandler.getSorting().getUser());
                return store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_SIGNATURES);
            }
        }, new ApiColumnHandler(6, "GeneralMessages.amount"), new ApiColumnHandler(7, Utils.getBranding().getSignedPaymentStateLabel()), new ApiColumnHandler(8, "GeneralMessages.executionDate"));
        TableHandler.registerTable(Sorting.Table.DS_REJECTED, "deshistory.cancelled", routes.DesHistory.index(false), new ApiColumnHandler(0, "GeneralMessages.paymentTypeOrder"), new ApiColumnHandler(1, "SendUtil.state.origfilename"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, sortingHandler.getSorting().getUser());
                return store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_FILENAME);
            }

            @Override
            public boolean isLocked(SortingHandler sortingHandler) {
                boolean useAXWAYBranding = false;
                return !useAXWAYBranding;
            }
        }, new ApiColumnHandler(2, "GeneralMessages.submissionTime"), new ApiColumnHandler(3, "GeneralMessages.customerID"), new ApiColumnHandler(4, "GeneralMessages.submitter"), new ApiColumnHandler(5, "GeneralMessages.signatures"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                DatabasePreferenceStore store = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, sortingHandler.getSorting().getUser());
                return store.getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_SHOW_SIGNATURES);
            }
        }, new ApiColumnHandler(6, "GeneralMessages.amount"), new ApiColumnHandler(7, Utils.getBranding().getSignedPaymentStateLabel()), new ApiColumnHandler(8, "GeneralMessages.executionDate"));
        TableHandler.registerTable(Sorting.Table.FETCH, "GeneralMessages.fetchedFiles", routes.Fetched.index(), new WebColumnHandler(4, "fetched.postprocessing.error"), new ApiColumnHandler(0, "GeneralMessages.order"), new ApiColumnHandler(1, "GeneralMessages.fetchTime"), new ApiColumnHandler(2, "GeneralMessages.size"), new ApiColumnHandler(5, "GeneralMessages.user"), new ApiColumnHandler(3, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.SEND, "sent.title", routes.Sent.index(), new ApiColumnHandler(0, "GeneralMessages.paymentTypeOrder"), new ApiColumnHandler(1, "GeneralMessages.sendingTime"), new ApiColumnHandler(2, Utils.getBranding().getSignedPaymentStateLabel()), new ApiColumnHandler(3, "GeneralMessages.amount"), new ApiColumnHandler(4, "GeneralMessages.size"), new ApiColumnHandler(6, "GeneralMessages.submitter"), new ApiColumnHandler(5, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_DTI, "dti.title", routes.DtiView.dti(-1, null, null), new ApiColumnHandler(8, "GeneralMessages.account", true, true), new ApiColumnHandler(6, "GeneralMessages.booking"), new ApiColumnHandler(1, "GeneralMessages.value"), new ApiColumnHandler(7, "GeneralMessages.accountOwner"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_ACCOUNT_OWNER);
            }
        }, new ApiColumnHandler(2, "GeneralMessages.counterParty"), new ApiColumnHandler(0, "GeneralMessages.accountNumberIban", false), new ApiColumnHandler(3, "GeneralMessages.purpose"), new ApiColumnHandler(4, "GeneralMessages.amount"), new ApiColumnHandler(9, "GeneralMessages.furtherInformation", false), new ApiColumnHandler(5, "GeneralMessages.currentBalance", true, true));
        TableHandler.registerTable(Sorting.Table.CM_EXPORT, "GeneralMessages.automaticExports", routes.AutomaticExports.index(), new ApiColumnHandler(0, "GeneralMessages.activated"), new ApiColumnHandler(1, "GeneralMessages.name"), new ApiColumnHandler(2, "GeneralMessages.fileType"), new ApiColumnHandler(3, "GeneralMessages.conversion"), new ApiColumnHandler(4, "GeneralMessages.directory", Setup.AUTOMATIC_EXPORT_PATH == null || Setup.AUTOMATIC_EXPORT_PATH.isEmpty(), Setup.AUTOMATIC_EXPORT_PATH != null && !Setup.AUTOMATIC_EXPORT_PATH.isEmpty()), new ApiColumnHandler(5, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_PDF_STATEMENT, "pdfstatements.header", routes.PDFStatements.index(), new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(1, "GeneralMessages.type"), new ApiColumnHandler(2, "GeneralMessages.statementDate"), new ApiColumnHandler(3, "GeneralMessages.statementNumber"), new ApiColumnHandler(4, "GeneralMessages.fileName"));
        TableHandler.registerTable(Sorting.Table.AWZEL_ENTRY, "awv.notifications", routes.Awv.notifications(), new ApiColumnHandler(6, "GeneralMessages.status"), new ApiColumnHandler(0, "GeneralMessages.reportType"), new ApiColumnHandler(1, "GeneralMessages.category"), new ApiColumnHandler(2, "GeneralMessages.serviceCode"), new ApiColumnHandler(3, "GeneralMessages.purpose"), new ApiColumnHandler(4, "GeneralMessages.country"), new ApiColumnHandler(5, "GeneralMessages.amount"), new ApiColumnHandler(7, "GeneralMessages.account"), new ApiColumnHandler(8, "GeneralMessages.origin"), new ApiColumnHandler(9, "GeneralMessages.counterParty"));
        TableHandler.registerTable(Sorting.Table.TENANT, "tenants.title", routes.Tenants.index(), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(3, "GeneralMessages.customerID", Utils.getBranding().doTenantsWithBank(), !Utils.getBranding().doTenantsWithBank()), new WebColumnHandler(2, "tenants.userCount"), new WebColumnHandler(1, "tenants.maxUserCount", Utils.getBranding().showTenantMaxUserCount(), !Utils.getBranding().showTenantMaxUserCount()), new WebColumnHandler(4, "tenants.activeFetchPlans", Utils.getBranding().doTenantsWithBank(), !Utils.getBranding().doTenantsWithBank()));
        TableHandler.registerTable(Sorting.Table.BANK_LIST, "banks", routes.Banks.index(), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(5, "GeneralMessages.protocolVersion"), new ApiColumnHandler(1, "GeneralMessages.customerID"), new WebColumnHandler(2, "bank.yourUserId"){

            @Override
            public boolean isLocked(SortingHandler sortingHandler) {
                return sortingHandler.getSorting().getUser().isLocalUser();
            }

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return !sortingHandler.getSorting().getUser().isLocalUser();
            }
        }, new WebColumnHandler(3, "bank.yourState"){

            @Override
            public boolean isLocked(SortingHandler sortingHandler) {
                return sortingHandler.getSorting().getUser().isLocalUser();
            }

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return !sortingHandler.getSorting().getUser().isLocalUser();
            }
        }, new ApiColumnHandler(4, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.ACCOUNT, "GeneralMessages.accounts", routes.Accounts.index(), new ApiColumnHandler(6, "GeneralMessages.htdAccount"), new ApiColumnHandler(0, "GeneralMessages.bank"), new ApiColumnHandler(1, "GeneralMessages.name"), new ApiColumnHandler(2, "GeneralMessages.description"), new ApiColumnHandler(3, "GeneralMessages.accountNumberIban"), new ApiColumnHandler(4, "GeneralMessages.bankCodeBic"), new ApiColumnHandler(5, "GeneralMessages.currency"), new ApiColumnHandler(7, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.USERS, "GeneralMessages.userAdministration", routes.Users.index(), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.administrator"), new ApiColumnHandler(2, "GeneralMessages.bankAccess"), new WebColumnHandler(5, Branding.getBranding().usersTable2FAColumnHasButtons() ? "yubikeys" : "yubikeys.tableheader"), new WebColumnHandler(3, "users.lastlogin"), new WebColumnHandler(4, "users.passworderrors.title"));
        TableHandler.registerTable(Sorting.Table.SCHEDULER, "fetchschedule.title", routes.FetchSchedule.index(), new WebColumnHandler(0, "fetchschedule.fetchType"), new ApiColumnHandler(6, "GeneralMessages.customerID", Utils.getBranding().showCustomerColumnInFetchSchedulesTables(), !Utils.getBranding().showCustomerColumnInFetchSchedulesTables()), new WebColumnHandler(1, "fetchschedule.fetchInterval"), new WebColumnHandler(2, "fetchschedule.schedule"), new ApiColumnHandler(3, "GeneralMessages.user"), new WebColumnHandler(4, "fetchschedule.lastFetch"), new WebColumnHandler(5, "fetchschedule.nextFetch"), new ApiColumnHandler(7, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_EXPORT_FILES, "autexports.files.header", routes.AutomaticExports.files(), new ApiColumnHandler(0, "GeneralMessages.fileName"), new ApiColumnHandler(1, "GeneralMessages.directory", Setup.AUTOMATIC_EXPORT_PATH == null || Setup.AUTOMATIC_EXPORT_PATH.isEmpty(), Setup.AUTOMATIC_EXPORT_PATH != null && !Setup.AUTOMATIC_EXPORT_PATH.isEmpty()), new ApiColumnHandler(2, "GeneralMessages.creationTime"), new ApiColumnHandler(3, "GeneralMessages.fileSize"), new ApiColumnHandler(4, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.TENANT_USERS, "tenants.edit", null, new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.bankAccess", !Utils.getBranding().doTenantsWithBank(), Utils.getBranding().doTenantsWithBank()), new WebColumnHandler(5, "yubikeys", Utils.getBranding().createUserWithWebAuthn(), !Utils.getBranding().createUserWithWebAuthn()), new ApiColumnHandler(6, "GeneralMessages.userID", Utils.getBranding().doTenantsWithBank(), !Utils.getBranding().doTenantsWithBank()), new WebColumnHandler(3, "users.lastlogin", Utils.getBranding().doTenantsWithBank(), !Utils.getBranding().doTenantsWithBank()), new WebColumnHandler(4, "users.passworderrors.title", Utils.getBranding().doTenantsWithBank(), !Utils.getBranding().doTenantsWithBank()), new WebColumnHandler(7, "tenants.users.managingUser"), new WebColumnHandler(2, "tenants.users.othertenants", !Utils.getBranding().doTenantsWithBank(), Utils.getBranding().doTenantsWithBank()));
        TableHandler.registerTable(Sorting.Table.START_PAGE_USERS, "users.overview", routes.Application.index(), new WebColumnHandler(0, "bank.customerName"), new ApiColumnHandler(1, "GeneralMessages.customerID"), new ApiColumnHandler(2, "GeneralMessages.userID"), new ApiColumnHandler(3, "GeneralMessages.status"), new WebColumnHandler(4, "users.lastlogin"));
        TableHandler.registerTable(Sorting.Table.PMT_ORIGINATOR, "originators", routes.Originators.index(), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.paymentType"), new WebColumnHandler(3, "originators.defaultaccount"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, sortingHandler.getSorting().getUser()).getString((DatabasePreferenceConstant)PreferenceConstants.INITIALIZATION_OF_ACC_AND_ORIG).equals(PreferenceConstants.InitializationOfAccAndOrig.WITH_FIXED_VALUES.name());
            }
        }, new ApiColumnHandler(2, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_CONVERTER, "conversions.header", routes.Conversions.index(), new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.type"), new ApiColumnHandler(2, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.CM_VALUE_BALANCES, "balances.title", null, new ApiColumnHandler(0, "GeneralMessages.date"), new ApiColumnHandler(1, "GeneralMessages.valueBalance"), new ApiColumnHandler(2, "GeneralMessages.valueBalanceWithAdvice"), new ApiColumnHandler(3, "GeneralMessages.bookingBalance"));
        TableHandler.registerTable(Sorting.Table.NOTIFICATION, "GeneralMessages.notifications", routes.Notifications.index(), new ApiColumnHandler(0, "GeneralMessages.notificationType"), new WebColumnHandler(2, "notifications.nbOfRjct"), new ApiColumnHandler(1, "GeneralMessages.creationTime"));
        TableHandler.registerTable(Sorting.Table.NOTIFICATION_TRX, "GeneralMessages.notifications", null, new ApiColumnHandler(0, "GeneralMessages.name"), new ApiColumnHandler(1, "GeneralMessages.account"), new ApiColumnHandler(2, "GeneralMessages.amount"), new ApiColumnHandler(3, "GeneralMessages.purpose"), new ApiColumnHandler(6, "GeneralMessages.reference"), new ApiColumnHandler(4, "GeneralMessages.statusCode"), new WebColumnHandler(5, "notifications.reasonCodes"));
        TableHandler.registerTable(Sorting.Table.AWZEL_PARTICIPANT, "awv.participants.title", routes.Awv.participants(), new ApiColumnHandler(0, "GeneralMessages.company"), new ApiColumnHandler(1, "GeneralMessages.contactPerson"), new ApiColumnHandler(2, "GeneralMessages.departement"), new ApiColumnHandler(3, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.YUBIKEYS, "yubikeys.header", null, new ApiColumnHandler(0, "GeneralMessages.type"), new WebColumnHandler(1, "yubikeys.publicId"), new ApiColumnHandler(3, "GeneralMessages.description"), new ApiColumnHandler(2, "GeneralMessages.addedOn"));
        TableHandler.registerTable(Sorting.Table.DIRECTORY_SCANNER, "folders.title", routes.Folders.index(), new ApiColumnHandler(0, "GeneralMessages.bank"), new ApiColumnHandler(1, "GeneralMessages.orderType"), new ApiColumnHandler(2, "GeneralMessages.directory"), new ApiColumnHandler(3, "GeneralMessages.tenant", true, true));
        TableHandler.registerTable(Sorting.Table.DIRECTORY_SCANNER_FILES, "folders.files.title", routes.Folders.listFiles(), new ApiColumnHandler(0, "GeneralMessages.orderType"), new ApiColumnHandler(1, "GeneralMessages.file"), new ApiColumnHandler(2, "GeneralMessages.creationDate"), new ApiColumnHandler(3, "GeneralMessages.fileSize"));
        TableHandler.registerTable(Sorting.Table.CM_VALUE_BALANCES2, "balancelists.title", null, new ApiColumnHandler(0, "GeneralMessages.account"), new ApiColumnHandler(1, "GeneralMessages.standardName"){

            @Override
            public boolean isVisibleByDefault(SortingHandler sortingHandler) {
                return new DatabasePreferenceStore(Preference.ApplicationId.CM, sortingHandler.getSorting().getUser()).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.DISPLAY_COLUMN_STANDARD_ACCOUNT_NAME);
            }
        });
        TableHandler.registerTable(Sorting.Table.LOGS, "logs.title", routes.Logs.index(), new ApiColumnHandler(0, "GeneralMessages.logs.timestamp"), new ApiColumnHandler(1, "GeneralMessages.logs.actor"), new ApiColumnHandler(2, "GeneralMessages.logs.message"));
    }

    public static class TableHandler {
        private static final Map<Sorting.Table, TableHandler> HANDLERS = new HashMap<Sorting.Table, TableHandler>();
        private final Sorting.Table table;
        private final String tableNameLocalizationKey;
        private final Call redirectRoute;
        private final ColumnHandler[] columns;
        private final int[] defaultColumnOrder;

        private TableHandler(Sorting.Table table, String tableNameLocalizationKey, Call redirectRoute, ColumnHandler ... columns) {
            this.table = table;
            this.tableNameLocalizationKey = tableNameLocalizationKey;
            this.redirectRoute = redirectRoute;
            this.columns = columns;
            int[] columnOrder = new int[columns.length];
            for (int i = 0; i < columns.length; ++i) {
                columnOrder[i] = columns[i].getColumnId();
            }
            this.defaultColumnOrder = columnOrder;
        }

        public static TableHandler getHandler(Sorting.Table forTable) {
            return HANDLERS.get(forTable);
        }

        public static void registerTable(Sorting.Table table, String tableNameLocalizationKey, Call redirectRoute, ColumnHandler ... columns) {
            if (TableHandler.getHandler(table) != null) {
                throw new RuntimeException("Duplicate TableHandler registration for tableId '" + String.valueOf(table) + "'!");
            }
            TableHandler newHandler = new TableHandler(table, tableNameLocalizationKey, redirectRoute, columns);
            HANDLERS.put(table, newHandler);
        }

        public Sorting.Table getTable() {
            return this.table;
        }

        public Call getRedirectRoute() {
            return this.redirectRoute;
        }

        public ColumnHandler[] getColumns() {
            return this.columns;
        }

        public int[] getDefaultColumnOrder() {
            return this.defaultColumnOrder;
        }

        public String getTableNameLocalizationKey() {
            return this.tableNameLocalizationKey;
        }
    }

    public static abstract class ColumnHandler {
        private final int columnId;
        private final boolean visibleByDefault;
        private final boolean isLocked;

        protected ColumnHandler(int columnId, boolean visibleByDefault, boolean isLocked) {
            this.columnId = columnId;
            this.visibleByDefault = visibleByDefault;
            this.isLocked = isLocked;
        }

        public int getColumnId() {
            return this.columnId;
        }

        public abstract String getLocalizedColumnHeader(Messages var1);

        public boolean isVisibleByDefault(SortingHandler sortingHandler) {
            return this.visibleByDefault;
        }

        public boolean isLocked(SortingHandler sortingHandler) {
            return this.isLocked;
        }
    }

    public static class ApiColumnHandler
    extends ColumnHandler {
        private final String messageKey;

        public ApiColumnHandler(int columnId, String messageKey) {
            this(columnId, messageKey, true, false);
        }

        public ApiColumnHandler(int columnId, String messageKey, boolean visibleByDefault) {
            this(columnId, messageKey, visibleByDefault, false);
        }

        public ApiColumnHandler(int columnId, String messageKey, boolean visibleByDefault, boolean isLocked) {
            super(columnId, visibleByDefault, isLocked);
            this.messageKey = messageKey;
        }

        @Override
        public String getLocalizedColumnHeader(Messages messages) {
            return BankingApiMessages.getString((Locale)messages.lang().locale(), (String)this.messageKey, (Object[])new Object[0]);
        }
    }

    public static class WebColumnHandler
    extends ColumnHandler {
        private final String messageKey;

        public WebColumnHandler(int columnId, String messageKey) {
            this(columnId, messageKey, true, false);
        }

        public WebColumnHandler(int columnId, String messageKey, boolean visibleByDefault, boolean isLocked) {
            super(columnId, visibleByDefault, isLocked);
            this.messageKey = messageKey;
        }

        @Override
        public String getLocalizedColumnHeader(Messages messages) {
            return messages.at(this.messageKey, new Object[0]);
        }
    }
}

