/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.sepa.api.SepaNotificationPreScheduler;
import de.businesslogics.banking.transfer.api.BaseNotificationProcessing;
import de.businesslogics.banking.transfer.api.Camt029Processing;
import de.businesslogics.banking.transfer.api.FetchScheduler;
import de.businesslogics.banking.transfer.api.NotificationSettings;
import de.businesslogics.banking.transfer.api.Processing;
import de.businesslogics.banking.transfer.api.SEPACreditNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPADebitNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPAForeignNotificationProcessing;
import de.businesslogics.banking.transfer.api.SEPAInstantNotificationProcessing;
import de.businesslogics.banking.transfer.api.VOPNotificationProcessing;
import de.businesslogics.util.BLLogger;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class SepaNotificationPostScheduler
implements Processing {
    public static ScheduledFuture<List<Fetch>> fetchNotificationsNow(EbicsWorker worker, BankUser bankUser) {
        Scheduler s = new Scheduler();
        s.setBankUser(bankUser);
        s.setOrderOrFileType(SepaNotificationPreScheduler.class.getName());
        return FetchScheduler.fetchNow((Scheduler)s, (EbicsWorker)worker);
    }

    public void doPostProcessing(Fetch item) throws Exception {
        EncryptData encryptData;
        BLLogger blLogger = BLLoggerPlay.getLogger();
        BaseNotificationProcessing processing = this.getNotificationProcessing(item, blLogger, encryptData = EncryptData.getInstance());
        if (processing != null) {
            processing.doPostProcessing(item);
        }
    }

    private BaseNotificationProcessing getNotificationProcessing(Fetch fetch, BLLogger blLogger, EncryptData encryptData) {
        NotificationSettings settings;
        String fetchType = fetch.getFetchType();
        if (fetchType.equals((settings = NotificationSettings.getForBank((BankSettings)fetch.getBank())).getFetchTypeForCreditNotifications())) {
            return new SEPACreditNotificationProcessing(blLogger, encryptData);
        }
        if (fetchType.equals(settings.getFetchTypeForDebitNotifications())) {
            return new SEPADebitNotificationProcessing(blLogger, encryptData);
        }
        if (fetchType.equals(settings.getFetchTypeForInstantNotifications())) {
            return new SEPAInstantNotificationProcessing(blLogger, encryptData);
        }
        if (fetchType.equals(settings.getFetchTypeForCallbackNotifications())) {
            return new Camt029Processing(blLogger, encryptData);
        }
        if (fetchType.equals(settings.getFetchTypeForForeignNotifications())) {
            return new SEPAForeignNotificationProcessing(blLogger, encryptData);
        }
        if (fetchType.equals(settings.getFetchTypeForVopNotifications())) {
            return new VOPNotificationProcessing(blLogger, encryptData);
        }
        return null;
    }
}

