/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import controllers.util.BLLoggerPlay;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.InvalidPasswordException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import play.Application;
import play.Environment;
import play.server.ApplicationProvider;
import play.server.SSLEngineProvider;

public final class SSLEngineProviderImpl
implements SSLEngineProvider {
    private final ApplicationProvider applicationProvider;
    private final Environment environment;
    private SSLContext sslContext;

    public SSLEngineProviderImpl(ApplicationProvider applicationProvider) {
        this.applicationProvider = applicationProvider;
        this.environment = applicationProvider.get().isPresent() ? ((Application)applicationProvider.get().get()).environment() : null;
    }

    public SSLEngineProviderImpl(ApplicationProvider applicationProvider, Environment environment) {
        this.applicationProvider = applicationProvider;
        this.environment = environment;
    }

    public SSLEngine createSSLEngine() {
        if (this.sslContext == null) {
            try {
                BLLoggerPlay.info("Using " + this.getClass().getName() + " for SSL handling.");
                SSLConfiguration sslConfig = this.getSslConfig();
                KeyManagerFactory factory = this.buildKeyManagerFactory(sslConfig);
                this.sslContext = SSLContext.getInstance("TLS");
                this.sslContext.init(factory.getKeyManagers(), null, null);
            }
            catch (Throwable t) {
                BLLoggerPlay.error("Failed to load SSL settings!", t);
                throw new RuntimeException(t);
            }
        }
        return this.sslContext.createSSLEngine();
    }

    public SSLContext sslContext() {
        if (this.sslContext == null) {
            this.createSSLEngine();
        }
        return this.sslContext;
    }

    private SSLConfiguration getSslConfig() throws IOException, GeneralSecurityException {
        File configIni = this.environment.getFile("config.ini");
        SSLConfiguration result = new SSLConfiguration();
        if (configIni.isFile()) {
            result.loadFromConfigFile(configIni);
        }
        if (result.isNotComplete()) {
            BLLoggerPlay.info("Did not find SSL parameters in config.ini loading from production.conf.");
            result.loadFromPlayConfig();
        }
        if (result.isNotComplete()) {
            BLLoggerPlay.info("No SSL parameters found, using the dummy certificate...");
            File keyStoreFile = new File(new File(configIni.getAbsoluteFile().getParentFile(), "conf"), "bl-default.keystore");
            result.setKeystorePath(keyStoreFile.getAbsolutePath());
            result.setPassphrase(new char[]{'g', 'e', 'h', 'e', 'i', 'm'});
        }
        result.getPassphrase();
        result.storeIfNeeded(configIni);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManagerFactory buildKeyManagerFactory(SSLConfiguration sslConfig) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(sslConfig.getKeystoreType());
        FileInputStream keyStoreInputStream = null;
        try {
            keyStoreInputStream = new FileInputStream(sslConfig.getKeystorePath());
            keyStore.load(keyStoreInputStream, sslConfig.getPassphrase());
        }
        catch (Throwable throwable) {
            SystemUtils.close(keyStoreInputStream);
            throw throwable;
        }
        SystemUtils.close((AutoCloseable)keyStoreInputStream);
        KeyManagerFactory result = KeyManagerFactory.getInstance(sslConfig.getAlgorithm());
        result.init(keyStore, sslConfig.getPassphrase());
        return result;
    }

    private final class SSLConfiguration {
        private final Properties configProps = new Properties();
        private char[] passphrase;
        private boolean needsUpdate;

        private SSLConfiguration() {
        }

        void loadFromConfigFile(File file2) throws IOException {
            FileInputStream configInputStream = null;
            try {
                configInputStream = new FileInputStream(file2);
                this.configProps.load(configInputStream);
            }
            catch (Throwable throwable) {
                SystemUtils.close(configInputStream);
                throw throwable;
            }
            SystemUtils.close((AutoCloseable)configInputStream);
        }

        void loadFromPlayConfig() {
            if (!SSLEngineProviderImpl.this.applicationProvider.get().isPresent()) {
                return;
            }
            try {
                Config config = ((Application)SSLEngineProviderImpl.this.applicationProvider.get().get()).config().getConfig("play.server.https.keyStore");
                String string = config.getString("path");
                if (string != null && string.length() > 0) {
                    this.configProps.setProperty("sslKeystorePath", string);
                    this.needsUpdate = true;
                }
                if ((string = config.getString("type")) != null && string.length() > 0) {
                    this.configProps.setProperty("sslKeystoreType", string);
                    this.needsUpdate = true;
                }
                if ((string = config.getString("password")) != null) {
                    this.configProps.setProperty("sslKeystorePassphrase", string);
                    this.needsUpdate = true;
                }
                if ((string = config.getString("algorithm")) != null && string.length() > 0) {
                    this.configProps.setProperty("sslKeystoreAlgorithm", string);
                    this.needsUpdate = true;
                }
            }
            catch (ConfigException ignored) {
                BLLoggerPlay.getLogger().logInfo("No SSL settings found in production.conf");
            }
        }

        String getKeystorePath() {
            return this.configProps.getProperty("sslKeystorePath");
        }

        void setKeystorePath(String path) {
            this.configProps.setProperty("sslKeystorePath", path);
            this.needsUpdate = true;
        }

        String getKeystoreType() {
            return this.configProps.getProperty("sslKeystoreType", "JKS");
        }

        char[] getPassphrase() throws InvalidPasswordException, IOException {
            if (this.passphrase == null) {
                char[] password2 = new char[]{'L', 'v', 'k', '7', 'B', '#', '[', '.', 'm', 'W', 'z', '2', ']', '4', 'H', 'N', 'z', 'L', '\\', 'V'};
                String passphraseString = this.configProps.getProperty("sslKeystorePassphrase");
                if (passphraseString == null) {
                    passphraseString = this.configProps.getProperty("sslKeystorePassphrase.enc");
                    if (passphraseString != null && passphraseString.length() > 0) {
                        passphraseString = new String(de.businesslogics.zkasecurity.KeyStore.decryptData((byte[])HexTool.fromHex((String)passphraseString), (char[])password2), StandardCharsets.UTF_8);
                        this.passphrase = passphraseString.toCharArray();
                    }
                } else {
                    this.configProps.setProperty("sslKeystorePassphrase.enc", HexTool.toHex((byte[])de.businesslogics.zkasecurity.KeyStore.encryptData((byte[])passphraseString.getBytes(StandardCharsets.UTF_8), (char[])password2)));
                    this.configProps.remove("sslKeystorePassphrase");
                    this.passphrase = passphraseString.toCharArray();
                    this.needsUpdate = true;
                }
            }
            return this.passphrase;
        }

        void setPassphrase(char[] passphraseCharacters) throws InvalidPasswordException, IOException {
            this.passphrase = null;
            this.configProps.setProperty("sslKeystorePassphrase", new String(passphraseCharacters));
            this.getPassphrase();
            this.needsUpdate = true;
        }

        String getAlgorithm() {
            return this.configProps.getProperty("sslKeystoreAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
        }

        boolean isNotComplete() throws InvalidPasswordException, IOException {
            String keyStorePath = this.getKeystorePath();
            char[] passphrase = this.getPassphrase();
            return keyStorePath == null || keyStorePath.length() <= 0 || passphrase == null;
        }

        void storeIfNeeded(File file2) throws IOException {
            block2: {
                if (!this.needsUpdate) break block2;
                FileOutputStream configOutputStream = null;
                try {
                    configOutputStream = new FileOutputStream(file2);
                    this.configProps.store(configOutputStream, null);
                }
                catch (Throwable throwable) {
                    SystemUtils.close(configOutputStream);
                    throw throwable;
                }
                SystemUtils.close((AutoCloseable)configOutputStream);
                this.needsUpdate = false;
            }
        }
    }
}

