/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import controllers.util.SchedulerThrowableHandler;
import de.businesslogics.banking.api.Logger;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.OpenPayment;
import de.businesslogics.banking.database.vo.PaymentProperties;
import de.businesslogics.banking.database.vo.PeriodicPayment;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.payments.api.PeriodicPaymentExecutionRunner;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import models.payments.PaymentException;
import models.payments.PaymentHandler;

public final class PeriodicPaymentExecutionRunnerImpl
extends PeriodicPaymentExecutionRunner<PaymentHandler<?>> {
    private final SchedulerThrowableHandler catcher;

    public PeriodicPaymentExecutionRunnerImpl(User user, SchedulerThrowableHandler catcher) {
        super(user);
        this.catcher = catcher;
    }

    protected PaymentHandler<?> getPayment(PeriodicPayment periodicPayment) {
        try {
            return PaymentHandler.getHandler(periodicPayment.getPmtType(), periodicPayment.getPaymentData());
        }
        catch (PaymentException e) {
            this.catcher.handleThrowable(e);
            BLLoggerPlay.error("Failed to load payment handler for periodic payment!", e);
            return null;
        }
    }

    protected void setExecutionDate(PaymentHandler<?> payment, Date executionDate, PaymentProperties paymentProperties) {
        BankSettings bank = paymentProperties == null ? null : paymentProperties.getBank();
        payment.setEarliestExecutionDate(executionDate, bank, paymentProperties);
    }

    protected void updatePurpose(PaymentHandler<?> payment, List<String> purpose) {
        payment.setPurpose(purpose);
    }

    protected void createOpenPayment(PaymentHandler<?> payment, PeriodicPayment periodicPayment) {
        OpenPayment openPayment = new OpenPayment();
        openPayment.setBank(periodicPayment.getBank());
        openPayment.setAccount(periodicPayment.getAccount());
        openPayment.setOrderType(periodicPayment.getOrderType());
        openPayment.setFileType(periodicPayment.getFileTypeOrBTF());
        openPayment.setPmtType(periodicPayment.getPmtType());
        openPayment.setCredit(periodicPayment.isCredit());
        openPayment.setUrgent(periodicPayment.isUrgent().booleanValue());
        openPayment.setRecipient(periodicPayment.getRecipient());
        openPayment.setAmount(periodicPayment.getAmount());
        openPayment.setAmountCurrency(periodicPayment.getAmountCurrency());
        openPayment.setPurpose(payment.getPurpose());
        openPayment.setOriginator(payment.getOriginator());
        if (periodicPayment.getFolder() != null && periodicPayment.getFolder().getTenant().equals(periodicPayment.getAccount().getBank().getTenant())) {
            openPayment.setFolder(periodicPayment.getFolder());
        }
        openPayment.setSalaryPayment(periodicPayment.getSalaryPayment());
        if (payment.getExecutionDate() != null) {
            openPayment.setExecutionDate(new Timestamp(payment.getExecutionDate().getTime()));
        }
        try {
            openPayment.setPaymentData(payment.buildPaymentData(periodicPayment.getBank()));
            openPayment.save(periodicPayment.getCreatedUser(), false);
            if (this.user != null) {
                Logger.logOpenPaymentCreated((User)this.user, (OpenPayment)openPayment);
            }
        }
        catch (Exception e) {
            BLLoggerPlay.error("Failed to build the payment data for a new open payment generated from periodic!", e);
            Logger.logErrorCreatingOpenFromPeriodicPayment((User)this.user, (PeriodicPayment)periodicPayment, (String)e.getMessage());
            this.catcher.handleThrowable(e);
        }
    }

    protected PaymentHandler<?> updatePaymentAfterGeneration(PaymentHandler<?> payment, PeriodicPayment periodicPayment) {
        if (payment.updatePaymentAfterGeneration()) {
            try {
                payment.updatePeriodicPayment(periodicPayment);
            }
            catch (Exception e) {
                BLLoggerPlay.error("Failed to build the payment data for a new open payment generated from periodic!", e);
                Logger.logErrorCreatingOpenFromPeriodicPayment((User)this.user, (PeriodicPayment)periodicPayment, (String)e.getMessage());
                this.catcher.handleThrowable(e);
            }
        }
        return payment;
    }

    protected void finished(int countGeneratedPayments) {
    }
}

