/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import de.businesslogics.banking.api.AbstractPermissionChecker;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.Preference;
import java.util.Locale;
import models.payments.PaymentUtils;
import play.i18n.Messages;

public class OrderPermissionChecker
extends AbstractPermissionChecker {
    protected String errorMessage = "";
    protected Locale locale = null;

    public OrderPermissionChecker(Locale locale) {
        this.locale = locale;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageWithOrderDescription(DsOpenOrder order, Messages messages) {
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            return "";
        }
        String orderDescription = PaymentUtils.getOrderDescription(order.getBankUser().getBank(), order.getPmtType(), order.getOrderId(), order.getFileType(), messages);
        return orderDescription + ": " + this.errorMessage;
    }

    public String getErrorMessageWithOrderDescription(DsOrderDetails order, Messages messages) {
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            return "";
        }
        String orderDescription = PaymentUtils.getOrderDescription(order.getBank(), order.getPmtType(), order.getOrderId(), order.getFileType(), messages);
        return orderDescription + ": " + this.errorMessage;
    }

    protected boolean checkAccountPermissions() {
        Preference p = Preference.getPreference((Preference.ApplicationId)Preference.ApplicationId.PAYMENTS, (String)"displayOnlyPaymentsWithPermission");
        if (p != null) {
            return Boolean.parseBoolean(p.getValue());
        }
        return true;
    }

    protected void noAccountPermission(int numberOfAccounts) {
        this.errorMessage = numberOfAccounts > 1 ? de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForAccounts", (Object[])new Object[0]) : de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForAccount", (Object[])new Object[0]);
    }

    protected void noBankPermission() {
        this.errorMessage = de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForBank", (Object[])new Object[0]);
    }

    protected void noAccountPermissionInOrder() {
        this.errorMessage = de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForAccountsInOrders", (Object[])new Object[0]);
    }

    protected void noBankPermissionInOrder(int numberOfBankAccounts) {
        this.errorMessage = numberOfBankAccounts > 1 ? de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForBanksInOrders", (Object[])new Object[0]) : de.businesslogics.banking.Messages.getString((Locale)this.locale, (String)"PermissionChecker.message.noPermissionForBankInOrders", (Object[])new Object[0]);
    }
}

