/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.Setup;
import controllers.branding.Branding;
import controllers.routes;
import controllers.util.BLLoggerPlay;
import controllers.util.SortingHandler;
import de.businesslogics.banking.api.BankUtils;
import de.businesslogics.banking.api.BankingApiMessages;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.OrderTypeUtil;
import de.businesslogics.banking.api.PaymentTypeUtil;
import de.businesslogics.banking.api.SendParameters;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.awzel.api.ServiceCodeProvider;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.AwzelEntry;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.OrderType;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Sorting;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.format.FetchOrderTypes;
import de.businesslogics.format.SendOrderTypes;
import de.businesslogics.io.Streams;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.persistence.PersistenceException;
import play.data.Form;
import play.data.validation.ValidationError;
import play.i18n.Messages;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Result;
import play.mvc.Results;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import views.Utils;

public final class GeneralUtils {
    public static Properties getSortingProperties(Sorting sorting) {
        Properties result = new Properties();
        if (sorting != null && sorting.getAdditionalInformation() != null) {
            try {
                result.load(new StringReader(sorting.getAdditionalInformation()));
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to load properties from sorting additional info for open payments table!", e);
            }
        }
        return result;
    }

    public static void storeSortingProperties(Properties properties, Sorting sorting) {
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            sorting.setAdditionalInformation(writer.toString());
            sorting.save();
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to store properties to sorting additional info for open payments table!", e);
        }
    }

    public static boolean isSuperAdmin(User user) {
        if (user == null) {
            return false;
        }
        if (!Setup.SUPER_ADMINS.isEmpty()) {
            return user.isAdmin() && Setup.SUPER_ADMINS.contains(user.getName());
        }
        return user.isAdmin();
    }

    public static boolean isIdInSelection(Integer id, String idsList) {
        if (id != null && idsList != null && !idsList.isEmpty()) {
            String toLookupString = String.valueOf(id);
            for (String idString : idsList.split(",")) {
                if (!toLookupString.equals(idString)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Integer> getSelectionIds(String selectedIds) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (selectedIds != null && !selectedIds.isEmpty()) {
            for (String idString : selectedIds.split(",")) {
                try {
                    result.add(Integer.parseInt(idString.trim()));
                }
                catch (NumberFormatException e) {
                    BLLoggerPlay.error("Failed to convert selected ID to integer: " + idString, e);
                }
            }
        }
        return result;
    }

    public static Integer getSingleSelectionId(String selectedIds) {
        try {
            return Integer.parseInt(selectedIds.trim());
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to convert selected ID to integer: " + selectedIds, e);
            return -1;
        }
    }

    public static Seq<Tuple2<String, String>> getBanks(String username, boolean includeEmpty) {
        return GeneralUtils.getBanks(username, includeEmpty, false, false, false, true, false);
    }

    public static Seq<Tuple2<String, String>> getAllBanks(String username, boolean includeEmpty) {
        return GeneralUtils.getBanks(username, includeEmpty, false, false, false, false, false);
    }

    public static Seq<Tuple2<String, String>> getReadyBanks(String username, boolean includeEmpty, boolean h005OrNewerOnly) {
        return GeneralUtils.getBanks(username, includeEmpty, true, false, false, true, h005OrNewerOnly);
    }

    public static Seq<Tuple2<String, String>> getActiveBanks(String username, boolean includeEmpty) {
        return GeneralUtils.getBanks(username, includeEmpty, false, true, false, true, false);
    }

    public static Seq<Tuple2<String, String>> getKeyBanks(String username, boolean includeEmpty) {
        return GeneralUtils.getBanks(username, includeEmpty, false, false, true, true, false);
    }

    private static Seq<Tuple2<String, String>> getBanks(String username, boolean includeEmpty, boolean onlyReady, boolean onlyActivated, Boolean onlyWithKeys, Boolean checkPermission, boolean h005OrNewerOnly) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (includeEmpty) {
            result.add(Scala.Tuple((Object)"-1", (Object)""));
        }
        User user = User.getUser((String)username);
        List<BankSettings> banksToAdd = GeneralUtils.getBanksForUser(user, onlyReady, onlyActivated, onlyWithKeys, checkPermission, h005OrNewerOnly);
        for (BankSettings bank : banksToAdd) {
            Object bankName = bank.getDisplayName();
            if (user.getTenants().size() > 1) {
                bankName = (String)bankName + " (" + bank.getTenant().getName() + ")";
            }
            result.add(new Tuple2((Object)bank.getBankId().toString(), (Object)Utils.addZWNJ((String)bankName)));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    public static List<BankSettings> getBanksForUser(User user, boolean onlyReady, Boolean onlyActivated, Boolean onlyWithKeys, Boolean checkPermission, boolean h005OrNewerOnly) {
        List<Object> banks2 = new ArrayList<BankSettings>();
        if (user == null) {
            return banks2;
        }
        List visibleTenants = user.getVisibleTenants();
        List<Object> bankUsers = user.isAdminOrTenantAdmin() ? BankSettings.findBanksForTenants((List)visibleTenants).stream().map(b -> BankUser.findBankUser((BankSettings)b, (User)user)).collect(Collectors.toList()) : BankUser.findBanksForUser((User)user);
        if (h005OrNewerOnly) {
            bankUsers = bankUsers.stream().filter(Objects::nonNull).filter(bu -> BankUtils.isProtocolH005OrNewer((String)bu.getBank().getProtocolVersion())).toList();
        }
        if (checkPermission.booleanValue()) {
            for (BankUser bankUser : bankUsers) {
                if (bankUser == null || onlyActivated.booleanValue() && BankUtils.isDeactivated((BankUser)bankUser) || onlyReady && !BankUtils.isReady((BankUser)bankUser) || onlyWithKeys.booleanValue() && (bankUser.getEncrKey() == null || bankUser.getAuthKey() == null)) continue;
                banks2.add(bankUser.getBank());
            }
        } else {
            banks2 = BankSettings.findBanksForTenants((List)visibleTenants);
        }
        return banks2;
    }

    public static BankSettings getBank(String id) {
        try {
            return (BankSettings)DB.find(BankSettings.class, (Object)Integer.valueOf(id));
        }
        catch (NumberFormatException e) {
            BLLoggerPlay.error("Failed to parse bank ID as a string: " + id);
            return null;
        }
    }

    public static Seq<Tuple2<String, String>> getAwvServiceCode(AwzelEntry.EntryType entryType, int category, Locale locale) {
        ServiceCodeProvider provider = new ServiceCodeProvider(entryType, BLLoggerPlay.getLogger(), locale);
        provider.setCategory(category);
        List prop = provider.getProposals("");
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        StringBuilder description = new StringBuilder();
        for (ServiceCodeProvider.ServiceCodeDetails code : prop) {
            description.setLength(0);
            String serviceCode = code.getServiceCode();
            String des = code.getDescription();
            if (des == null) {
                des = code.getLabel();
                description.append(des);
            } else {
                description.append(code.getServiceCode()).append(" - ").append(des);
            }
            result.add(Scala.Tuple((Object)serviceCode, (Object)description.toString()));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getSendTypes(BankSettings bank, String userName, Locale locale) {
        BankUser bankUser = BankUser.findBankUser((BankSettings)bank, (User)User.getUser((String)userName));
        if (bankUser == null) {
            return GeneralUtils.getSendOrderTypes(locale);
        }
        List orderTypes = OrderTypeUtil.findOrderTypesForSendDialog((BankUser)bankUser);
        if (orderTypes.isEmpty()) {
            return GeneralUtils.getSendOrderTypes(locale);
        }
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        StringBuilder description = new StringBuilder();
        for (OrderType orderType : orderTypes) {
            if ("HCA".equals(orderType.getOrderType()) || "HIA".equals(orderType.getOrderType()) || "HSA".equals(orderType.getOrderType()) || "HVE".equals(orderType.getOrderType()) || "HVS".equals(orderType.getOrderType()) || "INI".equals(orderType.getOrderType()) || "PUB".equals(orderType.getOrderType()) || "SPR".equals(orderType.getOrderType())) continue;
            String orderTypeOrFileFormat = orderType.getFileFormat() != null ? orderType.getFileFormat() : orderType.getOrderType();
            description.setLength(0);
            PaymentTransferType.PmtType pmtType = SendParameters.getPmtType((BankSettings)bank, (String)orderTypeOrFileFormat);
            if (pmtType != null) {
                description.append(PaymentTypeUtil.getUniquePaymentName((Locale)locale, (PaymentTransferType.PmtType)pmtType)).append(" (").append(orderTypeOrFileFormat).append(')');
            }
            if (description.isEmpty()) {
                if (orderType.getDescription() != null) {
                    description.append(orderType.getDescription()).append(" (").append(orderTypeOrFileFormat).append(')');
                } else {
                    description.append(orderTypeOrFileFormat);
                }
            }
            result.add(Scala.Tuple((Object)orderTypeOrFileFormat, (Object)description.toString()));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    private static Seq<Tuple2<String, String>> getSendOrderTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (String orderType : SendOrderTypes.SEND_ORDER_TYPES) {
            Object description = SendOrderTypes.getDescription((String)orderType, (Locale)locale);
            description = description != null ? (String)description + " (" + orderType + ")" : orderType;
            result.add(Scala.Tuple((Object)orderType, (Object)description));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    public static Seq<Tuple2<String, String>> getFetchTypes(BankSettings bank, Locale locale) {
        List orderTypes = OrderTypeUtil.findOrderTypesForFetchDialog((BankSettings)bank);
        if (orderTypes.isEmpty()) {
            return GeneralUtils.getFetchOrderTypes(locale);
        }
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        StringBuilder description = new StringBuilder();
        for (OrderType orderType : orderTypes) {
            if ("HVD".equals(orderType.getOrderType()) || "HVT".equals(orderType.getOrderType()) || "HVU".equals(orderType.getOrderType()) || "HVZ".equals(orderType.getOrderType())) continue;
            String orderTypeOrFileFormat = orderType.getFileFormat() != null ? orderType.getFileFormat() : orderType.getOrderType();
            description.setLength(0);
            if (orderType.getDescription() != null) {
                description.append(orderType.getDescription()).append(" (").append(orderTypeOrFileFormat).append(')');
            } else {
                description.append(orderTypeOrFileFormat);
            }
            result.add(Scala.Tuple((Object)orderTypeOrFileFormat, (Object)description.toString()));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    private static Seq<Tuple2<String, String>> getFetchOrderTypes(Locale locale) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        for (String orderType : FetchOrderTypes.FETCH_ORDER_TYPES) {
            Object description = FetchOrderTypes.getDescription((String)orderType, (Locale)locale);
            description = description != null ? (String)description + " (" + orderType + ")" : orderType;
            result.add(Scala.Tuple((Object)orderType, (Object)description));
        }
        result.sort((o1, o2) -> ((String)o1._2).compareTo((String)o2._2));
        return Scala.toSeq(result);
    }

    public static Result supplyWorkspaceFile(final File file2, boolean plain, final boolean delete) throws IOException, GeneralSecurityException {
        InputStream inputStream = plain ? new FileInputStream(file2) : EncryptData.getInstance().openInputStream(file2);
        FilterInputStream inputStreamWrapper = new FilterInputStream(inputStream){

            @Override
            public void close() throws IOException {
                super.close();
                if (delete && !file2.delete()) {
                    file2.deleteOnExit();
                    BLLoggerPlay.error("Failed to delete file " + file2.getAbsolutePath() + "; will delete it on application exit!");
                }
            }
        };
        return Results.ok((InputStream)inputStreamWrapper);
    }

    public static Result supplyZipFile(List<File> files, boolean plain, boolean delete) throws IOException {
        HashMap<File, String> map = new HashMap<File, String>();
        for (File file2 : files) {
            map.put(file2, null);
        }
        return GeneralUtils.supplyZipFile(map, plain, delete);
    }

    public static Result supplyZipFile(Map<File, String> files, boolean plain, boolean delete) throws IOException {
        PipedInputStream in = new PipedInputStream();
        ZipOutputStream out = new ZipOutputStream(new PipedOutputStream(in));
        new Thread(() -> {
            block6: {
                try {
                    GeneralUtils.writeZipEntries(out, files, plain);
                }
                catch (IOException | GeneralSecurityException e) {
                    BLLoggerPlay.error("Failed to create ZIP file!", e);
                }
                finally {
                    Util.closeStream((Closeable)out);
                    if (!delete) break block6;
                    for (File file2 : files.keySet()) {
                        if (file2.delete()) continue;
                        file2.deleteOnExit();
                        BLLoggerPlay.warning("Failed to delete supplied file " + file2.getAbsolutePath() + "!");
                    }
                }
            }
        }).start();
        return Results.ok((InputStream)in);
    }

    public static String buildKeyDirForUser(User user) {
        File file2;
        String normalized = Normalizer.normalize(user.getName(), Normalizer.Form.NFD).replaceAll("[^A-Za-z0-9 ]", "");
        if (normalized.isEmpty()) {
            normalized = String.valueOf(user.getId());
        }
        String dir = "./keys/" + normalized;
        int counter = 1;
        do {
            if (!(file2 = new File(Util.WORKSPACEDIR, dir)).isDirectory()) continue;
            dir = "./keys/" + normalized + "." + counter++;
        } while (file2.isDirectory());
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeZipEntries(ZipOutputStream out, Map<File, String> files, boolean plain) throws IOException, GeneralSecurityException {
        HashMap<String, Integer> names = new HashMap<String, Integer>();
        for (Map.Entry<File, String> e : files.entrySet()) {
            String name = e.getValue();
            if (name == null) {
                name = e.getKey().getName();
            }
            String entryName = GeneralUtils.getUniqueFileName(name, names);
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            InputStream in = null;
            try {
                in = plain ? new FileInputStream(e.getKey()) : EncryptData.getInstance().openInputStream(e.getKey());
                Streams.copy((InputStream)in, (OutputStream)out, (boolean)false);
            }
            catch (Throwable throwable) {
                Util.closeStream(in);
                throw throwable;
            }
            Util.closeStream((Closeable)in);
            out.closeEntry();
        }
    }

    private static String getUniqueFileName(String name, Map<String, Integer> names) {
        if (names.containsKey(name)) {
            int count = names.get(name);
            names.put(name, count + 1);
            int i = name.contains(".") ? name.lastIndexOf(46) : name.length();
            return name.substring(0, i) + "_" + count + name.substring(i);
        }
        names.put(name, 1);
        return name;
    }

    public static <T> Form<T> formWithErrors(Form<T> form, List<ValidationError> errors) {
        for (ValidationError error : errors) {
            form = form.withError(error);
        }
        return form;
    }

    public static boolean printLogo(User forUser) {
        if (Branding.getBranding().alwaysPrintLogo()) {
            return true;
        }
        return Util.printLogo((User)forUser);
    }

    public static boolean checkUploadFile(String filename) {
        return GeneralUtils.checkUploadFile(filename, false);
    }

    public static boolean checkUploadFile(String filename, boolean allowTabularFiles) {
        if (filename != null && !filename.isEmpty()) {
            for (String suffix : new String[]{".exe", ".com", ".bat", ".sh", ".py", ".jar", ".app", ".dmg", ".php", ".html"}) {
                if (!filename.endsWith(suffix)) continue;
                return false;
            }
            if (!allowTabularFiles) {
                for (String suffix : new String[]{".xlsx"}) {
                    if (!filename.endsWith(suffix)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static String getFilenameAsHtmlAttachement(String filename) {
        if (filename.chars().allMatch(c -> c >= 32 && c < 127)) {
            return "attachment; filename=\"" + filename + "\"";
        }
        return "attachment; filename*=UTF-8''" + URLEncoder.encode(filename, StandardCharsets.UTF_8);
    }

    public static String getIniErrorMessage(Exception e, Messages messages, BankSettings bank) {
        String errorMsg = BankingApiMessages.getErrorMessageWeb((Exception)e, (Locale)messages.lang().locale());
        if (errorMsg.equals(e.toString())) {
            String hostOrUrl = "java.io.FileNotFoundException: " + bank.getUrl();
            if (errorMsg.equals(hostOrUrl)) {
                errorMsg = MessageFormat.format(BankingApiMessages.getString((Locale)messages.lang().locale(), (String)"GeneralMessages.error.ini.urlorhostid", (Object[])new Object[0]), bank.getUrl(), bank.getHostId());
                errorMsg = messages.at("ini.error", new Object[]{bank.getDisplayName(), errorMsg});
            } else {
                errorMsg = e.getLocalizedMessage();
            }
        }
        return messages.at("ini.error", new Object[]{bank.getDisplayName(), errorMsg});
    }

    public static Result handleLoadOverviewFailed(PersistenceException e, Messages messages, User user, Sorting.Table table, Call redirectTo) {
        BLLoggerPlay.error("Error while loading the content for overview table '" + String.valueOf(table) + "' for user '" + user.getName() + "' (" + user.getId() + "): " + e.getLocalizedMessage());
        Sorting sorting = Sorting.getSorting((User)user, (Sorting.Table)table);
        if (sorting == null || sorting.getSortingColumn() == null) {
            throw e;
        }
        Sorting.deleteByUserAndTable((User)user, (Sorting.Table)table);
        BLLoggerPlay.error("Deleted the sorting from the database for overview table '" + String.valueOf(table) + "' for user '" + user.getName() + "' (" + user.getId() + ").");
        String tableName = table.name();
        try {
            String l10nKey = SortingHandler.TableHandler.getHandler(table).getTableNameLocalizationKey();
            tableName = l10nKey.startsWith("GeneralMessages.") ? BankingApiMessages.getString((Locale)messages.lang().locale(), (String)l10nKey, (Object[])new Object[0]) : messages.at(l10nKey, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Results.redirect((Call)redirectTo).flashing("HTMLwarning", messages.at("error.sortingReset", new Object[]{tableName, routes.SendLogs.index()}));
    }

    private GeneralUtils() {
    }
}

