/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import controllers.util.BankOrder;
import de.businesslogics.banking.api.DisplayFileException;
import de.businesslogics.banking.api.KnownFormatException;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.DirectoryScanner;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FolderFileItem {
    private final DirectoryScanner directoryScanner;
    private final File file;
    private final String orderOrFileType;
    private String filename;
    private Date creationDate;
    private long fileSize = -1L;
    private String md5Hash;

    public static List<FolderFileItem> findForUser(User user) {
        ArrayList<FolderFileItem> result = new ArrayList<FolderFileItem>();
        StringBuilder sb = new StringBuilder();
        for (BankUser bankUser : BankUser.findActiveBanksForUser((User)user)) {
            for (DirectoryScanner directoryScanner : DirectoryScanner.findForBank((BankSettings)bankUser.getBank())) {
                File dir;
                Pattern pattern;
                boolean hasOrderType = false;
                if (directoryScanner.getRegEx() != null && !directoryScanner.getRegEx().isEmpty()) {
                    sb.setLength(0);
                    for (int i = 0; i < directoryScanner.getRegEx().length(); ++i) {
                        char c = directoryScanner.getRegEx().charAt(i);
                        if (c == '$' && i < directoryScanner.getRegEx().length() - 11 && "$(ORDERTYPE)".equals(directoryScanner.getRegEx().substring(i, i + 12))) {
                            sb.append("(.+)");
                            hasOrderType = true;
                            i += 12;
                            continue;
                        }
                        if (c == '*') {
                            sb.append(".*");
                            continue;
                        }
                        if (c == '?') {
                            sb.append('.');
                            continue;
                        }
                        if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                            sb.append('\\').append(c);
                            continue;
                        }
                        sb.append(c);
                    }
                    pattern = Pattern.compile(sb.toString());
                } else {
                    pattern = null;
                }
                if (!(dir = new File(directoryScanner.getDirectory())).exists() || !dir.isDirectory()) continue;
                File[] files = dir.listFiles();
                if (files == null) {
                    BLLoggerPlay.warning("Unable to list files for directory " + dir.getAbsolutePath() + ". Please check file permissions.");
                    continue;
                }
                for (File file2 : files) {
                    if (!file2.isFile() || file2.isHidden()) continue;
                    if (pattern != null) {
                        Matcher m = pattern.matcher(file2.getName());
                        if (!m.matches()) continue;
                        result.add(new FolderFileItem(directoryScanner, file2, hasOrderType ? m.group(1) : directoryScanner.getOrderOrFileType()));
                        continue;
                    }
                    result.add(new FolderFileItem(directoryScanner, file2, directoryScanner.getOrderOrFileType()));
                }
            }
        }
        return result;
    }

    public static List<FolderFileItem> fromString(String ids) {
        ArrayList<FolderFileItem> result = new ArrayList<FolderFileItem>();
        Matcher m = Pattern.compile("\\((\\d+)\\|([^|]+)\\|(([A-Z0-9]{3})|([A-Za-z0-9._:]+))\\)").matcher(ids);
        while (m.find()) {
            String id = m.group(1);
            String fileName = m.group(2);
            String orderTypeOrBTF = m.group(3);
            DirectoryScanner directoryScanner = (DirectoryScanner)DB.find(DirectoryScanner.class, (Object)Integer.valueOf(id));
            if (directoryScanner == null) {
                BLLoggerPlay.error("Did not find directory scanner with ID " + id);
                continue;
            }
            File file2 = new File(directoryScanner.getDirectory(), fileName);
            result.add(new FolderFileItem(directoryScanner, file2, orderTypeOrBTF));
        }
        return result;
    }

    private FolderFileItem(DirectoryScanner directoryScanner, File file2, String orderOrFileType) {
        this.directoryScanner = directoryScanner;
        this.file = file2;
        this.orderOrFileType = orderOrFileType != null && orderOrFileType.matches("[a-z0-9]{3}") ? orderOrFileType.toUpperCase() : orderOrFileType;
    }

    public BankSettings getBank() {
        return this.directoryScanner.getBank();
    }

    public String getOrderOrFileType() {
        return this.orderOrFileType;
    }

    public String getFilename() {
        if (this.filename == null) {
            this.filename = this.file.getAbsolutePath();
        }
        return this.filename;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            try {
                BasicFileAttributes attr = Files.readAttributes(this.file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                if (attr != null && attr.creationTime() != null) {
                    this.creationDate = new Date(attr.creationTime().toMillis());
                }
            }
            catch (IOException e) {
                BLLoggerPlay.error("Failed to determine the creation date for file " + this.file.getAbsolutePath() + "!", e);
            }
            if (this.creationDate == null) {
                this.creationDate = new Date(this.file.lastModified());
            }
        }
        return this.creationDate;
    }

    public long getFileSize() {
        if (this.fileSize < 0L) {
            this.fileSize = this.file.length();
        }
        return this.fileSize;
    }

    public BankOrder createBankOrder(User user, Locale locale) throws DisplayFileException, KnownFormatException, GeneralSecurityException, IOException {
        if (this.file == null || !this.file.isFile()) {
            BLLoggerPlay.error("User " + user.getName() + " tried to create a bank order for unknown file " + String.valueOf(this.file));
            return null;
        }
        BankUser bankUser = BankUser.findBankUser((BankSettings)this.directoryScanner.getBank(), (User)user);
        if (bankUser == null || bankUser.isDeactivated() || bankUser.getState() != BankUser.UserState.READY) {
            BLLoggerPlay.error("User " + user.getName() + " tried to create a bank order for illegal bank " + this.directoryScanner.getId());
            return null;
        }
        WorkspaceFile workspaceFile = new WorkspaceFile();
        workspaceFile.setPrefix(WorkspaceFile.Prefix.ABSOLUTE_FILE);
        workspaceFile.setPath(this.file.getAbsolutePath());
        workspaceFile.setSize(Long.valueOf(this.file.length()));
        workspaceFile.setMd5Hash(this.getMd5Hash());
        DB.save((Object)workspaceFile);
        return new BankOrder(bankUser, this.orderOrFileType, workspaceFile, this.directoryScanner, locale);
    }

    public String toString() {
        return String.valueOf(this.directoryScanner.getId()) + "|" + this.file.getName() + "|" + this.orderOrFileType;
    }

    public File getFile() {
        return this.file;
    }

    public Send findExistingOrder() throws GeneralSecurityException, IOException {
        return Send.findNewestByHash((String)this.getMd5Hash());
    }

    private String getMd5Hash() throws GeneralSecurityException, IOException {
        if (this.md5Hash == null) {
            this.md5Hash = SystemUtils.calculateMD5Hash((File)this.file);
        }
        return this.md5Hash;
    }

    public static final class Comparator
    implements java.util.Comparator<FolderFileItem> {
        private final int column;
        private final boolean ascending;

        public Comparator(int column, boolean ascending) {
            this.column = column;
            this.ascending = ascending;
        }

        @Override
        public int compare(FolderFileItem o1, FolderFileItem o2) {
            int result;
            if (o1 == null && o2 != null) {
                result = 1;
            } else if (o1 == null) {
                result = 0;
            } else if (o2 == null) {
                result = -1;
            } else if (this.column == 1) {
                result = o1.getFilename().compareTo(o2.getFilename());
            } else if (this.column == 2) {
                result = o1.getCreationDate().compareTo(o2.getCreationDate());
            } else if (this.column == 3) {
                long resultLong = o1.getFileSize() - o2.getFileSize();
                result = resultLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (resultLong < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)resultLong);
            } else {
                result = o1.getOrderOrFileType().compareTo(o2.getOrderOrFileType());
                if (result == 0) {
                    result = o1.getBank().getDisplayName().compareTo(o2.getBank().getDisplayName());
                }
            }
            if (this.ascending) {
                return result;
            }
            return -result;
        }
    }
}

