/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.vo.Fetch;
import de.businesslogics.banking.database.vo.Scheduler;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.banking.transfer.api.FreePreScheduler;
import de.businesslogics.banking.transfer.api.SchedulerProcessing;
import de.businesslogics.io.Streams;
import de.businesslogics.task.Substitution;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class FileExportPostProcessing
implements SchedulerProcessing {
    public static Substitution getExample() {
        Substitution s = new Substitution(new Date());
        s.addPlaceHolder("BANK", (Object)"Business-Logics Testbank");
        s.addPlaceHolder("ORDERTYPE", (Object)"HPD");
        s.addPlaceHolder("FILENAME", (Object)"HPD1234567890.HPD");
        return s;
    }

    public void doPostProcessing(Fetch item) {
    }

    public void doPostProcessing(Fetch item, Scheduler scheduler) throws Exception {
        if (scheduler == null) {
            return;
        }
        String exportDir = scheduler.getParameter();
        if (exportDir == null || exportDir.length() == 0) {
            return;
        }
        if (FreePreScheduler.class.getName().equals(scheduler.getOrderOrFileType())) {
            exportDir = FreePreScheduler.getExportDirFromParameter((String)scheduler.getParameter());
        }
        if (item != null) {
            File targetFile = this.getTargetFile(exportDir, item);
            if (!targetFile.getParentFile().exists() && !targetFile.getParentFile().mkdirs()) {
                throw new IOException("Failed to create directory for exported files: " + targetFile.getParentFile().getAbsolutePath());
            }
            File localFile = WorkspaceFileSystem.getFile((WorkspaceFile)item.getFile());
            FileOutputStream fos = new FileOutputStream(targetFile);
            InputStream fin = EncryptData.getInstance().openInputStream(localFile);
            Streams.copy((InputStream)fin, (OutputStream)fos);
        }
    }

    private File getTargetFile(String exportDir, Fetch item) {
        Substitution s = new Substitution((Date)item.getFetched());
        s.addPlaceHolder("BANK", (Object)FileExportPostProcessing.transform(item.getBank().getDisplayName()));
        s.addPlaceHolder("ORDERTYPE", (Object)FileExportPostProcessing.transform(item.getOrderType()));
        String filename = item.getFile().getPath();
        int lastSlash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
        if (lastSlash > 0) {
            filename = filename.substring(lastSlash + 1);
        }
        s.addPlaceHolder("FILENAME", (Object)filename);
        File result = new File(s.substitute(exportDir));
        if (result.isDirectory() || !this.looksLikeFile(result)) {
            result = new File(result, filename);
        }
        return result;
    }

    private boolean looksLikeFile(File file2) {
        if (file2.isFile()) {
            return true;
        }
        int lastDot = file2.getPath().lastIndexOf(".");
        return lastDot > 0 && file2.getPath().substring(lastDot).matches("\\.[A-Za-z0-9]+");
    }

    private static String transform(String in) {
        if (in == null) {
            return "";
        }
        in = in.replace('/', '_');
        in = in.replace('\\', '_');
        return in;
    }
}

