/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import controllers.util.SchedulerThrowableHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.database.vo.PaymentExchangeRate;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.payments.api.CurrencyUpdateRunner;
import de.businesslogics.banking.payments.core.PreferenceConstants;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class FetchExchangeRatesScheduler
implements Runnable {
    private final SchedulerThrowableHandler catcher;

    public FetchExchangeRatesScheduler(SchedulerThrowableHandler catcher) {
        this.catcher = catcher;
    }

    @Override
    public void run() {
        if (new DatabasePreferenceStore(Preference.ApplicationId.PAYMENTS, null).getBoolean((DatabasePreferenceConstant)PreferenceConstants.DISABLE_CURRENCY_UPDATE)) {
            return;
        }
        if (this.isDue()) {
            CurrencyUpdateRunner runner = new CurrencyUpdateRunner(BLLoggerPlay.getLogger());
            try {
                runner.run();
                if (runner.getException() != null) {
                    this.catcher.handleThrowable(runner.getException());
                }
            }
            catch (Throwable t) {
                this.catcher.handleThrowable(t);
            }
        }
    }

    private boolean isDue() {
        Timestamp latestExchangeDate = PaymentExchangeRate.getLatestExchangeRateDate();
        if (latestExchangeDate == null) {
            return true;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("CET"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        if (latestExchangeDate.before(cal.getTime())) {
            return true;
        }
        cal.add(5, 1);
        cal.set(11, 16);
        cal.set(12, 4);
        return cal.getTime().after(new Date());
    }
}

