/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.Setup;
import controllers.util.BLLoggerPlay;
import controllers.util.PasswordKeyEncryptionHandler;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.bank.DatabaseToken;
import de.businesslogics.banking.bank.PropertiesKeys;
import de.businesslogics.banking.bank.SecurityToken;
import de.businesslogics.banking.core.EbicsWorker;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.BankUser;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.database.vo.User;
import de.businesslogics.banking.preferences.PreferenceConstants;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.zkasecurity.PasswordCallback;
import de.businesslogics.zkasecurity.SimplePasswordCallback;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Locale;

public final class EbicsUtil {
    private static Product EBICS_PRODUCT = null;

    private static Product getEbicsProduct() {
        if (EBICS_PRODUCT == null) {
            EBICS_PRODUCT = new Product(Setup.PRODUCT_ID, Locale.getDefault(), Setup.INSTITUTE_ID);
        }
        return EBICS_PRODUCT;
    }

    public static EbicsWorker getEbicsWorker(BankUser bankUser) throws GeneralSecurityException, IOException {
        return EbicsUtil.getEbicsWorker(bankUser, DatabaseToken.getInstance((BankUser)bankUser, null), null);
    }

    public static EbicsWorker silentGetEbicsWorker(BankUser bankUser) {
        try {
            return EbicsUtil.getEbicsWorker(bankUser);
        }
        catch (Exception e) {
            BLLoggerPlay.getLogger().logWarning("can not build EbicsWorker.", (Throwable)e);
            return null;
        }
    }

    public static EbicsWorker getEbicsWorker(BankUser bankUser, char[] password2) throws GeneralSecurityException, IOException {
        DatabaseToken databaseToken = DatabaseToken.getInstance((BankUser)bankUser, null);
        if (!databaseToken.loadSignatureKey(bankUser, (PasswordCallback)new SimplePasswordCallback(password2))) {
            throw new IOException("Unable to load signature keys for bank user " + bankUser.getId());
        }
        return EbicsUtil.getEbicsWorker(bankUser, databaseToken, null);
    }

    public static EbicsWorker getEbicsWorker(BankUser bankUser, DatabaseToken databaseToken) throws GeneralSecurityException, IOException {
        return EbicsUtil.getEbicsWorker(bankUser, databaseToken, null);
    }

    public static EbicsWorker getEbicsWorker(BankUser bankUser, DatabaseToken databaseToken, EbicsWorker.IAcceptHashes acceptHashes) throws GeneralSecurityException, IOException {
        File logDir = EbicsUtil.getLogDir(bankUser.getUser());
        return new EbicsWorker(bankUser.getBank(), bankUser, (SecurityToken)databaseToken, EbicsUtil.getEbicsProduct(), acceptHashes, logDir);
    }

    public static File getLogDir(User user) {
        File logDir = null;
        if (new DatabasePreferenceStore(Preference.ApplicationId.BANKING, user).getBoolean((DatabasePreferenceConstant)PreferenceConstants.EBICS_TRACES)) {
            logDir = new File(new File(Util.WORKSPACEDIR, "ebicstraces"), String.valueOf(user.getId()));
        }
        return logDir;
    }

    public static boolean initializeUser(BankSettings bank, User user, BankUser newBankUser, char[] signaturePassword, Locale locale) throws Exception {
        BankUser oldBankUser = BankUser.findBankUser((BankSettings)bank, (User)user);
        if (newBankUser.getId() != null) {
            DB.update((Object)newBankUser);
        }
        boolean worked = false;
        try {
            DatabaseToken token = DatabaseToken.createNewToken((String)bank.getCustomerId(), (String)newBankUser.getDefaultUser(), (PropertiesKeys.SignatureVersion)PropertiesKeys.SignatureVersion.valueOf((String)newBankUser.getSignatureVersion()), (int)newBankUser.getSigKeyLength(), (int)newBankUser.getEncrKeyLength(), (int)newBankUser.getAuthKeyLength(), (boolean)newBankUser.isWithCerts(), (boolean)bank.useCertsWithoutExpirationDate(), (ProtocolVersion)ProtocolVersion.getInstance((String)bank.getProtocolVersion()));
            EbicsWorker w = EbicsUtil.getEbicsWorker(newBankUser, token);
            if (user.getKeyDirectory() == null) {
                user.setKeyDirectory("DATABASE");
                user.save();
            }
            worked = w.initialize(null, locale);
            token.saveTransportKeys(newBankUser, null);
            token.saveSignatureKey(newBankUser, signaturePassword);
            token.saveLockUserSignature(newBankUser);
            bank.save();
            newBankUser.save();
            EncryptData.checkForEncryptionKeyMigration((User)user, (EncryptData.KeyEncryptionHandler)new PasswordKeyEncryptionHandler(signaturePassword));
        }
        catch (Exception e) {
            if (e instanceof EbicsException) {
                BLLoggerPlay.error("Bank initialization failed for User (" + user.getId() + ") and Bank (" + bank.getBankId() + ", " + bank.getDisplayName() + "): " + e.getMessage());
            } else {
                BLLoggerPlay.error("Bank initialization failed for User (" + user.getId() + ") and Bank (" + bank.getBankId() + ", " + bank.getDisplayName() + ")!", e);
            }
            if (!worked && oldBankUser.getId() != null) {
                DB.update((Object)oldBankUser);
                newBankUser.setBank(oldBankUser.getBank());
                newBankUser.setUser(oldBankUser.getUser());
                newBankUser.setDefaultUser(oldBankUser.getDefaultUser());
                newBankUser.setAuthKeyLength(oldBankUser.getAuthKeyLength());
                newBankUser.setEncrKeyLength(oldBankUser.getEncrKeyLength());
                newBankUser.setSigKeyLength(oldBankUser.getSigKeyLength());
                newBankUser.setSignatureVersion(oldBankUser.getSignatureVersion());
                newBankUser.setState(oldBankUser.getState());
                DB.update((Object)newBankUser);
            }
            throw e;
        }
        return worked;
    }

    private EbicsUtil() {
    }
}

