/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.WorkspaceFileSystem;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.Account;
import de.businesslogics.banking.database.vo.BankSettings;
import de.businesslogics.banking.database.vo.DsOpenOrder;
import de.businesslogics.banking.database.vo.DsOrderDetails;
import de.businesslogics.banking.database.vo.PaymentTransferType;
import de.businesslogics.banking.database.vo.Send;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.HVTOrderInfo;
import de.businesslogics.ebics.schema.orders.HVTResponseOrderData;
import de.businesslogics.ebics.schema.types.AccountHolderRole;
import de.businesslogics.ebics.schema.types.AttributedAccount;
import de.businesslogics.format.sepa.SEPAPaymentData;
import de.businesslogics.format.sepa.StatusCode;
import de.businesslogics.iban.IbanUtil;
import io.ebean.Expr;
import io.ebean.Expression;
import io.ebean.ExpressionList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import models.payments.PaymentException;
import models.payments.PaymentHandler;
import org.xml.sax.SAXException;

public final class DsOrderPaymentInfo {
    private final PaymentHandler<?> payment;
    private final HVTOrderInfo hvtOrder;
    private final BankSettings bank;
    private boolean loadedInfo;
    private Account account;
    private String accountName;
    private String recipient;
    private String recipientAccount;
    private VOPInfo vopInfo;
    private BigDecimal amount;
    private String currency;
    private String purpose;
    private Date executionDate;
    private boolean isSalaryPayment = false;

    public static List<DsOrderPaymentInfo> loadForOpenOrder(DsOpenOrder dsOrder) {
        if (dsOrder.getOrderData() == null && dsOrder.getPaymentData() == null) {
            return new ArrayList<DsOrderPaymentInfo>(0);
        }
        WorkspaceFile workspaceFile = dsOrder.getOrderData() != null && PaymentHandler.isHandlerPresent(dsOrder.getPmtType()) ? dsOrder.getOrderData() : dsOrder.getPaymentData();
        if (workspaceFile == null) {
            BLLoggerPlay.error("Missing data file for open EDS order, null in database.");
            return new ArrayList<DsOrderPaymentInfo>(0);
        }
        File orderDataFile = WorkspaceFileSystem.getFile((WorkspaceFile)workspaceFile);
        if (!orderDataFile.exists() || !orderDataFile.isFile()) {
            BLLoggerPlay.error("Missing data file for open EDS order: " + orderDataFile.getAbsolutePath());
            return new ArrayList<DsOrderPaymentInfo>();
        }
        return DsOrderPaymentInfo.loadFromFile(orderDataFile, dsOrder.getPmtType(), dsOrder.getBankUser().getBank(), DsOrderPaymentInfo.loadFromHVTResponse(dsOrder));
    }

    public static List<DsOrderPaymentInfo> loadForHistoricalOrder(DsOrderDetails dsOrder) {
        if (dsOrder.getDataFile() == null) {
            return new ArrayList<DsOrderPaymentInfo>(0);
        }
        File orderDataFile = WorkspaceFileSystem.getFile((WorkspaceFile)dsOrder.getDataFile());
        if (!orderDataFile.exists() || !orderDataFile.isFile()) {
            BLLoggerPlay.error("Missing data file for EDS order: " + orderDataFile.getAbsolutePath());
            return new ArrayList<DsOrderPaymentInfo>();
        }
        return DsOrderPaymentInfo.loadFromFile(orderDataFile, dsOrder.getPmtType(), dsOrder.getBank(), null);
    }

    public static List<DsOrderPaymentInfo> loadForSendOrder(Send send) {
        if (send.getFile() == null) {
            return new ArrayList<DsOrderPaymentInfo>(0);
        }
        File orderDataFile = WorkspaceFileSystem.getFile((WorkspaceFile)send.getFile());
        if (!orderDataFile.exists() || !orderDataFile.isFile()) {
            BLLoggerPlay.error("Missing data file for sent order: " + orderDataFile.getAbsolutePath());
            return new ArrayList<DsOrderPaymentInfo>();
        }
        return DsOrderPaymentInfo.loadFromFile(orderDataFile, send.getPmtType(), send.getBank(), null);
    }

    private static VOPInfo getVOPInfo(HVTOrderInfo order) {
        List accountInfos = order.getAccountInfos();
        String name = null;
        String iban = null;
        for (AttributedAccount account : accountInfos) {
            if (account.getAccountHolder() == null || !account.getAccountHolder().getRole().equals((Object)AccountHolderRole.Recipient)) continue;
            name = account.getAccountHolder().getValue();
            if (account.getAccountNumber() != null) {
                iban = account.getAccountNumber().getValue();
            }
            if (account.getAccountNumber2() == null) continue;
            iban = account.getAccountNumber2().getValue();
        }
        if (name != null && iban != null) {
            VOPInfo info = new VOPInfo();
            info.name = name;
            info.iban = iban;
            List list = order.getDescriptions();
            for (HVTOrderInfo.MyDescription description : list) {
                if (!description.getType().equals((Object)HVTOrderInfo.DescriptionType.Comment)) continue;
                try {
                    info.result = StatusCode.VopResultCodes.valueOf((String)description.getValue());
                }
                catch (IllegalArgumentException e) {
                    info.comment = description.getValue();
                }
            }
            return info;
        }
        return null;
    }

    public static Map<String, VOPInfo> loadFromHVTResponse(DsOpenOrder openOrder) {
        if (openOrder.getPaymentData() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, VOPInfo> responseMap = new HashMap<String, VOPInfo>();
        File file2 = WorkspaceFileSystem.getFile((WorkspaceFile)openOrder.getPaymentData());
        HVTResponseOrderData hvt = new HVTResponseOrderData(null, null, null);
        try (InputStream orderDataInputStream = EncryptData.getInstance().openInputStream(file2);){
            EbicsHandler handler = new EbicsHandler((ElementParser)new EbicsRootParser(null, (EbicsElement)hvt));
            handler.setValidate(false);
            handler.parse(orderDataInputStream, (String)null);
        }
        catch (Exception e) {
            BLLoggerPlay.error("Can not parse HVT response: ", e);
        }
        for (HVTOrderInfo order : hvt.getOrderInfos()) {
            VOPInfo info = DsOrderPaymentInfo.getVOPInfo(order);
            if (info == null) continue;
            responseMap.put(info.iban + info.name, info);
        }
        return responseMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DsOrderPaymentInfo> loadFromFile(File file2, PaymentTransferType.PmtType pmtType, BankSettings bank, Map<String, VOPInfo> vopInfoMap) {
        ArrayList<DsOrderPaymentInfo> result = new ArrayList<DsOrderPaymentInfo>();
        InputStream orderDataInputStream = null;
        try {
            orderDataInputStream = EncryptData.getInstance().openInputStream(file2);
            if (PaymentHandler.isHandlerPresent(pmtType)) {
                for (PaymentHandler<?> payment : PaymentHandler.getHandlers(orderDataInputStream, pmtType, bank.getCountryCode())) {
                    VOPInfo info = null;
                    if (vopInfoMap != null) {
                        info = vopInfoMap.get(payment.getRecipientAccountNumber() + payment.getRecipient());
                    }
                    result.add(new DsOrderPaymentInfo(payment, bank, info));
                }
            } else {
                HVTResponseOrderData hvt = new HVTResponseOrderData(null, null, null);
                EbicsHandler handler = new EbicsHandler((ElementParser)new EbicsRootParser(null, (EbicsElement)hvt));
                handler.setValidate(false);
                handler.parse(orderDataInputStream, (String)null);
                for (HVTOrderInfo order : hvt.getOrderInfos()) {
                    result.add(new DsOrderPaymentInfo(order, bank));
                }
            }
        }
        catch (IOException | GeneralSecurityException | PaymentException | SAXException e) {
            BLLoggerPlay.error("Failed to load payment information from DS order file " + file2.getAbsolutePath() + "!", e);
            ArrayList<DsOrderPaymentInfo> arrayList = new ArrayList<DsOrderPaymentInfo>(0);
            return arrayList;
        }
        finally {
            if (orderDataInputStream != null) {
                try {
                    orderDataInputStream.close();
                }
                catch (IOException e) {
                    BLLoggerPlay.error("Failed to close input stream on DS order file " + file2.getAbsolutePath() + "!", e);
                }
            }
        }
        return result;
    }

    public static Account findUnknownAccount(BankSettings bank, String accountNumber, String bankCode, String currency) {
        ExpressionList expression = DB.find(Account.class).where().eq("bank", (Object)bank);
        if (bankCode != null) {
            expression.add(Expr.or((Expression)Expr.and((Expression)Expr.eq((String)"iban", (Object)accountNumber), (Expression)Expr.or((Expression)Expr.eq((String)"bic", (Object)bankCode), (Expression)Expr.isNull((String)"bic"))), (Expression)Expr.or((Expression)Expr.and((Expression)Expr.eq((String)"germanAccountNumber", (Object)accountNumber), (Expression)Expr.eq((String)"germanBankCode", (Object)bankCode)), (Expression)Expr.and((Expression)Expr.eq((String)"nationalAccountNumber", (Object)accountNumber), (Expression)Expr.eq((String)"nationalBankCode", (Object)bankCode)))));
        } else {
            expression.add(Expr.or((Expression)Expr.eq((String)"iban", (Object)accountNumber), (Expression)Expr.and((Expression)Expr.and((Expression)Expr.eq((String)"nationalAccountNumber", (Object)accountNumber), (Expression)Expr.isNotNull((String)"nationalAccountNumber")), (Expression)Expr.isNull((String)"nationalBankCode"))));
        }
        if (currency != null) {
            expression.add(Expr.or((Expression)Expr.isNull((String)"currency"), (Expression)Expr.eq((String)"currency", (Object)currency)));
        }
        return (Account)expression.setMaxRows(1).findOne();
    }

    private DsOrderPaymentInfo(PaymentHandler<?> payment, BankSettings bank, VOPInfo vopInfo) {
        this.payment = payment;
        this.bank = bank;
        this.hvtOrder = null;
        this.vopInfo = vopInfo;
    }

    private DsOrderPaymentInfo(HVTOrderInfo order, BankSettings bank) {
        this.payment = null;
        this.bank = bank;
        this.hvtOrder = order;
        this.vopInfo = DsOrderPaymentInfo.getVOPInfo(order);
    }

    public PaymentHandler<?> getPayment() {
        return this.payment;
    }

    public HVTOrderInfo getHvtOrder() {
        return this.hvtOrder;
    }

    public Account getAccount() {
        this.loadInfoIfNeeded();
        return this.account;
    }

    public String getAccountName() {
        this.loadInfoIfNeeded();
        return this.accountName;
    }

    public String getRecipient() {
        this.loadInfoIfNeeded();
        return this.recipient;
    }

    public String getRecipientAccount() {
        this.loadInfoIfNeeded();
        return this.recipientAccount;
    }

    public BigDecimal getAmount() {
        this.loadInfoIfNeeded();
        return this.amount;
    }

    public String getCurrency() {
        this.loadInfoIfNeeded();
        return this.currency;
    }

    public String getPurpose() {
        this.loadInfoIfNeeded();
        return this.purpose;
    }

    public Date getExecutionDate() {
        this.loadInfoIfNeeded();
        return this.executionDate;
    }

    public boolean isSalaryPayment() {
        this.loadInfoIfNeeded();
        return this.isSalaryPayment;
    }

    public StatusCode.VopResultCodes getResult() {
        if (this.vopInfo != null) {
            return this.vopInfo.result;
        }
        return null;
    }

    public String getTooltip() {
        if (this.vopInfo != null) {
            return this.vopInfo.comment;
        }
        return null;
    }

    private void loadInfoIfNeeded() {
        if (this.loadedInfo) {
            return;
        }
        if (this.payment != null) {
            Object p;
            this.account = this.payment.getOriginatorAccount(this.bank);
            this.accountName = this.payment.getAccountRepresentation(this.account);
            this.recipient = this.payment.getRecipient();
            this.amount = this.payment.getAmount();
            this.currency = this.payment.getCurrencyCode();
            this.purpose = this.payment.getPurpose();
            this.executionDate = this.payment.getExecutionDate();
            this.isSalaryPayment = this.payment.isSalaryPayment();
            if (this.payment.getPayment() != null && (p = this.payment.getPayment()) instanceof SEPAPaymentData) {
                this.recipientAccount = IbanUtil.formatIBAN((String)((SEPAPaymentData)p).getRecipientIban());
            }
        } else if (this.hvtOrder != null) {
            for (AttributedAccount acc : this.hvtOrder.getAccountInfos()) {
                if (acc.getAccountHolder() == null) continue;
                if (acc.getAccountHolder().getRole() == AccountHolderRole.Originator) {
                    String accountNumber2;
                    String accountNumber1 = acc.getAccountNumber() != null ? acc.getAccountNumber().getValue() : null;
                    String string = accountNumber2 = acc.getAccountNumber2() != null ? acc.getAccountNumber2().getValue() : null;
                    if (accountNumber1 == null && accountNumber2 == null) continue;
                    String bankCode1 = acc.getBankCode() != null ? acc.getBankCode().getValue() : null;
                    String bankCode2 = acc.getBankCode2() != null ? acc.getBankCode2().getValue() : null;
                    String accountCurrency = acc.getCurrency() != null ? acc.getCurrency().getCurrencyCode() : null;
                    Account accountVO = DsOrderPaymentInfo.findUnknownAccount(this.bank, accountNumber1, bankCode1, accountCurrency);
                    if (accountVO == null) {
                        accountVO = DsOrderPaymentInfo.findUnknownAccount(this.bank, accountNumber2, bankCode2, accountCurrency);
                    }
                    if (accountVO != null) {
                        this.account = accountVO;
                        this.accountName = Account.getDefaultDisplayName((Account)accountVO);
                        continue;
                    }
                    this.account = null;
                    Object accountInfo = bankCode1 != null ? bankCode1 + "/" : (bankCode2 != null ? bankCode2 + "/" : "");
                    accountInfo = accountNumber1 != null ? (String)accountInfo + accountNumber1 : (String)accountInfo + accountNumber2;
                    this.accountName = accountInfo;
                    continue;
                }
                if (acc.getAccountHolder().getRole() != AccountHolderRole.Recipient) continue;
                this.recipient = acc.getAccountHolder().getValue();
                this.recipientAccount = acc.getAccountNumber().getValue();
            }
            if (this.hvtOrder.getAmount() != null) {
                this.amount = this.hvtOrder.getAmount().getValue();
                this.currency = this.hvtOrder.getAmount().getCurrency() != null ? this.hvtOrder.getAmount().getCurrency().getCurrencyCode() : "EUR";
            }
            for (HVTOrderInfo.MyDescription description : this.hvtOrder.getDescriptions()) {
                if (description.getType() != HVTOrderInfo.DescriptionType.Purpose) continue;
                this.purpose = description.getValue();
                break;
            }
            if (this.hvtOrder.getExecutionDate() != null) {
                this.executionDate = this.hvtOrder.getExecutionDate().getDate();
            }
        }
        this.loadedInfo = true;
    }

    public static class VOPInfo {
        String name;
        String iban;
        StatusCode.VopResultCodes result;
        String comment;

        public String getComment() {
            return this.comment;
        }

        public String getIban() {
            return this.iban;
        }

        public String getName() {
            return this.name;
        }

        public StatusCode.VopResultCodes getResult() {
            return this.result;
        }
    }
}

