/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import play.data.format.Formatters;
import views.Utils;

public final class DateFormatter
extends Formatters.SimpleFormatter<Date> {
    public Date parse(String string, Locale locale) throws ParseException {
        Locale userLocale = Utils.getLocaleForDatePicker(locale);
        if (!userLocale.equals(locale)) {
            try {
                return this.parse(string, userLocale);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        int[] formats = new int[]{3, 2, 1, 0};
        ParseException caughtException = null;
        for (int format : formats) {
            try {
                return DateFormat.getDateInstance(format, locale).parse(string.trim());
            }
            catch (ParseException e) {
                if (caughtException != null) continue;
                caughtException = e;
            }
        }
        throw caughtException;
    }

    public String print(Date date2, Locale locale) {
        return Utils.getJavaDatePickerFormat(locale).format(date2);
    }
}

