/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import controllers.util.SchedulerThrowableHandler;
import java.util.Calendar;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DailyScheduleHandler {
    private static final ScheduledExecutorService SCHEDULE_SERVICE = new ScheduledThreadPoolExecutor(1);
    private static SchedulerThrowableHandler throwableHandler;

    public static void schedule(Runnable runnable, boolean now) {
        DailyScheduleHandler.schedule(runnable, now, 0, 0);
    }

    public static void schedule(Runnable runnable, boolean now, int hour, int minute) {
        long delay;
        if (now) {
            delay = 0L;
        } else {
            Calendar cal = Calendar.getInstance();
            cal.set(11, hour);
            cal.set(12, minute);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 1);
            delay = cal.getTimeInMillis() - System.currentTimeMillis();
        }
        SCHEDULE_SERVICE.schedule(() -> {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                DailyScheduleHandler.reportThrowable(t);
            }
            DailyScheduleHandler.schedule(runnable, false, hour, minute);
        }, delay, TimeUnit.MILLISECONDS);
    }

    public static SchedulerThrowableHandler getCatcher() {
        if (throwableHandler == null) {
            throwableHandler = DailyScheduleHandler::reportThrowable;
        }
        return throwableHandler;
    }

    private static void reportThrowable(Throwable t) {
        BLLoggerPlay.error("Error occurred in scheduled process!", t);
    }

    private DailyScheduleHandler() {
    }
}

