/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.AbstractCsvExport;
import de.businesslogics.banking.api.EncryptData;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.api.DB;
import de.businesslogics.banking.database.vo.WorkspaceFile;
import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import play.i18n.Messages;
import play.libs.Scala;
import scala.Tuple2;
import scala.collection.immutable.Seq;

public final class CsvImport {
    public static Seq<Tuple2<String, String>> getColumns(String[][] importData, Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)""));
        if (importData != null && importData.length > 0) {
            int columns = 0;
            for (String[] line : importData) {
                if (line == null || line.length <= columns) continue;
                columns = line.length;
            }
            for (int i = 0; i < columns; ++i) {
                result.add(Scala.Tuple((Object)String.valueOf(i), (Object)messages.at("csv.column", new Object[]{i + 1})));
            }
        }
        return Scala.toSeq(result);
    }

    public static String getTableContentString(String[][] content) {
        if (content == null || content.length == 0) {
            return "";
        }
        ArrayList items = new ArrayList();
        Collections.addAll(items, content);
        StringWriter writer = new StringWriter();
        try {
            new AbstractCsvExport<String[]>(){

                protected boolean writeItem(Writer writer, String[] item) throws IOException {
                    if (item == null || item.length == 0) {
                        return false;
                    }
                    for (String info : item) {
                        this.addCell(writer, info);
                    }
                    return true;
                }

                protected boolean writeHeader(Writer writer) {
                    return false;
                }
            }.write((Writer)writer, items);
        }
        catch (IOException e) {
            BLLoggerPlay.error("Failed to convert table content to text!", e);
        }
        return ((Object)writer).toString();
    }

    public static Seq<Tuple2<String, String>> getLanguages(Messages messages) {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        result.add(Scala.Tuple((Object)"", (Object)messages.at("csv.numberformat.simple", new Object[0])));
        result.add(Scala.Tuple((Object)Locale.GERMAN.getLanguage(), (Object)messages.at("csv.numberformat.german", new Object[0])));
        result.add(Scala.Tuple((Object)Locale.ENGLISH.getLanguage(), (Object)messages.at("csv.numberformat.english", new Object[0])));
        return Scala.toSeq(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeDataToFile(String[][] data) throws IOException, GeneralSecurityException {
        File file2 = Util.createTempFile((String)"csvimport", (String)".csv", (boolean)false);
        OutputStream outputStream = null;
        try {
            ArrayList lines = new ArrayList(data.length);
            Collections.addAll(lines, data);
            outputStream = EncryptData.getInstance().openOutputStream(file2);
            new AbstractCsvExport<String[]>(){

                protected boolean writeHeader(Writer writer) {
                    return false;
                }

                protected boolean writeItem(Writer writer, String[] line) throws IOException {
                    if (line != null && line.length > 0) {
                        for (String column : line) {
                            this.addCell(writer, column);
                        }
                        return true;
                    }
                    return false;
                }
            }.write(outputStream, lines);
        }
        catch (Throwable throwable) {
            SystemUtils.close(outputStream);
            throw throwable;
        }
        SystemUtils.close((AutoCloseable)outputStream);
        WorkspaceFile wf = new WorkspaceFile();
        wf.setSize(Long.valueOf(file2.length()));
        wf.setPrefix(WorkspaceFile.Prefix.TEMPORARY_FILE);
        wf.setPath(file2.getName());
        DB.save((Object)wf);
        return wf.getId().toString();
    }

    public static WorkspaceFile getFileById(String fileId) {
        return (WorkspaceFile)DB.find(WorkspaceFile.class, (Object)Long.valueOf(fileId));
    }

    private CsvImport() {
    }

    public static final class Field {
        private final String textKey;
        private final String fieldId;
        private final boolean mandatory;
        private final FieldType type;
        private final Seq<Tuple2<String, String>> options;

        public static Field getSeparator() {
            return new Field("", "", false, FieldType.SEPARATOR, null);
        }

        public static Field getTextField(String textKey, String fieldId, boolean mandatory) {
            return new Field(textKey, fieldId, mandatory, FieldType.TEXT, null);
        }

        public static Field getSelectField(String textKey, String fieldId, boolean mandatory, Seq<Tuple2<String, String>> options) {
            return new Field(textKey, fieldId, mandatory, FieldType.COMBO, options);
        }

        public static Field getBooleanField(String textKey, String fieldId, boolean mandatory) {
            return new Field(textKey, fieldId, mandatory, FieldType.BOOLEAN, null);
        }

        private Field(String textKey, String fieldId, boolean mandatory, FieldType type, Seq<Tuple2<String, String>> options) {
            this.textKey = textKey;
            this.fieldId = fieldId;
            this.mandatory = mandatory;
            this.type = type;
            this.options = options;
        }

        public String getTextKey() {
            return this.textKey;
        }

        public String getFieldId() {
            return this.fieldId;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public FieldType getType() {
            return this.type;
        }

        public Seq<Tuple2<String, String>> getOptions() {
            return this.options;
        }
    }

    public static enum FieldType {
        TEXT,
        BOOLEAN,
        COMBO,
        SEPARATOR;

    }
}

