/*
 * Decompiled with CFR 0.152.
 */
package controllers.util;

import controllers.util.BLLoggerPlay;
import de.businesslogics.banking.api.DatabasePreferenceConstant;
import de.businesslogics.banking.api.DatabasePreferenceStore;
import de.businesslogics.banking.api.ProgressMonitorDummy;
import de.businesslogics.banking.api.Util;
import de.businesslogics.banking.database.vo.Preference;
import de.businesslogics.banking.ds.api.DsCleanUp;
import de.businesslogics.banking.mt940.api.CmCleanUp;
import de.businesslogics.banking.preferences.CmPreferenceConstants;
import de.businesslogics.banking.transfer.api.TransferCleanUp;
import de.businesslogics.banking.transfer.gui.PreferenceConstants;
import de.businesslogics.util.IProgressMonitorWrapper;

public final class CleanupScheduler
implements Runnable {
    @Override
    public void run() {
        TransferCleanUp cleanUp;
        DatabasePreferenceStore pref = new DatabasePreferenceStore(Preference.ApplicationId.TRANSFER, null);
        if (pref.getBoolean((DatabasePreferenceConstant)PreferenceConstants.CLEAN_UP)) {
            cleanUp = new TransferCleanUp();
            cleanUp.doCleanup(pref, (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Automatic transfer data cleanup was executed.");
        }
        if ((pref = new DatabasePreferenceStore(Preference.ApplicationId.BANKING, null)).getBoolean((DatabasePreferenceConstant)de.businesslogics.banking.preferences.PreferenceConstants.DS_CLEAN_UP)) {
            cleanUp = new DsCleanUp();
            cleanUp.doCleanup(pref, (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Automatic des data cleanup was executed.");
        }
        if ((pref = new DatabasePreferenceStore(Preference.ApplicationId.CM, null)).getBoolean((DatabasePreferenceConstant)CmPreferenceConstants.CLEAN_AUTOMATIC)) {
            cleanUp = new CmCleanUp();
            cleanUp.doCleanup(pref, (IProgressMonitorWrapper)ProgressMonitorDummy.getInstance());
            BLLoggerPlay.info("Automatic cm data cleanup was executed.");
        }
        BLLoggerPlay.info("Cleaning up tmp directory.");
        Util.cleanupTempdir();
    }
}

